/*      xmms - esound output plugin
 *    Copyright (C) 1999      Galex Yen
 *      
 *      this program is free software
 *      
 *      Description:
 *              This program is an output plugin for xmms v0.9 or greater.
 *              The program uses the esound daemon to output audio in order
 *              to allow more than one program to play audio on the same
 *              device at the same time.
 *
 *              Contains code Copyright (C) 1998-1999 Mikael Alm, Olle Hallnas,
 *              Thomas Nillson and 4Front Technologies
 *
 */

#ifndef ESDOUT_H
#define ESDOUT_H

#include "config.h"

#include <gtk/gtk.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <esd.h>

#include <fcntl.h>
#include <unistd.h>
#include <pthread.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "xmms/plugin.h"
#include "libxmms/util.h"

extern OutputPlugin op;

typedef struct
{
	gboolean use_remote;
	gchar *server;
	gint port;
	gint buffer_size;
	gint prebuffer;
}
ESDConfig;

extern ESDConfig esd_cfg;

void esdout_init(void);
void esdout_about(void);
void esdout_configure(void);

void esdout_get_volume(int *l, int *r);
void esdout_set_volume(int l, int r);

int esdout_playing(void);
int esdout_free(void);
void esdout_write(void *ptr, int length);
void esdout_close(void);
void esdout_flush(int time);
void esdout_pause(short p);
int esdout_open(AFormat fmt, int rate, int nch);
int esdout_get_output_time(void);
int esdout_get_written_time(void);
void esdout_set_audio_params(void);

#endif
