// -*- C++ -*-

//
//  klpq
//
//  Copyright (C) 1997 Christoph Neerfeld
//  email:  Christoph.Neerfeld@home.ivm.de or chris@kde.org
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

extern "C" {
#include <unistd.h>
#include <signal.h>
};

#include <qapplication.h>
#include <qdir.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qstrlist.h>

#include <kapp.h>

#include "klpq.h"
#include <klocale.h>
#include <kconfig.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

Klpq *main_widget;

static const char *description =
	I18N_NOOP("KDE Print Queue utility.");

static const char *version = KLPQ_VERSION "\n"
"Copyright 1997,98 Christoph Neerfeld.\n"
"Christoph.Neerfeld@home.ivm.de or chris@kde.org";

static KCmdLineOptions option[] =
{
   { "n", 0, 0 },
   { "nopopup", I18N_NOOP("Don't popup window. Just print the file"), 0},
   { "P <printer>", I18N_NOOP("Print to 'printer'"), 0},
   { "+[file(s)]", I18N_NOOP("Files to print"), 0 },
   { 0, 0, 0 }
};

int main( int argc, char **argv )
{
  KAboutData aboutData("klpq", I18N_NOOP("KPrintQueue"),
    version, description, KAboutData::License_GPL,
    "(c) 1997, Christoph Neerfeld");
  aboutData.addAuthor("Christoph Neerfeld",0, "chris@kde.org");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( option );

  KApplication a;

  KConfig *config = a.config();
  config->setGroup("klpq");

  QStrList file_list;
  QString choice = QString::fromLatin1(getenv("PRINTER"));
  QString last_printer = config->readEntry("lastQueue", "lp");

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

  bool popup = args->isSet("popup");
fprintf(stderr, "Popup is %s\n", popup ? "true" : "false");

  if (args->isSet("P"))
     choice = QString::fromLatin1(args->getOption("P"));

  for( int i = 0; i < args->count(); i++ )
  {
     QCString progname = "lpr ";
     if ( !choice.isNull() )
     {
        progname = progname + "-P \"" + choice.ascii() + "\" ";
     }
     QString file = QFile::decodeName(args->arg(i));
     if( file.left(5) == "file:" )
     {
         progname += "\""+QFile::encodeName(file.remove(0,5))+"\"";
         system(progname.data());
     }
     else if( file.left(5) == "http:" || file.left(4) == "ftp:" )
     {
         file_list.append( choice + ":" + file);
     }
     else
     {	
         progname = progname + "\""+args->arg(i)+"\"";
         system(progname.data());
     }
  }
  args->clear();

  Klpq *main_widget = new Klpq;
  if( file_list.count() != 0 )
  {
      main_widget->printRemote(file_list);
  }
  else if( !popup )
  {
      exit(0);
  }

  bool empty_printcap = TRUE;

  bool no_printcap = TRUE;
  int iprintcap=0,nprintcap=1;
  char pcpath[3][80]={"/etc/printers.conf", "/etc/printcap",
                      "/usr/local/etc/printcap"};
  while (iprintcap <= nprintcap)
    {
      QFile printcap(pcpath[iprintcap]);
      if( !printcap.open(IO_ReadOnly) )
	{
	  iprintcap++;
	  continue;
	}
      no_printcap = FALSE;
      QTextStream st( (QIODevice *) &printcap);
      while( !st.eof() )
	{
	  QString temp = st.readLine();
	  temp = temp.stripWhiteSpace();
	  if( temp[0] == '#' || temp.isEmpty() )
	    continue;
	  QString name = temp.left( temp.find(':') );
	  if( name.isEmpty() )
	    continue;
	  //debug("name = %s", (const char *) name);
	  if( name.contains('|') )
	    name = name.left( name.find('|') );
	  name = name.stripWhiteSpace();
	  if( name.isEmpty() )
	    continue;
	  else
	    empty_printcap = FALSE;
	  /*
	  do {
	    temp = st.readLine();
	    temp = temp.stripWhiteSpace();
	    if( temp[0] == '#')
	      temp = ":";
	  } while( temp.simplifyWhiteSpace().left(1) == (QString) ":");
	  */
          if(name.right(1) == "\\" )
            name = name.left(name.length() - 1);
	  main_widget->addPrintQueue(name);
	  if( choice.isEmpty() && name == last_printer )
	    main_widget->setLastPrinterCurrent();
	  if( name == choice)
	    main_widget->setLastPrinterCurrent();
	}
      printcap.close();
      iprintcap++;
    }
  if( no_printcap )
    {
      debug(i18n("Sorry, can't open your printcap file."));
      exit(1);
    }
  if( empty_printcap )
    {
      debug(i18n("Sorry, unable to parse your printcap."));
      debug(i18n("Please email your printcap to Christoph.Neerfeld@home.ivm.de"));
      exit(1);
    }

  a.setMainWidget( main_widget );
  main_widget->callUpdate();
  if( popup )
    main_widget->show();
  return a.exec();
}





