#include "look_edit_tabtelephone.h"
#include <addressbook.h>
#include <klocale.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qstringlist.h>

TabTelephone::TabTelephone(QWidget *parent)
  : TabBasic(parent)    
{
  const int NoOfFields=AddressBook::NoOfTelephoneTypes-1;
  const int NoOfColumns=2;
  const int Border=3;
  const int Space=2;
  const int Col1=0;
  const int Col2=1;
  QString texts[] = {
    i18n("Fixed:"),
    i18n("Mobile:"),
    i18n("Fax:"),
    i18n("Modem:"),
    i18n("User defined 1:"),
    i18n("User defined 2:"),
    i18n("User defined 3:")
  };
  QStringList strings;
  int row=0;
  int count;
  // -----
  for(count=0; count<sizeof(texts)/sizeof(texts[0]); ++count)
    {
      strings.append(texts[count]);
    }
  QGridLayout* layout=new QGridLayout(this, NoOfFields+1, NoOfColumns, Border, Space);
  QLabel *header1=new QLabel(i18n("Type"), this);
  layout->addWidget(header1, row, Col1);
  QLabel *header2=new QLabel(i18n("Number"), this);
  layout->addWidget(header2, row, Col2);
  ++row;
  boxes=new QComboBox*[NoOfFields];
  lineedits=new QLineEdit*[NoOfFields];
  for(count=0; count<NoOfFields; ++count)
    {
      boxes[count]=new QComboBox(false, this);
      boxes[count]->insertStringList(strings);
      layout->addWidget(boxes[count], row+count, Col1);
      lineedits[count]=new QLineEdit(this);
      layout->addWidget(lineedits[count], row+count, Col2);
    }
}

void TabTelephone::storeContents(AddressBook::Entry& entry)
{
}

void TabTelephone::setContents(const AddressBook::Entry& entry)
{
}

