/* This file implements the editing look.
 *
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.10 $
 */

#ifndef LOOK_EDIT_H
#define LOOK_EDIT_H

#include "look_basic.h"

class QTabWidget;
class TabPerson;
class TabAddresses;
class TabBirthday;
class TabBasic;
class TabComment;
class TabUser;
class TabContact;
class TabTelephone;

class KABEditLook : public KABBasicLook
{
  Q_OBJECT
public:
  /** The constructor. */
  KABEditLook(KabAPI*, QWidget* parent=0, const char* name=0);
  /** Overload basic set entry method. */
  void setEntry(const AddressBook::Entry&);
  /** Overload method to get the entry. */
  void getEntry(AddressBook::Entry& entry); 
protected:
  /** The tabulator widget. */
  QTabWidget *tabs;
  // WORK_TO_DO: check if pointers are really needed
  /** The person tab. */
  TabPerson *tabperson;
  /** The telephone tab. */
  TabTelephone *tabtelephone;
  /** The birthday tab. */
  TabBirthday *tabbirthday;
  /** The comment tab. */
  TabComment *tabcomment;
  /** The user fields tab. */
  TabUser *tabuser;
  /** The tab to enter contact information. */
  TabContact *tabcontact;
  /** The tab to edit the addresses. */
  TabAddresses *tabaddresses;
  /** A list of all tabs. */
  QList<TabBasic*> allTabs;
  /** The resize event. */
  void resizeEvent(QResizeEvent*);
public slots:
  /** Emitted by the different tabs to notify changes. */
  void changed();
};

#endif // LOOK_EDIT_H
