/* -*- C++ -*-
 * This file declares the dialog that is used to set file specific
 * information.
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999, 2000
 * mail to:    Mirko Sucker <mirko@kde.org>
 * requires:   recent C++-compiler, at least Qt 2.0
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.
 
 You should have received a copy of the GNU Library General Public License
 along with this library; see the file COPYING.LIB.  If not, write to
 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 * $Revision: 1.3 $
 */
  
#ifndef DIALOG_CONFIGUREFILE_H
#define DIALOG_CONFIGUREFILE_H

#include <addressbook.h> // we use the ErrorCodes here
#include <qtabwidget.h>

class Section;
class QLineEdit;
class QLabel;
class StringListEditWidget;

/** This class is used in the dialog where the user may configure the file
 *  specific settings for the loaded kab address database.
 *  It is used as a \e "main widget"  for a DialogBase object. */

class KabFileConfigWidget : public QTabWidget
{
  // ############################################################################
  Q_OBJECT
  // ----------------------------------------------------------------------------
public:
  /** The Qt standard constructor. Gets the open file. */
  KabFileConfigWidget(Section* config, QWidget* parent, const char* name=0);
  /** The destructor. */
  ~KabFileConfigWidget();
  /** Save the settings to the file. */
  AddressBook::ErrorCode saveSettings(Section*); 
  // ----------------------------------------------------------------------------
protected:
  /** Tab for configuring the user fields. */
  QWidget *userFields; 
  /** The name of the first user field. */
  QLineEdit *userFieldsName; 
  /** The label for the first user field. */
  QLabel *userFieldsLabel;
  /** The name of the first user field. */
  QLineEdit *userField1; 
  /** The label for the first user field. */
  QLabel *userLabel1;
  /** The name of the second user field. */
  QLineEdit *userField2;
  /** The label for the second user field. */
  QLabel *userLabel2; 
  /** The name of the third user field. */
  QLineEdit *userField3; 
  /** The label for the third user field. */
  QLabel *userLabel3; 
  /** The name of the fourth user field. */
  QLineEdit *userField4; 
  /** The label for the fourth user field. */
  QLabel *userLabel4; 
  /** The border width inside the dialog. */
  static const int Border;
  /** A StringListEditWidget for editing the kinds of addresses. It is used as
   *  a tab. */
  StringListEditWidget *editwidget;
  // ############################################################################
};



#endif // DIALOG_CONFIGUREFILE_H
