/*********************************************************************
 *
 * This is based on code created by Peter Harvey,
 * (pharvey@codebydesign.com).
 *
 * Modified and extended by Nick Gorham
 * (nick@easysoft.com).
 *
 * Any bugs or problems should be considered the fault of Nick and not
 * Peter.
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLDrivers.c,v 1.2 1999/12/10 01:50:33 harvey Exp $
 *
 * $Log: SQLDrivers.c,v $
 * Revision 1.2  1999/12/10 01:50:33  harvey
 * Updated with current sources from unixODBC cvs.
 *
 * Revision 1.8  1999/11/13 23:40:59  ngorham
 *
 * Alter the way DM logging works
 * Upgrade the Postgres driver to 6.4.6
 *
 * Revision 1.7  1999/10/24 23:54:17  ngorham
 *
 * First part of the changes to the error reporting
 *
 * Revision 1.6  1999/09/21 22:34:24  ngorham
 *
 * Improve performance by removing unneeded logging calls when logging is
 * disabled
 *
 * Revision 1.5  1999/09/19 22:24:33  ngorham
 *
 * Added support for the cursor library
 *
 * Revision 1.4  1999/07/10 21:10:16  ngorham
 *
 * Adjust error sqlstate from driver manager, depending on requested
 * version (ODBC2/3)
 *
 * Revision 1.3  1999/07/04 21:05:07  ngorham
 *
 * Add LGPL Headers to code
 *
 * Revision 1.2  1999/06/30 23:56:54  ngorham
 *
 * Add initial thread safety code
 *
 * Revision 1.1.1.1  1999/05/29 13:41:06  sShandyb
 * first go at it
 *
 * Revision 1.1.1.1  1999/05/27 18:23:17  pharvey
 * Imported sources
 *
 * Revision 1.4  1999/05/09 23:27:11  nick
 * All the API done now
 *
 * Revision 1.3  1999/04/30 16:22:47  nick
 * Another checkpoint
 *
 * Revision 1.2  1999/04/29 20:47:37  nick
 * Another checkpoint
 *
 * Revision 1.1  1999/04/25 23:06:11  nick
 * Initial revision
 *
 *
 **********************************************************************/

#include "drivermanager.h"

static char const rcsid[]= "$RCSfile: SQLDrivers.c,v $ $Revision: 1.2 $";

#define BUFFERSIZE  1024

SQLRETURN SQLDrivers(
    SQLHENV            henv,
    SQLUSMALLINT       fdirection,
    SQLCHAR            *sz_driver_desc,
    SQLSMALLINT        cb_driver_desc_max,
    SQLSMALLINT        *pcb_driver_desc,
    SQLCHAR            *sz_driver_attributes,
    SQLSMALLINT        cb_drvr_attr_max,
    SQLSMALLINT        *pcb_drvr_attr )
{
    DMHENV  environment = (DMHENV) henv;
    char   	buffer[ BUFFERSIZE + 1 ];
    char    object[ INI_MAX_OBJECT_NAME + 1 ];
    SQLRETURN ret = SQL_SUCCESS;
    SQLCHAR s0[ 20 ];

    if ( !__validate_env( environment ))
    {
        return SQL_INVALID_HANDLE;
    }

    function_entry( environment );

    if ( environment -> log_handle )
    {
        sprintf( environment -> msg, "\n\t\tEntry:\
            \n\t\t\tEnvironment = %p\
            \n\t\t\tDirection = %d",
                environment,
                (int)fdirection );

        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                environment -> msg );
    }

    thread_protect( SQL_HANDLE_ENV, environment );

    if ( cb_driver_desc_max < 0 )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY090" );

        __post_internal_error( &environment -> error,
                ERROR_HY090, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }

    /*
     * the DataManager fails if this is in
     *
     *
    if ( cb_drvr_attr_max < 0
            || cb_drvr_attr_max == 1 )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY090" );

        __post_internal_error( &environment -> error,
                ERROR_HY090, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }
     */

    /*
     * check that a version has been requested
     */

    if ( environment -> requested_version == 0 )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY090" );

        __post_internal_error( &environment -> error,
                ERROR_HY010, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }

    if ( fdirection != SQL_FETCH_FIRST &&
            fdirection != SQL_FETCH_NEXT )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: HY103" );

        __post_internal_error( &environment -> error,
                ERROR_HY103, NULL,
                environment -> requested_version );

        thread_release( SQL_HANDLE_ENV, environment );

        return function_return( environment, SQL_ERROR );
    }

    if ( fdirection == SQL_FETCH_FIRST )
        environment -> sql_driver_count = 0;
    else
        environment -> sql_driver_count ++;

try_again:

	memset( buffer, '\0', sizeof( buffer ));
	memset( object, '\0', sizeof( object ));
	SQLGetPrivateProfileString( NULL, NULL, 
            NULL, buffer, sizeof( buffer ), INIDRIVERS );

	if ( iniElement( buffer, '\0', '\0',
                environment -> sql_driver_count,
                object, sizeof( object )) != INI_SUCCESS )
	{
        environment -> sql_driver_count = 0; 
		ret = SQL_NO_DATA;
	}
	else
	{
        ret = SQL_SUCCESS;

        /*
         * this section is used for internal info
         */

        if ( strcmp( object, "ODBC" ) == 0 )
        {
            environment -> sql_driver_count ++;
            goto try_again;
        }

        if ( pcb_driver_desc )
            *pcb_driver_desc = strlen( object ) + 1;

        if ( sz_driver_desc )
        {
            if ( strlen( object ) >= cb_driver_desc_max )
            {
                memcpy( sz_driver_desc, object, cb_driver_desc_max - 1 );
                sz_driver_desc[ cb_driver_desc_max - 1 ] = '\0';

                dm_log_write( environment -> log_handle, 
                        __get_pid( s0 ), 
                        __FILE__, 
                        __LINE__, 
                        LOG_INFO, 
                        LOG_INFO, 
                        "Error: 01004" );

                __post_internal_error( &environment -> error,
                        ERROR_01004, NULL,
                        environment -> requested_version );

                ret = SQL_SUCCESS_WITH_INFO;
            }
            else
            {
                strcpy( sz_driver_desc, object );
            }
        }
        else
        {
            ret = SQL_SUCCESS_WITH_INFO;
        }

		if ( sz_driver_attributes ||
                pcb_drvr_attr )
		{
            HINI hIni;
            int string_length = 0;
            char szPropertyName[INI_MAX_PROPERTY_NAME+1];
            char szValue[INI_MAX_PROPERTY_NAME+1];
            char szIniName[ INI_MAX_OBJECT_NAME + 1 ];
            char buffer[ 1024 ];
            int total_len = 0;

            /*
             * enumerate the driver attributes
             */

#ifdef SYSTEM_FILE_PATH
            sprintf( szIniName, "%s/odbcinst.ini", SYSTEM_FILE_PATH );
#else
            strcpy( szIniName, "/etc/odbcinst.ini" );
#endif

			memset( buffer, '\0', sizeof( buffer ));
            if ( iniOpen( &hIni, szIniName, '#', '[', ']', '=', TRUE ) == 
                    INI_SUCCESS )
            {
                char pRetBuffer[ 256 ];
                int nRetBuffer;

                iniObjectSeek( hIni, (char *)object );
                iniPropertyFirst( hIni );
                while ( iniPropertyEOL( hIni ) != TRUE )
                {
                    iniProperty( hIni, szPropertyName );
                    iniValue( hIni, szValue );
                    sprintf( buffer, "%s=%s", szPropertyName, 
                            szValue );

                    if ( total_len + strlen( buffer ) + 1 > cb_drvr_attr_max )
                    {
                        ret = SQL_SUCCESS_WITH_INFO;
                    }
                    else
                    {
                        if ( sz_driver_attributes )
                        {
                            strcpy( sz_driver_attributes, buffer );
                            sz_driver_attributes += strlen( buffer ) + 1;
                        }
                    }
                    total_len += strlen( buffer ) + 1;

                    iniPropertyNext( hIni );
                }
                /*
                 * add extra null 
                 */
                *sz_driver_attributes = '\0';

                if ( *pcb_drvr_attr )
                {
                    *pcb_drvr_attr = total_len;
                }

                iniClose( hIni );
            }
		}
	}

    if ( ret == SQL_SUCCESS_WITH_INFO )
    {
        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                "Error: 01004" );

        __post_internal_error( &environment -> error,
                ERROR_01004, NULL,
                environment -> requested_version );
                    ret = SQL_SUCCESS_WITH_INFO;
    }

    if ( environment -> log_handle )
    {
        sprintf( environment -> msg, 
                "\n\t\tExit:[%s]",
                    __get_return_status( SQL_SUCCESS ));

        dm_log_write( environment -> log_handle, 
                __get_pid( s0 ), 
                __FILE__, 
                __LINE__, 
                LOG_INFO, 
                LOG_INFO, 
                environment -> msg );
    }

    thread_release( SQL_HANDLE_ENV, environment );

    return function_return( environment, ret );
}
