/* 
   This file is part of libodbc++.
   
   Copyright (C) 1999 Manush Dodunekov <manush@litecom.net>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

// this will probably include more info about the driver in the 
// future

#include "driverinfo.h"
#include <odbc++/connection.h>
#include <odbc++/databasemetadata.h>

using namespace odbc;

DriverInfo::DriverInfo(Connection* con)
  :supportedFunctions_(new SQLUSMALLINT[ODBC3_C(SQL_API_ODBC3_ALL_FUNCTIONS_SIZE,
						100)])
{
  DatabaseMetaData* md=con->getMetaData();
  majorVersion_=md->getDriverMajorVersion();
  minorVersion_=md->getDriverMinorVersion();

  cursorMask_=md->_getNumeric32(SQL_SCROLL_OPTIONS);

  SQLRETURN r=SQLGetFunctions(con->hdbc_,
			      ODBC3_C(SQL_API_ODBC3_ALL_FUNCTIONS,
				      SQL_API_ALL_FUNCTIONS),
			      supportedFunctions_);
  con->_checkConError(con->hdbc_,
		      r,"Failed to retreive a list of supported functions");
}
