#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>

#include <qdir.h>
#include <qfile.h>

#include "addwizard.h"
#include "addwizard.moc"

#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>

#include <kapp.h>
#include <kconfig.h>
#include <kfiledialog.h>
#include <knuminput.h>
#include <klocale.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

#ifndef KDE_USE_FINAL
static KConfig *conf;
#endif

AddServerWizard::AddServerWizard()
    :KWizard(0,0,true)
{
    conf = kapp->config();

    connect((const QObject*)finishButton(), SIGNAL(clicked()),
	    this, SLOT(finished()));
    connect((const QObject*)cancelButton(), SIGNAL(clicked()),
	    this, SLOT(reject()));
    connect((const QObject*)nextButton(), SIGNAL(clicked()),
	    this, SLOT(forward()));

    wp=new("ServerNamePage") ServerNamePage(this);
    addPage(wp, i18n("Server Name"));
    setHelpEnabled(wp, false);

    pdp=new("PublicDirPage") PublicDirPage(this);
    addPage(pdp, i18n("Server's Public Directory"));
    setHelpEnabled(pdp, false);

    pp=new("PortPage") PortPage(this);
    addPage(pp, i18n("Server's Port Number"));
    setHelpEnabled(pp, false);

    ep=new("EndPage") EndPage(this);
    addPage(ep, i18n("Finish"));
    setHelpEnabled(ep, false);
    setFinishEnabled(ep, true);
}

AddServerWizard::~AddServerWizard()
{
}

void AddServerWizard::forward()
{
    if (currentPage() == pdp && !wp->validate())
	emit back();
    if (currentPage() == pp && !pdp->validate())
	emit back();
    if (currentPage() == ep && !pp->validate())
	emit back();
}

void AddServerWizard::finished()
{
    data.clear();
    data.append(wp->data());
    data.append(pdp->data());
    data.append(pp->data());
    accept();
}

ServerNamePage::ServerNamePage(QWidget *parent)
:QWidget (parent)
{
    QVBoxLayout *vl=new("QVBoxLayout") QVBoxLayout (this,10);
    QLabel *l=new("QLabel") QLabel(this);
    l->setText(i18n("Enter a name for this server.\n"
               "This name is used to identify\n"
               "this configuration."));
    l->setMinimumSize(l->sizeHint());
    vl->addWidget(l,10);

    l=new("QLabel") QLabel(this);
    l->setText (i18n("Name:"));
    vl->addWidget(l,10);

    name=new("QLabel") QLineEdit(this);
    name->setText(i18n("MyServer"));
    name->setFixedHeight(name->sizeHint().height());
    vl->addWidget(name,0);

    l=new("QLabel") QLabel(this);
    l->setText ("");
    vl->addWidget(l,10);
    
    vl->activate();
    setMinimumSize(300,200);
}
ServerNamePage::~ServerNamePage()
{
}

bool ServerNamePage::validate()
{
    debug ("validate");
    QString nam=name->text();
    
    conf->setGroup("Servers");
    QStrList names;
    conf->readListEntry("ServerNames",names);
    if (nam.isEmpty())
    {
        debug ("empty name");
        QMessageBox::warning(0,i18n("PWS: Error"),
			     i18n("Nothing is not a name.\n"
				  "Please choose one"), i18n("OK"));
        qApp->processEvents();
        return false;
    }
    else if ( (names.find(nam.data())==-1) && (nam!="General") )
    {
        return true;
    }
    else
    {
        debug ("repeated name");
        QMessageBox::warning(0,i18n("PWS: Error"),
				 i18n("That server name already exists.\n"
				      "Please choose a new one"), 
				 i18n("OK"));
        return false;
    }
}

QString ServerNamePage::data()
{
    return name->text();
}

PublicDirPage::PublicDirPage(QWidget *parent)
:QWidget (parent)
{
    QVBoxLayout *vl=new("QVBoxLayout") QVBoxLayout (this,10);
    QHBoxLayout *hl=new("QHBoxLayout") QHBoxLayout ();
    QLabel *l=new("QLabel") QLabel(this);
    l->setText(i18n("Enter the name of the directory where\n"
               "the web pages are located.\n"));
    l->setMinimumSize(l->sizeHint());
    vl->addWidget(l,10);

    l=new("QLabel") QLabel(this);
    l->setText (i18n("Directory:"));
    vl->addWidget(l,10);

    name=new("QLineEdit") QLineEdit(this);
    name->setFixedHeight(name->sizeHint().height());
    name->setText(QDir::homeDirPath()+"/html");
    QPushButton *examine=new("QPushButton") QPushButton("...",this);
    examine->setFixedSize(examine->sizeHint());
    
    vl->addLayout (hl,0);
    hl->addWidget(name,10);
    hl->addWidget(examine,0);
    
    l=new("QLabel") QLabel(this);
    l->setText ("");
    vl->addWidget(l,10);
    
    vl->activate();
    setMinimumSize(300,200);

    QObject::connect (examine,SIGNAL(clicked()),
                      this,SLOT(setDirName()));
}

PublicDirPage::~PublicDirPage()
{
}

bool PublicDirPage::validate()
{
    debug ("validate");
    QString nam=name->text();

    if (!QFile::exists(name->text()))
    {
        int i=QMessageBox::warning(0,i18n("PWS: Error"),
				   i18n("That directory doesn't exist.\n"
					"Do you want me to create it?"),
				   i18n("OK"));
        if (i==1) //he said yes
	{
            mkdir(name->text(), 0700);
        }
	else
            return true;
    }
    return true;
}


void PublicDirPage::setDirName()
{
    QString d=KFileDialog::getExistingDirectory(name->text());
    if (!d.isEmpty())
        name->setText(d.data());
}

QString PublicDirPage::data()
{
    return name->text();
}

PortPage::PortPage(QWidget *parent)
:QWidget (parent)
{
    QVBoxLayout *vl=new("QVBoxLayout") QVBoxLayout (this,10);
    QLabel *l=new("QLabel") QLabel(this);
    l->setText(i18n("Enter a port for this server.\n"
               "The port is part of the URL for the server\n"
               "for example, in http://my.server.org:800\n"
               "800 is the port number.\n"
               "The standard port for web servers is 80\n"
               "To use a port number under 1024 you will \n"
               "need the root password.")
              );
    l->setMinimumSize(l->sizeHint());
    vl->addWidget(l,10);

    l=new("QLabel") QLabel(this);
    l->setText (i18n("Port Number:"));
    vl->addWidget(l,10);

    port=new KIntNumInput((geteuid() == 0) ? 80 : 8080, this);
    port->setRange(1, 65535, 1);
    vl->addWidget(port,0);

    l=new("QLabel") QLabel(this);
    l->setText ("");
    vl->addWidget(l,10);
    
    vl->activate();
    setMinimumSize(300,200);
}
PortPage::~PortPage()
{
}

bool PortPage::validate()
{
    return true;
}

QString PortPage::data()
{
    QString str;
    return str.setNum(port->value());
}

EndPage::EndPage(QWidget *parent)
:QWidget (parent)
{
    QVBoxLayout *vl=new("QVBoxLayout") QVBoxLayout (this,10);
    QLabel *l=new("QLabel") QLabel(this);
    l->setText(i18n("You have finished configuring\n"
               "the web server.\n"
               "Press Finish to save it, Cancel to\n"
               "forget about it.\n"));

    l->setMinimumSize(280,170);
    vl->addWidget(l,10);

    vl->activate();
    setMinimumSize(300,200);
}

EndPage::~EndPage()
{
}
