#include "printdlg.h"

#include <qdialog.h>
#include <qlist.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <kconfig.h>
#include <kapp.h>

#include "typelayout.h"
#include <klocale.h>

#include "printdlg.moc"

extern KConfig *conf;

KTypeLayout *l;

PrintDlg::PrintDlg() :
    QDialog (0,i18n("KRN - Print Settings"),true)
{

    conf->setGroup("Printing");
    TLForm *f=new TLForm("printing",
                         i18n("KRN - Printing Settings"),
                         this);
    
    l=f->layout;

    l->addBook("book");

    l->addPage("General",i18n("General"));

    l->addGroup("g2",i18n("Printing System"),true);
    l->newLine();
    l->addRadioButton("htmlprint","r1",i18n("Use HTML Printing"),
                     conf->readNumEntry("HTMLPrinting",true));
    l->newLine();
    l->addRadioButton("directprint","r1",i18n("Use Direct Printing"),
                     conf->readNumEntry("DirectPrinting",false));
    l->endGroup();//g2
    l->newLine();
    
    l->addGroup("g1",i18n("Direct Printing"),true);

    l->newLine();
    l->addLabel("l1",i18n("Print using:"));
    l->addLineEdit("commandname",
                   conf->readEntry("CommandName","lpr"));
    l->newLine();
    l->addLabel("lfeed",i18n("Feed it with:"));
    QStrList *feeds=new QStrList;
    feeds->append (i18n("Postscript"));
    feeds->append (i18n("HTML"));
    feeds->append (i18n("Text"));
    l->addComboBox("feeds",feeds);
    ((QComboBox *)(l->findWidget("feeds")))->setCurrentItem(conf->readNumEntry("Feed",2));
    delete feeds;
    l->endGroup();

    l->endGroup();//general

/*
    l->addPage("Formatter",i18n("Formatter"));

    l->addLabel("fontl",i18n("Font:"));
    QStrList *fonts=new QStrList;
    fonts->append("Times");
    fonts->append("Courier");
    fonts->append("Helvetica");
    fonts->append("Palatino");
    fonts->append("Symbol");
    fonts->append("Bookman");
    fonts->append("Helvetica Narrow");
    fonts->append("New Century");
    fonts->append("Avant Garde");
    l->addComboBox("font",fonts);
    delete fonts;
    l->endGroup();//formatter
*/

    l->endGroup(); //book

    l->newLine();
    
    l->addGroup("buttons","",false);
    QPushButton *b1=(QPushButton *)(l->addButton("b1",i18n("OK"))->widget);
    QPushButton *b2=(QPushButton *)(l->addButton("b2",i18n("Cancel"))->widget);
    l->endGroup();
    
    l->activate();
    
    b1->setDefault(true);
    QObject::connect (b1,SIGNAL(clicked()),SLOT(save()));
    QObject::connect (b2,SIGNAL(clicked()),SLOT(reject()));
}

void PrintDlg::save()
{
    conf->setGroup("Printing");
    conf->writeEntry("HTMLPrinting",
                     ((QRadioButton *)l->findWidget("htmlprint"))->isChecked());
    conf->writeEntry("DirectPrinting",
                     ((QRadioButton *)l->findWidget("directprint"))->isChecked());
    conf->writeEntry("CommandName",
                     ((QLineEdit *)l->findWidget("commandname"))->text());
    conf->writeEntry("Feed",
                     ((QComboBox *)l->findWidget("feeds"))->currentItem());
    conf->sync();
    accept();
}

PrintDlg::~PrintDlg()
{
}
