/*
* maildrop.cpp -- Implementation of class KMailDrop.
* Author:	Sirtaj Singh Kang
* Version:	$Id: maildrop.cpp,v 1.1 1999/07/22 18:16:59 tibirna Exp $
* Generated:	Sat Nov 29 20:07:45 EST 1997
*/

#include<qstring.h>
#include<qcolor.h>
#include<assert.h>

#include<kconfigbase.h>

#include"maildrop.h"
#include"gencfg.h"
#include"dropdlg.h"

KMailDrop::KMailDrop()
	: _colour( false ),
	  _hlColour( 0 ),
	  _tColour( 0 ),
	  _bgTexture( "" ),

	 _lastCount( 0 )
{
	connect( this, SIGNAL(changed(int)), this, SLOT(setCount(int)) );
}

KMailDrop::~KMailDrop()
{
	_colour = false;
	delete _hlColour; _hlColour = 0;
	delete _tColour; _tColour = 0;
}

void KMailDrop::setCount(int count)
{
	_lastCount = count;
}

bool KMailDrop::readConfigGroup( const KConfigBase& cfg )
{
	setCaption( cfg.readEntry( CaptionConfigKey, "" ) );
	setClickCmd( cfg.readEntry( ClickConfigKey, "" ) );
	setNewmailCmd( cfg.readEntry( NewMailConfigKey, "" ) );

	_colour = cfg.readBoolEntry( UseColourConfigKey, false );

	if ( cfg.hasKey( HlColourConfigKey ) ) {
		setHlColour( cfg.readColorEntry( HlColourConfigKey ) );
	}
	if ( cfg.hasKey( TColourConfigKey ) ) {
		setTColour( cfg.readColorEntry( TColourConfigKey ) );
	}
	if ( cfg.hasKey( BgTextureConfigKey ) ) {
		setBgTexture( cfg.readEntry( BgTextureConfigKey ) );
	}

	return true;
}

bool KMailDrop::writeConfigGroup( KConfigBase& cfg ) const
{
	cfg.writeEntry( TypeConfigKey, type() );
	cfg.writeEntry( CaptionConfigKey, caption() );
	cfg.writeEntry( ClickConfigKey, clickCmd() );
	cfg.writeEntry( NewMailConfigKey, newmailCmd() );

	cfg.writeEntry( UseColourConfigKey, colour() );

	if( _hlColour ) {
		cfg.writeEntry( HlColourConfigKey, *_hlColour );
	}
	if( _tColour ) {
		cfg.writeEntry( TColourConfigKey, *_tColour );
	}
	if( _bgTexture.length() > 0 ) {
		cfg.writeEntry( BgTextureConfigKey, _bgTexture );
	}

	return true;
}

void KMailDrop::notifyClients()
{
	emit notifyDisconnect();
}

const char *KMailDrop::TypeConfigKey = "type";
const char *KMailDrop::CaptionConfigKey = "caption";
const char *KMailDrop::ClickConfigKey = "onclick";
const char *KMailDrop::NewMailConfigKey = "onnewmail";
const char *KMailDrop::UseColourConfigKey = "usecolour";
const char *KMailDrop::HlColourConfigKey = "highcolour";
const char *KMailDrop::TColourConfigKey = "textcolour";
const char *KMailDrop::BgTextureConfigKey = "texture";


void KMailDrop::addConfigPage( KDropCfgDialog *dlg )
{
	dlg->addConfigPage( new KGeneralCfg( this ) );
}

void KMailDrop::forceCountZero()
{
	emit changed( 0 );
}

void KMailDrop::setHlColour( const QColor& c )
{
	if( _hlColour == 0 ) {
		_hlColour = new QColor( c );
	}
	else {
		*_hlColour = c;
	}

	emit configChanged();
}

void KMailDrop::setTColour( const QColor& c )
{
	if( _tColour == 0 ) {
		_tColour = new QColor( c );
	}
	else {
		*_tColour = c;
	}

	emit configChanged();
}

void KMailDrop::setBgTexture( const char *image )
{
	assert( image != 0 );

	_bgTexture = image;

	emit configChanged();
}

