/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef _RESULTVIEW_H_
#define _RESULTVIEW_H_


#include <qlistview.h>

class ResultView;

class ResultViewItem : public QListViewItem {

public:
    ResultViewItem( QListView *parent, QString host, QString path,
		    QString size, QString date);

private:
    QString m_url;
    friend class ResultView;
};


class ResultView : public QListView {

    Q_OBJECT
    
public:
    ResultView( QWidget *parent=0, const char *name=0 );

    void insertItem(QString host, QString path, QString size, QString date);
    
signals:
    void urlActivated(QString url);

protected slots:
    void itemActivated(QListViewItem *item);

protected:
    virtual QSizePolicy sizePolicy () const  
        { return QSizePolicy(QSizePolicy::MinimumExpanding,
                             QSizePolicy::MinimumExpanding); }    
};

#endif
