// $Id: settings.cpp,v 1.6 2000/04/21 14:04:39 koss Exp $

#include <kapp.h>
#include <kstddirs.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kwm.h>
#include <kdebug.h>

#include "kmainwidget.h"
#include "transferlist.h"
#include "droptarget.h"
#include "settings.h"


QString ConnectionDevices[6] = {
  "",
  "eth",
  "plip",
  "slip",
  "ppp",
  "isdn" };


void Settings::load() {
  kDebugInfo( 5001, "Loading settings" );

  KConfig *config = kapp->config();

  // read system options
  config->setGroup("System");
  ksettings.b_useSound = config->readBoolEntry("UseSound", DEF_UseSound);

  ksettings.audioAdded = config->readEntry("Added", locate("data", DEF_SoundAdded) );

  ksettings.audioStarted = config->readEntry("Started", locate("data", DEF_SoundStarted) );

  ksettings.audioFinished = config->readEntry("Finished",
					      locate("data", DEF_SoundFinished) );

  ksettings.audioFinishedAll = config->readEntry("FinishedAll",
						 locate("data", DEF_SoundFinishedAll) );

  ksettings.b_useAnimation = config->readBoolEntry("UseAnimation", DEF_UseAnimation);

  ksettings.windowStyle = config->readNumEntry("WindowStyle", DEF_WindowStyle);

  // read connection options
  config->setGroup("Connection");

  ksettings.b_reconnectOnError = config->readBoolEntry("ReconnectOnError",DEF_ReconnectOnError);
  ksettings.reconnectTime = config->readNumEntry("ReconnectTime", DEF_ReconnectTime);
  ksettings.reconnectRetries = config->readNumEntry("ReconnectRetries", DEF_ReconnectRetries);
  ksettings.b_reconnectOnBroken = config->readBoolEntry("ReconnectOnBroken",DEF_ReconnectOnBroken);

  ksettings.timeoutData = config->readNumEntry("TimeoutData", DEF_TimeoutData);
  ksettings.timeoutDataNoResume = config->readNumEntry("TimeoutDataNoResume", DEF_TimeoutDataNoResume);

  ksettings.connectionType = config->readNumEntry("ConnectionType", DEF_ConnectionType);
  ksettings.linkNumber = config->readNumEntry("LinkNumber", DEF_LinkNumber );
  ksettings.b_offlineMode = config->readBoolEntry("OfflineMode", DEF_OfflineMode);

  // read automation options
  config->setGroup("Automation");

  ksettings.b_autoSave = config->readBoolEntry("AutoSave", DEF_AutoSave);
  ksettings.autoSaveInterval = config->readNumEntry("AutoSaveInterval", DEF_AutoSaveInterval);

  ksettings.b_autoDisconnect = config->readBoolEntry("AutoDisconnect", DEF_AutoDisconnect );
  ksettings.disconnectCommand = config->readEntry("DisconnectCommand", DEF_DisconnectCommand);

  ksettings.b_timedDisconnect = config->readBoolEntry("TimedDisconnect", DEF_TimedDisconnect );
  ksettings.disconnectTime.setHMS( config->readNumEntry("DisconnectTimeHour"),
				   config->readNumEntry("DisconnectTimeMinute"), 0 );

  ksettings.disconnectDate = QDate::currentDate(); // doesn't make sense to save it
  
  ksettings.b_autoShutdown = config->readBoolEntry("AutoShutdown", DEF_AutoShutdown);
  ksettings.b_autoPaste = config->readBoolEntry("AutoPaste", DEF_AutoPaste);

  // read limits options
  config->setGroup("Limits");

  ksettings.maxSimultaneousConnections = config->readNumEntry("MaxSimConnections", DEF_MaxSimConnections);
  ksettings.minimumBandwidth = config->readNumEntry("MinimumBandwidth", DEF_MinimumBandwidth);
  ksettings.maximumBandwidth = config->readNumEntry("MaximumBandwidth", DEF_MaximumBandwidth);

  // read advanced options
  config->setGroup("Advanced");

  ksettings.b_addQueued = config->readBoolEntry("AddQueued", DEF_AddQueued);
  ksettings.b_showIndividual = config->readBoolEntry("ShowIndividual", DEF_ShowIndividual);
  ksettings.b_iconifyIndividual = config->readBoolEntry("IconifyIndividual", DEF_IconifyIndividual);
  ksettings.b_advancedIndividual = config->readBoolEntry("AdvancedIndividual", DEF_AdvancedIndividual);

  ksettings.b_removeOnSuccess = config->readBoolEntry("RemoveOnSuccess", DEF_RemoveOnSuccess );
  ksettings.b_getSizes = config->readBoolEntry("GetSizes", DEF_GetSizes );
  ksettings.b_expertMode = config->readBoolEntry("ExpertMode", DEF_ExpertMode );

  // read search options
  config->setGroup("Search");
  ksettings.b_searchFastest = config->readBoolEntry("SearchFastest", DEF_SearchFastest );
  ksettings.searchItems = config->readNumEntry("SearchItems", DEF_SearchItems);
  ksettings.timeoutSearch = config->readNumEntry("TimeoutSearch", DEF_TimeoutSearch);
  ksettings.b_switchHosts = config->readBoolEntry("SwitchHosts", DEF_SwitchHosts );

  // read directory options
  config->setGroup("Directories");

  // don't read this one
  // it doesn't make sense to set it to true at the beginning
  ksettings.b_useLastDir = DEF_UseLastDir;

  QStringList strList;
  strList = config->readListEntry("Items");
  
  ksettings.defaultDirList.clear();
  QStringList::Iterator it = strList.begin();
  for ( ; it != strList.end(); ++it ) {
    DirItem item;
    item.extRegexp = *it;
    ++it;
    item.defaultDir = *it;
    ksettings.defaultDirList.append( item );
  }

  // read misc settings
  config->setGroup( "Misc" );

  QFont font = kapp->font( kmain->myTransferList );
  ksettings.listViewFont = config->readFontEntry("Font", &font );
  ksettings.toolbarPosition = (KToolBar::BarPosition) config->readNumEntry("Toolbar",
									   DEF_ToolbarPosition);
  ksettings.b_showStatusbar = config->readBoolEntry("Statusbar", DEF_ShowStatusbar);

  // read geometry settings
  config->setGroup("Geometry");
  ksettings.mainProperties = config->readEntry("MainGeometry", "" );
  ksettings.dropProperties = config->readEntry("DropGeometry", "" );
}


void Settings::save() {
  kDebugInfo( 5001, "Saving settings" );

  KConfig *config = kapp->config();

  // write connection options
  config->setGroup( "Connection" );
  config->writeEntry("ReconnectOnError", ksettings.b_reconnectOnError);
  config->writeEntry("ReconnectTime", ksettings.reconnectTime);
  config->writeEntry("ReconnectRetries", ksettings.reconnectRetries);
  config->writeEntry("ReconnectOnBroken", ksettings.b_reconnectOnBroken);
  config->writeEntry("TimeoutData", ksettings.timeoutData);
  config->writeEntry("TimeoutDataNoResume", ksettings.timeoutDataNoResume);
  config->writeEntry("ConnectionType", ksettings.connectionType);
  config->writeEntry("LinkNumber", ksettings.linkNumber);
  config->writeEntry( "OfflineMode", ksettings.b_offlineMode );

  // write automation options
  config->setGroup( "Automation" );
  config->writeEntry("AutoSave", ksettings.b_autoSave);
  config->writeEntry("AutoSaveInterval", ksettings.autoSaveInterval);
  config->writeEntry( "AutoDisconnect", ksettings.b_autoDisconnect );
  config->writeEntry("DisconnectCommand", ksettings.disconnectCommand );
  config->writeEntry("TimedDisconnect", ksettings.b_timedDisconnect );
  config->writeEntry("DisconnectTimeHour", ksettings.disconnectTime.hour() );
  config->writeEntry("DisconnectTimeMinute", ksettings.disconnectTime.minute() );
  config->writeEntry( "AutoShutdown", ksettings.b_autoShutdown );
  config->writeEntry( "AutoPaste", ksettings.b_autoPaste );

  // write limits options
  config->setGroup( "Limits" );
  config->writeEntry("MaxSimConnections", ksettings.maxSimultaneousConnections);
  config->writeEntry("MinimumBandwidth", ksettings.minimumBandwidth);
  config->writeEntry("MaximumBandwidth", ksettings.maximumBandwidth);

  // write advanced options
  config->setGroup( "Advanced" );
  config->writeEntry("AddQueued", ksettings.b_addQueued);
  config->writeEntry("ShowIndividual", ksettings.b_showIndividual);
  config->writeEntry("IconifyIndividual", ksettings.b_iconifyIndividual);
  config->writeEntry("AdvancedIndividual", ksettings.b_advancedIndividual);
  config->writeEntry("RemoveOnSuccess", ksettings.b_removeOnSuccess );
  config->writeEntry("GetSizes", ksettings.b_getSizes );
  config->writeEntry( "ExpertMode", ksettings.b_expertMode );

  // write search options
  config->setGroup( "Search" );
  config->writeEntry("SearchFastest", ksettings.b_searchFastest );
  config->writeEntry("SearchItems", ksettings.searchItems );
  config->writeEntry("TimeoutSearch", ksettings.timeoutSearch);
  config->writeEntry("SwitchHosts", ksettings.b_switchHosts );

  // write directory options
  config->setGroup( "Directories" );
  DirList::Iterator it;
  QStringList lst;
  for ( it = ksettings.defaultDirList.begin(); it != ksettings.defaultDirList.end(); ++it ) {
    lst.append( (*it).extRegexp );
    lst.append( (*it).defaultDir );
  }
  config->writeEntry( "Items", lst );

  // write system options
  config->setGroup( "System" );
  config->writeEntry("UseSound", ksettings.b_useSound);
  config->writeEntry("Added", ksettings.audioAdded);
  config->writeEntry("Started", ksettings.audioStarted);
  config->writeEntry("Finished", ksettings.audioFinished);
  config->writeEntry("FinishedAll", ksettings.audioFinishedAll);

  config->writeEntry( "UseAnimation", ksettings.b_useAnimation );

  config->writeEntry( "WindowStyle", ksettings.windowStyle );

  // write misc options
  config->setGroup( "Misc" );
  config->writeEntry("Font", ksettings.listViewFont ); 

  ksettings.toolbarPosition = kmain->toolBar()->barPos();
  config->writeEntry( "Toolbar", (uint)ksettings.toolbarPosition );
  config->writeEntry( "Statusbar", ksettings.b_showStatusbar );

  // write geometry properties
  config->setGroup( "Geometry" );
  ksettings.mainProperties = KWM::properties( kmain->winId() );
  config->writeEntry("MainGeometry", ksettings.mainProperties );
  ksettings.dropProperties = KWM::properties( kdrop->winId() );
  config->writeEntry("DropGeometry", ksettings.dropProperties );

  config->sync();
}
