// $Id: searchlist.cpp,v 1.3 1999/11/17 18:48:24 koss Exp $

#include <klocale.h>

#include "searchlist.h"

SearchList::SearchList (QWidget *parent, const char *name )
  : QListView (parent, name) {

  lv_host = addColumn( i18n("Host"), 200 );
  lv_speed = addColumn( i18n("Speed"), 60 );

  setMinimumHeight( sizeHint().height() / 2 );
}


void SearchList::moveToBegin( QListViewItem *item ) {

  ASSERT( item );

  QListViewItem *new_item = new QListViewItem( this );

  new_item->setText( lv_host, item->text( lv_host ) );
  new_item->setText( lv_speed, item->text( lv_speed ) );

  delete item;
}


void SearchList::setSelected( QListViewItem *item, bool selected ) {
  bool tmpb = selected;

  if ( tmpb && item->isSelected() ) {
    tmpb = false;
  }

  QListView::setSelected( item, tmpb );
}


void SearchList::slotSearchStarted() {
  clear();
}


void SearchList::slotFound( QString host ) {
  new QListViewItem( this, host, "---" );
}


void SearchList::slotPingSpeed( QString host, float speed ) {
  QListViewItemIterator it( this );
  for ( ; it.current(); ++it ) {
    QListViewItem* item = it.current();

    if ( item->text( 0 ) == host ) {
      QString tmps;
      item->setText( 1, tmps.setNum( speed ) );
    }
  }
}
