/* $Id: droptarget.cpp,v 1.13 2000/04/17 15:31:44 baumgart Exp $
   $Log: droptarget.cpp,v $
   Revision 1.13  2000/04/17 15:31:44  baumgart
   --enable-final fixes

   Revision 1.12  1999/11/21 10:32:21  koss
   XPM -> PNG
   In offline mode we now draw offline icon, too.
   Settings are now read/written in class Settings.
   Remove parent, kmain is better.

   Revision 1.11  1999/11/20 10:17:39  koss
   Removed some messages.
   Fixed drawing in TransferList.

   Revision 1.10  1999/11/18 21:31:39  koss
   Renamed slotPreferences(0 to slotTogglePreferences(0.

   Revision 1.1  1999/05/16 16:58:12  koss
   This is a shaped window, which stays always on top and can be used to
   drop URL's


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qpainter.h>

#include <kapp.h>
#include <kconfig.h>
#include <kstddirs.h>
#include <kwm.h>
#include <klocale.h>
#include <kdebug.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>

#include "kmainwidget.h"
#include "settings.h"
#include "droptarget.h"

#define TARGET_WIDTH   60
#define TARGET_HEIGHT  60

#undef  ICONWIDTH
#undef  ICONHEIGHT
#define ICONWIDTH      48
#define ICONHEIGHT     48

DropTarget::DropTarget() : QWidget( 0 ) {

  if ( ksettings.dropProperties != "" )
    setGeometry(KWM::setProperties(winId(), ksettings.dropProperties));
  else {
    setGeometry( 200, 200, TARGET_WIDTH, TARGET_HEIGHT );
    KWM::setDecoration( winId(), KWM::noDecoration | KWM::staysOnTop | KWM::noFocus );
  }

  b_sticky = KWM::isSticky( winId() );

  // setup mask
  mask.resize( TARGET_WIDTH, TARGET_HEIGHT );
  mask.fill( color0 );
  QPainter p2;
  p2.begin( &mask );
  p2.setBrush( color1 );
  p2.drawRoundRect( 0, 0, 60, 60, 40, 40 );
//   p2.drawEllipse( 0, 0, 60, 60 );
  p2.end();

  // setup pixmaps
  QString path = "caitoo/pics/";

  int offsetx = ( TARGET_WIDTH - ICONWIDTH ) / 2;
  int offsety = ( TARGET_HEIGHT - ICONHEIGHT ) / 2;

  QPixmap *tmppix = new QPixmap();
  tmppix->load( locate("data", path + "target_hand1.png") );
  handpix1 = new QPixmap( TARGET_WIDTH, TARGET_HEIGHT );
  handpix1->fill(backgroundColor());
  bitBlt( handpix1, offsetx, offsety, tmppix );
  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( locate("data", path + "target_hand2.png") );
  handpix2 = new QPixmap( TARGET_WIDTH, TARGET_HEIGHT );
  handpix2->fill(backgroundColor());
  bitBlt( handpix2, offsetx, offsety, tmppix );
  delete tmppix;

  tmppix = new QPixmap();
  tmppix->load( locate("data", path + "target_hand3.png") );
  handpix3 = new QPixmap( TARGET_WIDTH, TARGET_HEIGHT );
  handpix3->fill(backgroundColor());
  bitBlt( handpix3, offsetx, offsety, tmppix );
  delete tmppix;

  setBackgroundPixmap( *handpix1 );

  // popup menu for right mouse button
  popupMenu = new KPopupMenu();
  popupMenu->setTitle( kapp->caption() );
  popupMenu->setCheckable( true );

  popupMenu->insertItem(i18n("Minimize"), this, SLOT( toggleMinimizeRestore() ) );
  pop_sticky = popupMenu->insertItem(i18n("Sticky"), this, SLOT(toggleSticky()));
  popupMenu->setItemChecked( pop_sticky, b_sticky );
  popupMenu->insertItem(i18n("Preferences"), kmain, SLOT( slotTogglePreferences() ) );
  popupMenu->insertSeparator();
  popupMenu->insertItem(i18n("Quit"), kmain, SLOT( slotQuit() ) );

  // Enable dropping
  setAcceptDrops( true );
}


DropTarget::~DropTarget() {
  delete handpix1;
  delete handpix2;
  delete handpix3;
  delete popupMenu;
}


void DropTarget::mousePressEvent(QMouseEvent *e) {
  if ( e->button() == LeftButton ) {
    toggleMinimizeRestore();
  } else if ( e->button() == RightButton ) {
    popupMenu->popup(QCursor::pos());
  } else if ( e->button() == MidButton ) {
    kmain->slotPasteTransfer();
  }
}


void DropTarget::resizeEvent( QResizeEvent * ) {
  XShapeCombineMask( x11Display(), winId(), ShapeBounding, 0, 0, mask.handle(), ShapeSet );
}


void DropTarget::dragEnterEvent(QDragEnterEvent* event) {
  event->accept( QUriDrag::canDecode(event) || QTextDrag::canDecode(event) );
}


void DropTarget::dropEvent( QDropEvent* event ) {
  QStrList list;
  QString str;

  if ( QUriDrag::decode(event, list) ) {
    kmain->addDropTransfers( &list );
  } else if ( QTextDrag::decode(event, str) ) {
    kmain->addTransfer( str );
  }
}


void DropTarget::toggleSticky() {
  b_sticky = !b_sticky;
  popupMenu->setItemChecked( pop_sticky, b_sticky );

  KWM::setSticky( winId(), b_sticky );
}


void DropTarget::setAnim( int i1, int i2, int i3, int i4, bool online ) {
  size[0] = i1;
  size[1] = i2;
  size[2] = i3;
  size[3] = i4;

  if ( isVisible() ) {
    if ( !online || ksettings.b_offlineMode ) {
      setBackgroundPixmap( *handpix3 );
    } else if ( size[0] == 0 && size[1] == 0 && size[2] == 0 && size[3] == 0 ) {
      setBackgroundPixmap( *handpix1 );
    } else {
      QPixmap pm( *handpix2 );
      QPainter p;
      p.begin( &pm );

      p.setPen( white );
      for ( int i = 0; i < 4; i++ ) {
	if ( size[i] != 0 ) {
	  int pixels = (int)( ( TARGET_WIDTH - 8 ) * (float)size[i] / 100.0 );
	  p.fillRect( 4, 4 + ( i*12 ), pixels, 10, blue );
	}
      }

      p.end();
      setBackgroundPixmap( pm );
    }
  }
}


void DropTarget::toggleMinimizeRestore() {
  if ( kmain->isVisible() ) {
    kmain->hide();
  } else {
    kmain->show();
  }
}
