/* $Id: dlgSystem.h,v 1.7 1999/11/18 21:28:05 koss Exp $
   $Log: dlgSystem.h,v $
   Revision 1.7  1999/11/18 21:28:05  koss
   Adapted to a new settings policy.
   All settings are kept in class Settings.
   No more passing over / creating QStringLists etc.

   Revision 1.6  1999/11/15 20:14:10  koss
   Search entries moved to dlgSearch.
   Fixed layout again.
   Now we use units in KNumInput and not in separate QLabels.

   Revision 1.5  1999/11/09 18:24:38  koss
   Ported to KDialogBase.
   Fixed layout stuff ( only QListView in dlgDirectories remains ).

   Revision 1.4  1999/10/18 21:49:54  koss
   switched from QStrList to QStringList.
   fixed layout.
   removed getIntFromString() and getStringFromInt().
   getBoolFromString() renamed to stringToBool().
   getStringFromBool() renamed to boolToString().

   Revision 1.3  1999/05/16 16:59:53  koss
   Added "Window style" radio group and "Windows 9x style for docking" checkbutton

   Revision 1.2  1999/05/11 19:46:14  koss
   update for a new sound

   Revision 1.1  1999/02/07 17:11:29  matt
   source entered


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _DLGSYSTEM_H
#define _DLGSYSTEM_H

#include <qwidget.h>
#include <qlabel.h>
#include <qgroupbox.h> 
#include <qcombobox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpushbutton.h>

class DlgSystem : public QWidget
{
  Q_OBJECT
public:
  DlgSystem( QWidget *parent );
  ~DlgSystem() {}

  void applyData();
  void setData();
     
private:

  // sound settings
  QCheckBox *cb_useSound;

  QComboBox *cmb_sounds;
  QPushButton *pb_changesound;
  QPushButton *pb_testsound;

  QString soundAdded;
  QString soundStarted;
  QString soundFinished;
  QString soundFinishedAll;

  // animation settings
  QCheckBox *cb_useAnimation;

  // window style settings
  QButtonGroup *bg_window;
  QRadioButton *rb_normal;
  QRadioButton *rb_docked;
  QRadioButton *rb_droptarget;

  // font settings
  QGroupBox *gb_font;
  QLabel *lb_font;
  QPushButton *pb_browse;

private slots:
  void changeFont();

  void setupSound();
  void testSound();
};

#endif // _DLGSYSTEM_H
