/*
Donut Bump Mapping Demo
This demo shows how to use a bump mapping technique using Glide(tm)
Copyright (C) 1999  3Dfx Interactive, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
	lunix_utils.c
	A file containing fuctions than approximate Win32 'like' functions

	** NOTE **
  		These functions are approximate and do not emulate 
		the entire (or any) functionality of the Win32 functions

	Win32 functions are prefixed with 'linux_<Win32 function name>'
*/

#include <sys/time.h>
#include <unistd.h>
#include "linux_utils.h"
#include "wintypes.h"
#include "util.h"
#include "Printerr.h"
extern void (*gCurrUIFunction)(XEvent);

/* Globals variables */
Display	     *g_display;
int	     g_screen;
Window       g_rootwin, g_mainWindow;
unsigned int g_winWidth, g_winHeight;
int          g_colorDepth;
float        g_mouseMovementScalarX, g_mouseMovementScalarY;
float        g_oneOverMouseMovementScalarX, g_oneOverMouseMovementScalarY;
long         g_startTime = 0;

void linux_InitializeXWindow( float resolutionX, float resolutionY )
{
	XSizeHints size_hints;
	char window_name[] = { "Window" };
	char icon_name[] = { "Icon" };
	unsigned int displayWidth, displayHeight;
	struct timeval timeData;
	struct timezone timeZoneData;
       
	gettimeofday( &timeData, &timeZoneData );

	g_startTime = timeData.tv_sec;

	

	g_display      	= XOpenDisplay(NULL);
	g_screen       	= DefaultScreen(g_display);
	g_colorDepth	= DefaultDepth(g_display, g_screen);
 	g_rootwin      	= RootWindow(g_display, g_screen);


	/* get desktop resolution size */
	displayWidth = DisplayWidth(g_display, g_screen);
	displayHeight = DisplayHeight(g_display, g_screen);

	if(displayWidth < resolutionX) {
	  /* cacluate scale ratio for the mouse movements */
	  g_mouseMovementScalarX = resolutionX / (float)displayWidth;
	  g_oneOverMouseMovementScalarX = 1.0f / g_mouseMovementScalarX;
	  g_winWidth = displayWidth;
	} 
	else {
	  g_mouseMovementScalarX = 1.0f;
	  g_oneOverMouseMovementScalarX = 1.0f;
	  g_winWidth = (unsigned int)resolutionX;
	}

	if(displayHeight < resolutionY) {
	  /* cacluate scale ratio for the mouse movements */
	  g_mouseMovementScalarY = resolutionY / (float)displayHeight;
	  g_oneOverMouseMovementScalarY = 1.0f / g_mouseMovementScalarY;
	  g_winHeight = displayHeight;
	} 
	else {
	  g_mouseMovementScalarY = 1.0f;
	  g_oneOverMouseMovementScalarY = 1.0f;
	  g_winHeight = (unsigned int)resolutionY;
	}

	g_mainWindow	= XCreateSimpleWindow(g_display, g_rootwin, 0, 0, g_winWidth, g_winHeight, 4,
						BlackPixel(g_display, g_screen), BlackPixel(g_display, g_screen));


	//size_hints.flags = PSize | PMinSize | PMaxSize;
	//size_hints.min_width = g_winWidth;
	//size_hints.max_width = g_winWidth;
	//size_hints.min_height = g_winHeight;
	//size_hints.max_height = g_winHeight;


	//XSetStandardProperties(g_display, g_mainWindow, window_name, icon_name, None, 0, 0, &size_hints); 
	
	XSelectInput(g_display, g_mainWindow, 
			(ButtonReleaseMask|ButtonPressMask|KeyPressMask|KeyReleaseMask|PointerMotionMask) );
	
	XMoveWindow(g_display, g_mainWindow, 0, 0);
	XMapWindow(g_display, g_mainWindow);

	XFlush(g_display);

 
        XGrabPointer( g_display, g_mainWindow, 
			    False, 
			    (ButtonReleaseMask|ButtonPressMask|PointerMotionMask),
			    GrabModeAsync, GrabModeAsync, 
			    g_mainWindow,
			    None, CurrentTime );

      
	XGrabKeyboard( g_display, g_mainWindow, False, 
		       GrabModeAsync, GrabModeAsync, CurrentTime );
}

void linux_ShutdownXWindow( void )
{
	XCloseDisplay(g_display);
}

void linux_ResizeXWindow( float resolutionX, float resolutionY)
{
        unsigned displayWidth, displayHeight;
	
	/* get desktop resolution size */
	displayWidth = DisplayWidth(g_display, g_screen);
	displayHeight = DisplayHeight(g_display, g_screen);

	if(displayWidth < resolutionX) {
	  /* cacluate scale ratio for the mouse movements */
	  g_mouseMovementScalarX = resolutionX / (float)displayWidth;
	  g_oneOverMouseMovementScalarX = 1.0f / g_mouseMovementScalarX;
	  g_winWidth = displayWidth;
	} 
	else {
	  g_mouseMovementScalarX = 1.0f;
	  g_oneOverMouseMovementScalarX = 1.0f;
	  g_winWidth = (unsigned int)resolutionX;
	}

	if(displayHeight < resolutionY) {
	  /* cacluate scale ratio for the mouse movements */
	  g_mouseMovementScalarY = resolutionY / (float)displayHeight;
	  g_oneOverMouseMovementScalarY = 1.0f / g_mouseMovementScalarY;
	  g_winHeight = displayHeight;
	} 
	else {
	  g_mouseMovementScalarY = 1.0f;
	  g_oneOverMouseMovementScalarY = 1.0f;
	  g_winHeight = (unsigned int)resolutionY;
	}

	XResizeWindow( g_display, g_mainWindow, g_winWidth, g_winHeight );
	XFlush(g_display);
	XUngrabPointer(g_display, CurrentTime);
	XGrabPointer( g_display, g_mainWindow, 
		      False, 
		      (ButtonReleaseMask|ButtonPressMask|PointerMotionMask),
		      GrabModeAsync, GrabModeAsync, 
		      g_mainWindow,
		      None, CurrentTime );

}

void linux_EventLoop( void )
{
	XEvent xev;
	int i, num_events;

	//XFlush(g_display);
	XSync(g_display, False);
	num_events = XPending(g_display);

	while( (num_events != 0) ) {
		num_events--;

		XNextEvent(g_display, &xev);

		/* call the set UI function */
		(*gCurrUIFunction)(xev);
	}
}

/*
	linux_GetCursorPos() is similar to the Win32 function GetCursorPos()
	Sets the x, y values for the current mouse position
*/
void linux_GetCursorPos(POINT *mouseCoordinates)
{
    Window  theRoot, theChild;
    int     wX, wY, rootX, rootY, ErrorVal;
    unsigned int wButtons;

    ErrorVal = XQueryPointer(g_display, g_rootwin, &theRoot, &theChild, &rootX, &rootY, &wX, &wY, &wButtons);
    if (ErrorVal == True) {
		mouseCoordinates->x =(long)(wX*g_mouseMovementScalarX);
		mouseCoordinates->x = (long)(wY*g_mouseMovementScalarY);
    } else {
		mouseCoordinates->x = 0;
		mouseCoordinates->y = 0;
    }
}
void linux_SetCursorPos(int x, int y)
{
	XWarpPointer( g_display,
		      None, g_mainWindow,
		      0, 0,
		      0, 0,
		      (int)(x*g_oneOverMouseMovementScalarX), 
		      (int)(y*g_oneOverMouseMovementScalarY) );

	XSync(g_display, False);
}

/*
	linux_timeGetTime() is similar to the Win32 multimedia timer function timeGetTime()
	This function returns number of milliseconds since the UNIX Epoch (January 1, 1970)
*/

LONG linux_timeGetTime( void )
{
	struct timeval timeData;
	struct timezone timeZoneData;

	/* timeZoneData is not used and is only passed because gettimeofday requires it */
	gettimeofday( &timeData, &timeZoneData );

	timeData.tv_sec -= g_startTime;
	/* return the timestamp in milliseconds  */
	return ( (timeData.tv_sec * 1000) + timeData.tv_usec/1000 );
}



