/*
 *  desktop -- The 3dfx Desktop Demo 
 *  COPYRIGHT 3DFX INTERACTIVE, INC. 1999
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LIGHTING_H__
#define __LIGHTING_H__

#include "mathutil.h"
#include "basics.h"
/*#include "cpudetect.h"*/

// function pointers
extern float (*DirLightDiffuse)(Vector unit_norm);
extern void (*DirLightDiffuseAndSpecular)(Vector unit_norm, float *diffuse, float *specular);

void InitializeLighting(const CPUcaps *cpu_caps);
void SetLightAmbient(float ambient);
void DirLightXforms(Matrix rot_mat, Vector light_dir, Vector camera_dir);
float PointLightDiffuse(Vector point, Vector unit_norm);
void PointLightDiffuseAndSpecular(Vector point, Vector unit_norm, float *diffuse, float *specular);
void PointLightXforms(Matrix mat, Vector light_pos);
float LightDiffuse(Vector point, Vector unit_norm);

#endif // __LIGHTING_H__
