/* The control program is an Xlib program.  
 * This is fairly simple.  It just uses rectangles with pixmaps for buttons.
 */
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>

#include "control.h"
#include "init.h"

#define BUTTON_SIZE 64
#define BUTTON_PAD  16
#define APP_WIDTH    BUTTON_SIZE * 4 + BUTTON_PAD * (5+2)
#define THUMB_HEIGHT BUTTON_SIZE * 3 + BUTTON_PAD * 4
#define BORDER 2

#define BUTTON_MASK (ButtonPressMask)

#define FOREGROUND 0xFFFFFFFF

/* E0800D */

static void
control_quit (Main_Window *mw);

static void
control_background (Main_Window *mw);

static void
init_pixmaps (Main_Window *mw, int i);

static void
control_amplitude (Main_Window *mw, int part);

#define AMP_SLOT  0
#define AMP_GRIP  1
#define AMP_RIGHT 2
#define AMP_LEFT  3

/* Create the window and get everything ready */
Main_Window *
init_control (Display *display, Demo_State *state)
{
  Main_Window *mw;
  int i, index = 0;

  mw = (Main_Window*) malloc (sizeof (Main_Window));
  //mw->display = XOpenDisplay (NULL);
  //if (!mw->display)
  //{
  //  printf ("could not open display\n");
  //}
  mw->display = display;

  mw->window = XCreateSimpleWindow (mw->display, RootWindow(mw->display,0),
				    980, 924,
				    APP_WIDTH, 
				    BUTTON_SIZE + BUTTON_PAD * 3+THUMB_HEIGHT,
				    0, 
				    0,
				    0);
  if (!mw->window)
  {
    printf ("could not create window\n");
  }
  XStoreName (mw->display, mw->window, TITLE);

  /* Populate the window with a bunch of buttons */
  mw->background = XCreateSimpleWindow (mw->display, mw->window,
					BUTTON_PAD, BUTTON_PAD,
					BUTTON_SIZE, BUTTON_SIZE,
					BORDER,
					FOREGROUND,
					0);


  mw->quit = XCreateSimpleWindow (mw->display, mw->window,
				  BUTTON_SIZE + BUTTON_PAD*2, BUTTON_PAD,
				  BUTTON_SIZE, BUTTON_SIZE,
				  BORDER,
				  FOREGROUND,
				  0);

  mw->logo = XCreateSimpleWindow (mw->display, mw->window,
				  BUTTON_SIZE*2 + BUTTON_PAD*3, BUTTON_PAD,
				  96, BUTTON_SIZE,
				  0,
				  FOREGROUND,
				  0);
  mw->tux  = XCreateSimpleWindow (mw->display, mw->window,
				  BUTTON_SIZE*3 + BUTTON_PAD*5, BUTTON_PAD,
				  BUTTON_SIZE, BUTTON_SIZE,
				  0,
				  FOREGROUND,
				  0);

  /* Create a thumbnail window that remains unmapped until working with 
   * a textured background.
   */
  mw->thumb = XCreateSimpleWindow (mw->display, mw->window, 
				   BUTTON_PAD, BUTTON_SIZE + BUTTON_PAD*2,
				   APP_WIDTH - BUTTON_PAD * 2, THUMB_HEIGHT,
				   BORDER,
				   FOREGROUND,
				   0);

  /* Creat two radio buttons for tiling and scaling of the background image */
  mw->tiled = XCreateSimpleWindow (mw->display, mw->thumb, 
				   BUTTON_PAD, BUTTON_PAD,
				   BUTTON_SIZE * 2 + BUTTON_PAD, 32,
				   BORDER,
				   FOREGROUND,
				   0);

  /* Build my own slider control */
  mw->amp_slot = XCreateSimpleWindow (mw->display, mw->thumb,
				      BUTTON_PAD, BUTTON_PAD * 2 + 32,
				      BUTTON_SIZE * 2 + BUTTON_PAD, 32,
				      BORDER,
				      FOREGROUND,
				      0);
  mw->amp_grip = XCreateSimpleWindow (mw->display, mw->amp_slot,
				      BUTTON_SIZE + BUTTON_PAD/2 - 8, 0,
				      16, 32,
				      BORDER,
				      FOREGROUND,
				      0);
  

  /* The first two thumbs are in a row */
  for (i = 0; i < 2; i++)
  {
    mw->thumbs[index++] = 
      XCreateSimpleWindow (mw->display, mw->thumb,
			   BUTTON_PAD + (BUTTON_PAD + BUTTON_SIZE) * (2+i), 
			   BUTTON_PAD,
			   
			   BUTTON_SIZE, BUTTON_SIZE,
			   BORDER,
			   FOREGROUND,
			   0);			     
  }

  /* Next a row of 4 */
  for (i = 0; i < 4; i++)
  {
    mw->thumbs[index++] = 
      XCreateSimpleWindow (mw->display, mw->thumb,
			   BUTTON_PAD + (BUTTON_PAD + BUTTON_SIZE) * i,
			   BUTTON_PAD * 2 + BUTTON_SIZE,
			   
			   BUTTON_SIZE, BUTTON_SIZE,
			   BORDER,
			   FOREGROUND,
			   0);
    }

  /* And a last row of four */
  for (i = 0; i < 4; i++)
  {
    mw->thumbs[index++] = 
      XCreateSimpleWindow (mw->display, mw->thumb,
			   BUTTON_PAD + (BUTTON_PAD + BUTTON_SIZE) * i,
			   BUTTON_PAD * 3 + BUTTON_SIZE * 2,
			   
			   BUTTON_SIZE, BUTTON_SIZE,
			   BORDER,
			   FOREGROUND,
			   0);
  }


  /* Set the first expose flag to 0 so that the first expose will init
   * stuff 
   */

  /* Get mouse button presses for the windows */
  for (i = 0; i < NTHUMBS; i++)
  {
    XSelectInput (mw->display, mw->thumbs[i], BUTTON_MASK);
    mw->thumb_pix[i] = None;
  }

  XSelectInput (mw->display, mw->amp_slot, BUTTON_MASK);
  XSelectInput (mw->display, mw->amp_grip, BUTTON_MASK);
  XSelectInput (mw->display, mw->background, BUTTON_MASK);
  XSelectInput (mw->display, mw->quit, BUTTON_MASK);
  XSelectInput (mw->display, mw->tiled, BUTTON_MASK | ExposureMask);

  /* Set images for the buttons */
  //for (i = 0; i < NTHUMBS; i++)
  //{
    init_pixmaps (mw, i);  
    //}
  
  for (i = 0; i < NTHUMBS; i++)
    XMapWindow (mw->display, mw->thumbs[i]);
  //XMapWindow (mw->display, mw->amp_grip);
  //XMapWindow (mw->display, mw->amp_slot);
  XMapWindow (mw->display, mw->tiled);
  XMapWindow (mw->display, mw->thumb);
  XMapWindow (mw->display, mw->background);
  XMapWindow (mw->display, mw->tux);
  XMapWindow (mw->display, mw->logo);
  XMapWindow (mw->display, mw->quit);
  XMapWindow (mw->display, mw->window);
		       
  //mw->other_display = display;

  mw->state = state;
  mw->tiled_first_time = 1;

  return (mw);
}

void
redraw_window (Main_Window *mw, Window window, int x, int y, 
	       int width, int height)

{
  /* Build an expose event */
  XExposeEvent expose;

  expose.type = Expose;
  expose.display = mw->display;
  expose.window = window;
  expose.x = x;
  expose.y = y;
  expose.width = width;
  expose.height = height;
  expose.count = 0;

  XSendEvent (mw->display, window, True, ExposureMask, (XEvent*)&expose);
}

/* Process the events for the window */
void
window_process (Main_Window *mw)
{
  XEvent xev;
  XButtonEvent *e_button;
  XExposeEvent *e_expose;
  int i;

  while (XPending (mw->display))
  {
    XNextEvent (mw->display, &xev);

    switch (xev.type)
    {
    case Expose:
      e_expose = (XExposeEvent*)&xev;
      /* If it is the fps window then draw the fps */
      if (e_expose->window == mw->tiled)
      {
	if (mw->tiled_first_time)
	{
	  Font font;
	  XGCValues values;

	  /* Get a GC for the tiled window */
	  values.foreground = FOREGROUND;
	  values.background = 0x0;
	  mw->tiled_gc = XCreateGC (mw->display, 
				    mw->tiled,
				    GCForeground | GCBackground,
				    &values);

	  /* Now get a font */
	  font = XLoadFont (mw->display,
			    "-adobe-times-medium-r-*-*-*-140-*-*-*-*-*-*");
	  XSetFont (mw->display, mw->tiled_gc, font);
	  mw->tiled_first_time = 0;

	  /* Build a GC for the background button also */
	  mw->background_gc = XCreateGC (mw->display, 
					 mw->background,
					 GCForeground | GCBackground,
					 &values);
	}
      }
      break;
    case ButtonRelease:
    case ButtonPress:
      e_button = (XButtonEvent*)&xev;

      /* I only resond to button 1 */
      if (e_button->button == Button1)
      {
	if (e_button->window == mw->quit)
	{
	  control_quit (mw);
	}
	else if (e_button->window == mw->background)
	{
	  control_background (mw);
	}
	else if (e_button->window == mw->tiled)
	{
	  if (mw->bmode == BG_SCALED)
	  {
	    mw->bmode = BG_TILED;

	    /* Setup the texture info */
	    mw->state->background_texture_half_width = 640;
	    mw->state->background_texture_half_height = 512;	  
	    mw->state->background_clamp_mode = GR_TEXTURECLAMP_WRAP;

	    mw->state->tile_string = "Tiled";
	    /*redraw_window (mw, mw->tiled, 0, 0, 100, 32);*/
	    XSetWindowBackgroundPixmap (mw->display, mw->tiled, 
					mw->tiled_pix);
	    XCopyArea (mw->display, mw->tiled_pix, mw->tiled, 
		       mw->tiled_gc, 0, 0, 144, 32, 0, 0);

	    /* I need to rebuild the wave geometry */
	    init_wave (mw->state);
	  }
	  else if (mw->bmode == BG_TILED)
	  {
	    mw->bmode = BG_SCALED;

	    /* Setup the texture info */	    
	    mw->state->background_texture_half_width = 128;
	    mw->state->background_texture_half_height = 128.f * 512.f / 640.f;
	    mw->state->background_clamp_mode = GR_TEXTURECLAMP_CLAMP;

	    mw->state->tile_string = "Scaled";
	    XSetWindowBackgroundPixmap (mw->display, mw->background, 
					mw->scaled_pix);
	    XCopyArea (mw->display, mw->scaled_pix, mw->tiled, 
		       mw->tiled_gc, 0, 0, 144, 32, 0, 0);

	    /*redraw_window (mw, mw->tiled, 0, 0, 100, 32);*/

	    /* I need to rebuild the wave geometry */
	    init_wave (mw->state);
	  }
	}
	else if (e_button->window == mw->amp_grip)	    
	{
	  control_amplitude (mw, AMP_GRIP);
	}
	else if (e_button->window == mw->amp_slot)	    
	{
	  control_amplitude (mw, AMP_SLOT);
	}
	else if (e_button->window == mw->amp_left)	    
	{
	  control_amplitude (mw, AMP_LEFT);
	}
	else if (e_button->window == mw->amp_right)	    
	{
	  control_amplitude (mw, AMP_RIGHT);
	}
	else
	{
	  /* Test against all of the thumb buttons */
	  for (i = 0; i < NTHUMBS; i++)
	  {
	    if (e_button->window == mw->thumbs[i])
	    {
	      mw->state->background_index = i;
	      break;
	    }
	  }
	}
      }
      break;
    }
  }
}


static void
control_quit (Main_Window *mw)
{
  int i;

  /* Shut everything down */
#ifdef GPROG
  shutdown_glide ();
#endif

#ifdef XPROG
  /* Free my pixmaps */
  for (i = 0; i < NTHUMBS; i++)
    XFreePixmap (mw->display, mw->thumb_pix[i]);
#endif

  XFreeGC (mw->display, mw->tiled_gc);

  //XCloseDisplay (mw->other_display);
  
  XCloseDisplay (mw->display);

  exit (0);  
}

static void
control_amplitude (Main_Window *mw, int part)
{
  switch (part)
  {
  case AMP_LEFT:        
    break;
  case AMP_RIGHT:
    break;
  case AMP_SLOT:
    break;
  case AMP_GRIP:
    break;
  }
}

static void
control_background (Main_Window *mw)
{
  /* Used to placate the C++ compiler */
  int temp;

  /* Each press just increments the background type */  
  temp = ((int)mw->state->back + 1) % (int)BACK_LAST;
  mw->state->back = (Background_Type) temp;

  /* Set the new button */
  XSetWindowBackgroundPixmap (mw->display, mw->background, 
			      mw->bg_pix[temp]);

  /* Draw the new pixmap for the first time */
  XCopyArea (mw->display, mw->bg_pix[temp], mw->background, mw->background_gc, 
	     0, 0, 64, 64, 0, 0);

  switch (mw->state->back)
  {
  case BACK_WAVE:
  case BACK_SKY:
    mw->state->need_clears = 0;    
    break;
  case BACK_NONE:
    mw->state->need_clears = 1;
    break;
  case BACK_LAST:
    printf ("you should not use BACK_LAST\n");
    break;
  default:
    printf ("I don't know if I should clear the screen\n");
    break;
  }
}

static char *bg_button_pix[] = {
  "data/none.xpm",
  "data/rotate-orange.xpm",
  "data/ooze-orange.xpm",
};


static void
init_pixmaps (Main_Window *mw, int i)
{
  XpmAttributes xpmattr;
  XWindowAttributes winattr;
  char name[100];
  Pixmap crap;
  int status;  

  XGetWindowAttributes (mw->display, mw->thumbs[0], &winattr);
  xpmattr.depth = winattr.depth;
  xpmattr.valuemask = XpmDepth;  

#ifdef XPROG
  /* Get pixmaps for the background cycler */
  for (i = 0; i < (int)BACK_LAST; i++)
  {
    status = XpmReadFileToPixmap (mw->display, DefaultRootWindow(mw->display),
				  bg_button_pix[i],
				  &(mw->bg_pix[i]),
				  &crap,
				  &xpmattr);

    if (status != XpmSuccess)
    {
      printf ("failed to load %s\n", bg_button_pix[i]);
    }
  }
  if (crap != None)
    XFreePixmap (mw->display, crap);
  /* Start with the none pixmap */
  XSetWindowBackgroundPixmap (mw->display, mw->background, mw->bg_pix[0]);

  /* Get the Quit pixmap */
  status = XpmReadFileToPixmap (mw->display, DefaultRootWindow(mw->display),
				"data/quit.xpm",
				&(mw->quit_pix),
				&crap,
				&xpmattr);
  
  if (status != XpmSuccess)
  {
    printf ("failed to load %s\n", "quit.xpm");
  }

  if (crap != None)
    XFreePixmap (mw->display, crap);

  XSetWindowBackgroundPixmap (mw->display, mw->quit, mw->quit_pix);

  /* Get the pixmaps for the tiled and scaled toggle */
  status = XpmReadFileToPixmap (mw->display, DefaultRootWindow(mw->display),
				"data/Tiled-orange.xpm",
				&(mw->tiled_pix),
				&crap,
				&xpmattr);

  if (status != XpmSuccess)
  {
    printf ("failed to load %s\n", "Tiled-orange.xpm");
  }
  if (crap != None)
    XFreePixmap (mw->display, crap);

  status = XpmReadFileToPixmap (mw->display, DefaultRootWindow(mw->display),
				"data/Scaled-orange.xpm",
				&(mw->scaled_pix),
				&crap,
				&xpmattr);

  if (status != XpmSuccess)
  {
    printf ("failed to load %s\n", "Scaled-orange.xpm");
  }
  if (crap != None)
    XFreePixmap (mw->display, crap);

  /* Start with the scaled pixmap */
  XSetWindowBackgroundPixmap (mw->display, mw->tiled, mw->scaled_pix);

  /* Get the logo pixmap */
  status = XpmReadFileToPixmap (mw->display, DefaultRootWindow(mw->display),
				"data/logo2.xpm",
				&(mw->logo_pix),
				&crap,
				&xpmattr);
  if (status != XpmSuccess)
  {
    printf ("failed to load %s\n", "logo2.xpm");
  }
  if (crap != None)
    XFreePixmap (mw->display, crap);
  XSetWindowBackgroundPixmap (mw->display, mw->logo, mw->logo_pix);

  /* Get the tux pixmap */
  status = XpmReadFileToPixmap (mw->display, DefaultRootWindow(mw->display),
				"data/tux.xpm",
				&(mw->tux_pix),
				&crap,
				&xpmattr);
  if (status != XpmSuccess)
  {
    printf ("failed to load %s\n", "tux.xpm");
  }  
  if (crap != None)
    XFreePixmap (mw->display, crap);


  XSetWindowBackgroundPixmap (mw->display, mw->tux, mw->tux_pix);

  /* Do the thumbnail buttons */
  for (i = 0; i < NTHUMBS; i++)
  {
    sprintf (name, "%s.xpm", bg_names[i]);

    /* Load the pixmap */
    status = XpmReadFileToPixmap (mw->display, DefaultRootWindow(mw->display),
				  name,
				  &(mw->thumb_pix[i]),
				  &crap,
				  &xpmattr);
    
    if (crap != None)
      XFreePixmap (mw->display, crap);

    if (status != XpmSuccess)
    {
      printf ("failed to load %s\n", name);
    }

    /* Set the pixmap as the window background */
    XSetWindowBackgroundPixmap (mw->display, mw->thumbs[i], mw->thumb_pix[i]);
  }
#endif
}





