# =============================================================================
#
# File:		cb_dialog.tcl
# Project:	cb_tools
# Started:	?
# Changed:	10.07.95
#
# Description:	Contains several procs for simple dialog boxes.
#
# -----------------------------------------------------------------------------
#
# Sections:
#	proc cb_alert {text}
#	proc cb_info {text}
#	proc cb_error {text}
#	proc cb_yesno {text}
#	proc cb_okcancel {text}
#	proc cb_dialog {w title text bitmap default args}
#
# =============================================================================


# -----------------------------------------------------------------------------
# cb_alert: Shows an alert box with the label text.

proc cb_alert {text} {
    if [winfo exists .tcb_alert] return
    return [tk_dialog [toplevel .tcb_alert] \
	"Alert" \
	$text \
	warning \
	0 \
	"  OK  " \
	]
}

# -----------------------------------------------------------------------------
# cb_info: Shows an info box with the label text.

proc cb_info {text} {
    if [winfo exists .tcb_info] return    
    return [tk_dialog [toplevel .tcb_info] \
	"Info" \
	$text \
	info \
	0 \
	"  OK  " \
	]
}

# -----------------------------------------------------------------------------
# cb_error: Shows an error box with the label text.

proc cb_error {text} {
    if [winfo exists .tcb_error] return    
    return [tk_dialog [toplevel .tcb_error] \
	"Error" \
	$text \
	error \
	0 \
	"  OK  " \
	]
}

# -----------------------------------------------------------------------------
# cb_yesno: Shows a question box with the label text and yes/no buttons.

proc cb_yesno {text {default 0}} {
    if [winfo exists .tcb_yesno] return    
    return [tk_dialog [toplevel .tcb_yesno] \
	"Question" \
	$text \
	questhead \
	$default \
	" Yes " \
	" No "
	]
}

# -----------------------------------------------------------------------------
# cb_okcancel: Shows a question box with the label text and ok/cancel buttons.

proc cb_okcancel {text {default 0}} {
    if [winfo exists .tcb_okcancel] return    
    return [tk_dialog [toplevel .tcb_okcancel] \
	"Confirmation" \
	$text \
	questhead \
	$default \
	" OK " \
	" Cancel "
	]
}

