------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              S E M _ C H 5                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.11 $                             --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with Types; use Types;
with Uintp; use Uintp;

package Sem_Ch5 is

   procedure Analyze_Assignment                         (N : Node_Id);
   procedure Analyze_Block_Statement                    (N : Node_Id);
   procedure Analyze_Case_Statement                     (N : Node_Id);
   procedure Analyze_Exit_Statement                     (N : Node_Id);
   procedure Analyze_Goto_Statement                     (N : Node_Id);
   procedure Analyze_If_Statement                       (N : Node_Id);
   procedure Analyze_Implicit_Label_Declaration         (N : Node_Id);
   procedure Analyze_Loop_Statement                     (N : Node_Id);
   procedure Analyze_Null_Statement                     (N : Node_Id);
   procedure Analyze_Statements                         (L : List_Id);

   type Case_Bounds is record
     Choice_Lo   : Node_Id;
     Choice_Hi   : Node_Id;
     Choice_Node : Node_Id;
   end record;

   type Case_Table_Type is array (Nat range <>) of Case_Bounds;
   --  Table type used by Check_Case_Choices procedure

   procedure Sort_Case_Table (Case_Table : in out Case_Table_Type);
   --  Sort the Case Table using the Lower Bound of each Choice as the key.
   --  A simple insertion sort is used since the number of choices in a case
   --  statement of variant part will usually be small and probably in near
   --  sorted order.

   function Choice_In_Range
     (Lo, Hi   : Node_Id;
      Discr_Lo : Uint;
      Discr_Hi : Uint;
      Btype    : Entity_Id)
      return     Boolean;
   --  Returns false for null ranges and choices where the bounds
   --  are out of range of Discr_Lo .. Discr_Hi, otherwise returns
   --  true.  A message will be issued for choice bounds out of range.

   procedure Check_Case_Choices
     (Case_Table     : in out Case_Table_Type;
      N              : Node_Id;
      Choice_Type    : Entity_Id;
      Others_Present : Boolean);
   --  This is the procedure which verifies that a set of case choices
   --  is correct (has no duplicates, and covers the range). Case_Table
   --  contains the choices, N is the node for the construct, Choice_Type
   --  is the type of the value used for selection, and Others_Present is
   --  A flag indicating whether or not an others choice is present.

   function Number_Of_Case_Choices (N : Node_Id) return Nat;
   --  Iterates through the choices of a case statement or variant part of
   --  a record counting all the Choice nodes except for Others.

end Sem_Ch5;
