------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             W I D E C H A R                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.5 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package encapsulates the methods used to encode wide characters in
--  the character sequence of the source program. The method used depends on
--  the setting of Opt.Wide_Character_Encoding_Method.

--  Note: the implementation of the runtime packages Wide_Image (in file
--  s-widima.adb) and Wide_Value (in file s-widval.adb) must be coordinated
--  with the escape conventions that are implemented in this package for
--  correct operation of the Image, Value, Wide_Image, and Wide_Value
--  attributes.

with Types; use Types;

package Widechar is

   function Length_Wide return Nat;
   --  Returns the maxiumum length in characters for the escape sequence that
   --  is used to encode wide character literals outside the ASCII range.

   procedure Scan_Wide
     (S : Source_Buffer_Ptr;
      P : in out Source_Ptr;
      C : out Char_Code;
      E : out Boolean);
   --  On entry S (P) points to an ESC character that starts a wide character
   --  escape sequence or for conventions using the upper bit, to an upper
   --  half character starting a wide character sequence. A single wide
   --  character is scanned. If no error is found, the value stored in C is
   --  the code for this wide character, P is updated past the sequence and
   --  E is set to False. If an error is found, then P points to the improper
   --  character, C is undefined, and E is set to True.

   procedure Set_Wide
     (C : Char_Code;
      S : in out String;
      P : in out Natural);
   --  The escape sequence (including any leading ESC character) for the
   --  given character code is stored starting at S (P + 1), and on return
   --  P points to the last stored character (i.e. P is the count of stored
   --  characters on entry and exit, and the escape sequence is appended to
   --  the end of the stored string). The character code C represents a code
   --  originally constructed by Scan_Wide, so it is known to be in a range
   --  that is appropriate for the encoding method in use.

   procedure Skip_Wide (S : String; P : in out Natural);
   --  On entry, S (P) points to an ESC character for a wide character escape
   --  sequence or to an upper half character if the encoding method uses the
   --  upper bit. On exit, P is bumped past the wide character sequence. No
   --  error checking is done, since this is only used on escape sequences
   --  generated by Set_Wide, which are known to be correct.

end Widechar;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.3
--  date: Mon Apr  4 09:21:49 1994;  author: dewar
--  Minor reformatting
--  Change name to Widechar to fit in 8 characters
--  ----------------------------
--  revision 1.4
--  date: Fri Jul 22 11:45:19 1994;  author: dewar
--  Add documentation to note relationship to s-widima.adb, s-widval.adb
--  Rewrite spec for new encoding options in Opt
--  Change names Set_Escape, Skip_Escape to Set_Wide, Skip_Wide
--  ----------------------------
--  revision 1.5
--  date: Mon Jul 25 23:23:04 1994;  author: dewar
--  (Length_Wide): New function
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
