/* Copyright (C) 1992, the Florida State University
   Distributed by the Florida State University under the terms of the
   GNU Library General Public License.

This file is part of Pthreads.

Pthreads is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation (version 2).

Pthreads is distributed "AS IS" in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with Pthreads; see the file COPYING.  If not, write
to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.

Report problems and direct all questions to:

  pthreads-bugs@ada.cs.fsu.edu

  @(#)setjmp.h	2.1 3/16/94

*/

#ifndef _pthread_setjmp_h
#define _pthread_setjmp_h
#define __setjmp_h
#define _SETJMP_H

#ifdef SOLARIS
#include <sys/asm_linkage.h>
#else
#include <sparc/asm_linkage.h>
#endif

#include "signal.h"

struct jmp_buf {
  int sp, pc;
  sigset_t mask;
  int errno;
};

struct sigjmp_buf {
  int sp, pc;
  sigset_t mask;
  int errno;
};

#endif /*!_pthread_setjmp_h*/
