------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              D E B U G _ A                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.6 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains data and subprograms to support the A debug switch
--  that is used to generate output showing what node is being analyzed,
--  resolved, evaluated, or expanded.

with Types; use Types;

package Debug_A is

   --  Note: the following subprograms are used in a stack like manner, with
   --  an exit call matching each entry call. This means that they can keep
   --  track of the current node being worked on, with the entry call setting
   --  a new value, by pushing the Node_Id value on a stack, and the exit call
   --  popping this value off. Comperr.Fatal_Error_Node is set by both the
   --  entry and exit routines to point to the current node so that an abort
   --  message indicates the node involved as accurately as possible.

   procedure Debug_A_Entry (S : String; N : Node_Id);
   pragma Inline (Debug_A_Entry);
   --  Generates a message prefixed by a sequence of bars showing the nesting
   --  depth (depth increases by 1 for a Debug_A_Entry call and is decreased
   --  by the corresponding Debug_A_Exit call). Then the string is output
   --  (analyzing, expanding etc), followed by the node number and its kind.
   --  This output is generated only if the debug A flag is set. If the debug
   --  A flag is not set, then no output is generated. This call also sets the
   --  Node_Id value in Comperr.Fatal_Error_Node in case a bomb occurs. This is
   --  done unconditionally, whether or not the debug A flag is set.

   procedure Debug_A_Exit (S : String; N : Node_Id; Comment : String);
   pragma Inline (Debug_A_Exit);
   --  Generates the corresponding termination message. The message is preceded
   --  by a sequence of bars, followed by the string S, the node number, and
   --  a trailing comment (e.g. " (already evaluated)"). This output is
   --  generated only if the debug A flag is set. If the debug A flag is not
   --  set, then no output is generated. This call also resets the value in
   --  Comperr.Fatal_Error_Node to what it was before the corresponding call
   --  to Debug_A_Entry.

end Debug_A;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.4
--  date: Sun Jan  9 11:01:44 1994;  author: dewar
--  New header with 1994 copyright
--  ----------------------------
--  revision 1.5
--  date: Mon Apr  4 09:20:07 1994;  author: dewar
--  Change name from Debug_Sem to Debug_A to fit in 8 characters and
--   in any case this name is better since this is also used in Expand
--  ----------------------------
--  revision 1.6
--  date: Tue Apr  5 21:13:30 1994;  author: dewar
--  Document handling of Comperr.Fatal_Error_Node. The new approach sets the
--   value more accurately, because it is handled in a stack like fashion.
--  (Debug_A_Entry): Add pragma Inline
--  (Debug_A_Exit): Add pragma Inline
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
