------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               C A S I N G                                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.8 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package Casing is

   --  This package contains data and subprograms to support the feature that
   --  recognizes the letter case styles used in the source program being
   --  compiled, and uses this information for error message formatting, and
   --  for recognizing reserved words that are misused as identifiers.

   -------------------------------
   -- Case Control Declarations --
   -------------------------------

   --  Declaration of type for describing casing convention

   type Casing_Type is (

      All_Upper_Case,
      --  All letters are upper case

      All_Lower_Case,
      --  All letters are lower case

      Mixed_Case,
      --  The initial letter, and any letters after underlines are upper case.
      --  All other letters are lower case

      Unknown
      --  Used if an identifier does not distinguish between the above cases,
      --  (e.g. X, Y_3, M4, A_B, or if it is inconsistent ABC_def).
   );

   ------------------------------
   -- Case Control Subprograms --
   ------------------------------

   function Determine_Token_Casing return Casing_Type;
   --  Determines the casing style of the current token, which is either a
   --  keyword or an identifier. ). This subprogram can be called only
   --  during parsing.

   procedure Set_Casing (C : Casing_Type; D : Casing_Type := Mixed_Case);
   --  Takes the name stored in the first Name_Len positions of Name_Buffer
   --  and modifies it to be consistent with the casing given by C, or if
   --  C = Unknown, then with the casing given by D. The name is basically
   --  treated as an identifier, except that special separator characters
   --  other than underline are permitted and treated like underlines (this
   --  handles cases like minus and period in unit names, apostrophes in error
   --  messages, angle brackets in names like <any_type>, etc).

   procedure Set_All_Upper_Case;
   pragma Inline (Set_All_Upper_Case);
   --  This procedure is called with an identifier name stored in Name_Buffer.
   --  On return, the identifier is converted to all upper case. The call is
   --  equivalent to Set_Casing (All_Upper_Case). It is provided separately
   --  as a convenience for Gigi, which does not have Casing_Type available.

end Casing;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.6
--  date: Tue Apr  5 21:13:18 1994;  author: dewar
--  Add documentation on casing types
--  Unknown now includes cases like ABC_Def (previously treated as Mixed_Case)
--  ----------------------------
--  revision 1.7
--  date: Sun Apr 10 09:43:50 1994;  author: dewar
--  (Set_Casing): Document that special characters are treated like underline
--  ----------------------------
--  revision 1.8
--  date: Sun May 15 15:08:12 1994;  author: dewar
--  (Set_All_Upper_Case): New procedure
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
