/****************************************************************************/
/*                                                                          */
/*                        GNAT COMPILER COMPONENTS                          */
/*                                                                          */
/*                             A - U R E A L P                              */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                            $Revision: 1.3 $                              */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This file corresponds to the Ada package body Urealp. It was created
   manually from the files urealp.ads and urealp.adb. */

#include "config.h"
#include "tree.h"
#include "a-ada.h"
#include "a-types.h"
#include "a-atree.h"
#include "a-nlists.h"
#include "a-elists.h"
#include "a-sinfo.h"
#include "a-einfo.h"
#include "a-namet.h"
#include "a-string.h"
#include "a-uintp.h"
#include "a-urealp.h"

/* Universal reals are represented by the Ureal type which is an index into
   the Ureals_Ptr table containing Ureal_Entry values.  A Ureal_Entry contains
   a numerator value, a denominator value and a Bas value.  */

#define UI_Ge uintp__ui_ge
extern Boolean UI_Ge  PROTO ((Uint, Uint));

#define UI_Gt uintp__ui_gt
extern Boolean UI_Gt  PROTO ((Uint, Uint));

#define UI_Product uintp__ui_product
extern Uint UI_Product  PROTO ((Uint, Uint));

#define UI_Exponentiate uintp__ui_exponentiate
extern Uint UI_Exponentiate  PROTO ((Uint, Uint));

#define UI_From_Int uintp__ui_from_int
extern Uint UI_From_Int  PROTO ((Int));

#define UI_Negate uintp__ui_negate
extern Uint UI_Negate  PROTO ((Uint));

Uint
Numerator (Real)
     Ureal Real;
{
  Nat Bas = Ureals_Ptr[Real].Bas;
  Uint Num = Ureals_Ptr[Real].Num;

  if (Bas == 0)
    return Num;
  else
    {
      Uint Den = Ureals_Ptr[Real].Den;

      if (UI_Ge (Den, Uint_0))
	return Num;
      else
	return UI_Product (UI_Exponentiate (UI_From_Int (Bas),
					    UI_Negate (Den)), Num);
    }
}

Uint
Denominator (Real)
     Ureal Real;
{
  Nat Bas = Ureals_Ptr[Real].Bas;
  Uint Den  = Ureals_Ptr[Real].Den;

  if (Bas == 0)
    return Den;
  else
    {
      if (UI_Gt (Den, Uint_0))
	return UI_Exponentiate (UI_From_Int (Bas), Den);
      else
	return Uint_1;
     }
}

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.1
date: Thu Jun  2 16:00:27 1994;  author: crozes
Initial revision
----------------------------
revision 1.2
date: Fri Jun  3 22:02:22 1994;  author: dewar
Add missing header a-sinfo.h
----------------------------
revision 1.3
date: Mon Jun  6 12:16:23 1994;  author: kenner
Clean up formatting.
----------------------------
** New changes after this line and before endif. **
#endif
