/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A - A D A I N T                              */
/*                                                                          */
/*                            $Revision: 1.31 $                             */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/*  This file contains those routines named by "pragma interface_name"      */
/*  statements in the package unix_Library, which are not simply system     */
/*  or standard library calls.                                              */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "config.h"  /* this may define MSDOS or OS2  */

#ifndef O_BINARY
#define O_BINARY 0
#endif

#ifdef OS2

typedef struct
{
  unsigned short day   : 5;
  unsigned short month : 4;
  unsigned short year  : 7;
} FDATE;

typedef struct
{
  unsigned short twosecs : 5;
  unsigned short minutes : 6;
  unsigned short hours   : 5;
} FTIME;

typedef struct
{
  FDATE fdateCreation;
  FTIME ftimeCreation;
  FDATE fdateLastAccess;
  FTIME ftimeLastAccess;
  FDATE fdateLastWrite;
  FTIME ftimeLastWrite;
  unsigned long cbFile;
  unsigned long cbFileAlloc;
  unsigned short attrFile;
} FILESTATUS;

#endif  /* OS2 */

extern char *getenv ();


/* Return the maximum file name length.  */

int
Get_Maximum_File_Name_Length ()
{
#ifdef MSDOS
  return 8;
#else
  return -1;
#endif
}

/* Return the default switch character.  */

char
Get_Switch_Character ()
{
#ifdef OS2
  return '/';
#else
  /* Under MSDOS, the switch character is not normally a hyphen, but this is
     the convention DJGPP uses.  */
  return '-';
#endif
}

/* Return nonzero if switch characters are case sensitive.  */

int
Get_Switches_Case_Sensitive ()
{
#ifdef OS2
  return 0;
#else
  return 1;
#endif
}

/* Return nonzero if file names are case sensitive.  */

int
Get_File_Names_Case_Sensitive ()
{
#if defined (OS2) || defined (MSDOS)
  return 0;
#else
  return 1;
#endif
}

char
Get_Default_Identifier_Character_Set ()
{
#if defined (OS2) || defined (MSDOS)
  return 'p';
#else
  return '1';
#endif
}

char
Get_Directory_Separator ()
{
#if defined (OS2) || defined (MSDOS)
  return '\\';
#else
  return '/';
#endif
}

char
Get_Path_Separator ()
{
#ifdef PATH_SEPARATOR
  return PATH_SEPARATOR;
#else
  return ':';
#endif
}

/* Return the suffix for object files; the argument, str, is assumed to point
   to an array of at least 4 characters.  */

void
Get_Object_Suffix (str)
     char *str;
{
#ifdef OS2
  strcpy (str, "obj");
#else
  /* Under MSDOS, the suffix for object files is not normally .o, but this is
     the convention DJGPP uses.  */
  strcpy (str, "o");
#endif
}

int
open_read (path)
     char *path;
{
  return open (path, O_RDONLY | O_BINARY);
}

int
open_create (path)
     char *path;
{
  return open (path, O_WRONLY | O_CREAT | O_TRUNC,
	       S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
}

/* Return the number of bytes in the specified file. */

long
file_length (fd)
     int fd;
{
  int ret;
  struct stat statbuf;

  ret = fstat (fd, &statbuf);
  if (ret || !S_ISREG (statbuf.st_mode))
    return 0;

  return (statbuf.st_size);
}

int
is_regular_file (name)
     char *name;
{
  int ret;
  struct stat statbuf;

  ret = stat (name, &statbuf);
  return (!ret && S_ISREG (statbuf.st_mode));
}

/* Return a GNAT time stamp given a file name.  */

void
file_time_name (name, stamp)
     char *name;
     char *stamp;
{
  struct stat statbuf;
  char buf[13];

#ifdef OS2
  int fd = open (name, O_RDONLY | O_BINARY);
  unsigned long Dos32QueryFileInfo () asm ("Dos32QueryFileInfo");
  FILESTATUS fs;

  int ret = Dos32QueryFileInfo (fd, 1, (unsigned char *) &fs,
				sizeof (FILESTATUS));

  sprintf (buf, "%2d%02d%02d%02d%02d%02d",
	   fs.fdateLastWrite.year + 80, fs.fdateLastWrite.month,
	   fs.fdateLastWrite.day, fs.ftimeLastWrite.hours,
	   fs.ftimeLastWrite.minutes, fs.ftimeLastWrite.twosecs * 2);
  close (fd);

#else

  int ret = stat (name, &statbuf);

  /* Not doing anything with errors here! */
  strftime (buf, 13, "%y%m%d%H%M%S", gmtime (&statbuf.st_mtime));

#endif

  strncpy (stamp, buf, 12);
}

/* Return a GNAT time stamp given a file descriptor.  */

void
file_time_fd (fd, stamp)
     int fd;
     char *stamp;
{
  struct stat statbuf;
  char buf[13];

#ifdef OS2
  unsigned long Dos32QueryFileInfo () asm ("Dos32QueryFileInfo");
  FILESTATUS fs;
  int ret = Dos32QueryFileInfo (fd, 1, (unsigned char *) &fs,
				sizeof (FILESTATUS));

  sprintf (buf, "%2d%02d%02d%02d%02d%02d",
	   fs.fdateLastWrite.year + 80, fs.fdateLastWrite.month,
	   fs.fdateLastWrite.day, fs.ftimeLastWrite.hours,
	   fs.ftimeLastWrite.minutes, fs.ftimeLastWrite.twosecs * 2);
#else

  int ret = fstat (fd, &statbuf);

  /* Not doing anything with errors here! */
  strftime (buf, 13, "%y%m%d%H%M%S", gmtime (&statbuf.st_mtime));
#endif

  strncpy (stamp, buf, 12);
}

void
get_env_value_ptr (name, len, value)
     char *name;
     int *len;
     char **value;
{
  *value = getenv (name);
  if (!*value)
    *len = 0;
  else
    *len = strlen (*value);

  return;
}

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.29
date: Mon Jun  6 21:44:04 1994;  author: kenner
(file_time_fd): Fix typo in last change.
----------------------------
revision 1.30
date: Sun Jun 12 00:08:01 1994;  author: figueroa
(Get_Object_Suffix): return a null-terminated string, rather than just the
 first three characters of the string
----------------------------
revision 1.31
date: Fri Jul  8 19:34:50 1994;  author: figueroa
(Get_File_Names_Case_Sensitive): new function
----------------------------
** New changes after this line and before endif. **
#endif
