# --- ${C_BLDDIR}config.h

if test -n "$B_config_h"
then

F_define=yep
F_using=yep

echo
echo Building ${C_BLDDIR}config.h...

(exec >${C_BLDDIR}config.h

{
echo
echo '	starting features probing...'
echo
} >&2

cat <<foo
/* config.h */
/* architecture-customized config.h for $VERSION
 * for architecture "$arch",
 * automagically generated by buildzsh -- do not edit */

foo

set elfh elf.h ${headerdir}/sys
. bz.walk

set resourceh resource.h ${headerdir}/sys
. bz.walk

set 'test -n "$elfh" -o -z "$resourceh"' SYSV 1 'pure SYSV'
. bz.ifdef

if test -n "$_yea"
then
  PATH=/usr/bin:$PATH
  export PATH
  echo '	forcing /usr/bin early in PATH...' >&2
  if test -n "${elfh}"
  then
    echo '#define SYSVR4'
    echo '	looks like a SYSVR4 system...' >&2
    force_setpgid=1
    force_strftime=1
    if test -n "$SOLARIS"
    then
      echo '#define SOLARIS'
      echo '	looks like a Solaris...' >& 2
    fi
    echo
  fi
fi

echo '/* some environments have broken termios, for example ULTRIX */'
set 'test -z "$ULTRIX" -a -z "$APOLLO" -a -z "$BBN" -a -z "$NEXT" -a -f ${headerdir}/termios.h' HAS_TERMIOS 1 'termios'
. bz.ifdef

if test -z "$_nay"
then
  test -n "$DGUX" && echo '#define CLOBBERS_TYPEAHEAD 1'
else

set 'test -z "$ULTRIX" -a -z "`grep sgttyb ${headerdir}/sys/ioctl.h 2>/dev/null`"' HAS_TERMIO 1 'termio'
. bz.ifdef
echo '	using sgttyb...' >&2

if test -z "$ULTRIX" -a -z "$NEXT"
then
cat <<foo
#define TTY_NEEDS_DRAINING 1
#define CLOBBERS_TYPEAHEAD 1

foo
fi

fi

test -n "$IRIX5" && echo '#define IRIX5'
  
set 'test -f ${headerdir}/dirent.h \
          -a -z "$NEXT" -a -z "$ULTRIX"'\
    HAS_DIRENT 1 '<dirent.h>'
. bz.ifdef

set 'test -f ${headerdir}/unistd.h' HAS_UNISTD 1 '<unistd.h>'
. bz.ifdef

set stdlibh stdlib.h "/usr/include/ansi ${headerdir}"
. bz.walk

if test -n "$stdlibh"
then
   set 'grep alloc $stdlibh >/dev/null 2>&1' HAS_STDLIB 1 '<stdlib.h>'
  . bz.ifdef
fi

set 'test -f ${headerdir}/string.h' HAS_STRING 1 '<string.h>' '<strings.h>'
. bz.ifdef

if test -f ${headerdir}/strings.h -a -n "${NEXT}" -a Z"${NEXT}" != Z3.x
then
cat <<foo
/* BSD compat */
#define strchr	index
#define strrchr	rindex
foo
fi

set 'test -f ${headerdir}/memory.h' HAS_MEMORY 1 '<memory.h>'
. bz.ifdef

if test -n "$_nay"
then
set 'grep memset ${headerdir}/string.h >/dev/null 2>&1' '' '' 'memcpy(),memset(),memcmp() from <string.h>' 'redefined memcpy(), memset(), memcmp()' '' '' '
#define memcpy(dst, src, n)	bcopy(src, dst, n)
#define memset(dst, ch, n)	do {\
	char *__DST__ = (char *)(dst);\
	int __N__ = (int)(n), __CH__ = (int)(ch);\
	while (__N__--) { __DST__[__N__] = __CH__; } } while(0)
#define memcmp(s1, s2, n)	bcmp(s1, s2, n)'
. bz.ifdef
fi

set 'test -f ${headerdir}/locale.h' HAS_LOCALE 1 '<locale.h>'
. bz.ifdef

if test -f "${headerdir}/utmpx.h"
then
  _utmp_hs_="${headerdir}/utmpx.h ${headerdir}/utmp.h"
else
  _utmp_hs_="${headerdir}/utmp.h"
fi

set utmph "utmpx.h utmp.h" ${headerdir}
. bz.walk

set 'test Z$utmph = Z${headerdir}/utmpx.h' HAS_UTMPX 1 '<utmpx.h>' '<utmp.h>'
. bz.ifdef

set 'grep ut_host $utmph >/dev/null 2>&1 && ( test Z"$host" != Zmips || test -n "$OSF1" )' UTMP_HOST 1 'host field in utmp'
. bz.ifdef

set 'test -f ${headerdir}/time.h && grep timeval ${headerdir}/time.h >/dev/null 2>&1' HAS_TIME 1 '<time.h>' '<sys/time.h>'
. bz.ifdef

set waith wait.h "${headerdir} ${headerdir}/sys"
. bz.walk

set 'test Z$waith = Z${headerdir}/wait.h' HAS_WAIT 1 '<wait.h>' '<sys/wait.h>'
. bz.ifdef

set 'test -z "$NEXT" && grep "waitpid.*(" $waith >/dev/null 2>&1 || man 2 wait 2>/dev/null | sed "s/_.//g" | grep waitpid >/dev/null' HAS_WAITPID 1 'waitpid()'
. bz.ifdef

set 'grep FD_SET ${headerdir}/sys/types.h >/dev/null 2>&1 || test -f ${headerdir}/sys/select.h || test -n "$LINUX"' HAS_SELECT 1 'select()'
. bz.ifdef

set 'test -f ${headerdir}/sys/select.h \
     && \
     grep "struct  *fd_set " ${headerdir}/sys/select.h >/dev/null 2>&1' \
     HAS_SYS_SELECT 1 \
     '<sys/select.h>' '' '"struct fd_set" in <sys/select.h>'
. bz.ifdef

cat <<foo
/* we can't just test for S_IFIFO or check to see if the mknod worked,
   because the NeXTs sold by a vendor which will remain nameless will
   happily create the FIFO for you, and then panic when you try to do
	something weird with them, because they aren't supported by the OS. */
foo
set 'test -z "$NEXT" -o Z"$NEXT" != Z2.x' HAS_FIFOS 1 'fifos'
. bz.ifdef

set 'test -n "$force_strftime" -o -n "$MIPS" -o -n "$AIX" -o -n "$LINUX" || \
     man 3 strftime 2>/dev/null | grep return >/dev/null || \
     man -s 3c strftime 2>/dev/null | grep return >/dev/null' \
    HAS_STRFTIME 1 'strftime()'
. bz.ifdef

set 'test -n "$MIPS" -o -n "$AIX" || \
     grep tcsetpgrp ${headerdir}/unistd.h >/dev/null 2>&1 || \
     man tcsetpgrp 2>/dev/null | grep process >/dev/null && test -z "$NEXT"' \
    HAS_TCSETPGRP 1 'tcsetpgrp()'
. bz.ifdef

_term_hs_="${headerdir}/termio.h ${headerdir}/sys/termio.h ${headerdir}/termios.h ${headerdir}/sys/termios.h"

set 'test -z "$NEXT" -a -n "`grep tcgetattr $_term_hs_ 2>/dev/null`"' \
     HAS_TCCRAP 1 'tcgetattr() and friends'
. bz.ifdef

if test -n "$_nay" -a \( -n "$IRIX" -o -n "$MIPS" \)
then
echo '
/* some environments like IRIX have a broken setpgid()
 * setpgrp() might come to rescue */'
fi
set 'test -n "$AIX" -o -n "$LINUX" -o -n "$force_setpgid" || \
     man setpgid 2>/dev/null | grep process >/dev/null && \
     test -z "$IRIX" -a -z "$MIPS" -a -z "$NEXT"' \
     HAS_SETPGID 1 'setpgid()' 'setpgrp()'
. bz.ifdef

if test -n "$TITAN"
then
echo '
/* TitanOS has sigrelse(), sighold() and sigset() but it cannot use
 * them simultaneously with -43 */'
fi

_signal_hs_="${headerdir}/signal.h ${headerdir}/sys/signal.h ${headerdir}/linux/signal.h"

set 'test -z "$HPUX" -a -z "$PYR" -a -z "$MIPS" -a -z "$AIX" -a -z "$TITAN" &&
    (grep SIGRELSE $_signal_hs_ > /dev/null 2>&1 || \
     man sigrelse 2>/dev/null | grep signal >/dev/null)' \
    HAS_SIGRELSE 1 'sigrelse()' 'sigblock()'
. bz.ifdef

set 'test -d /../.CONTROL' HAS_RFS 1 RFS
. bz.ifdef

cat <<foo
/* the stress is on "a working wait3()" because for example HP-UX has
 * sort of working getrusage() but nothing like wait3() */
foo
set 'test -f $resourceh -a -z "$HPUX" -a -z "$UNICOS" -a -z "$SOLARIS"' HAS_RUSAGE 1 'getrusage() and wait3()'
. bz.ifdef

if test Z"$host" = Zhp9000s700
then
echo '	using hp9000s700 rlimit kludge...' >&2
echo '
/* kludge RLIM code for HPUX s700 - These limits are all readable,and
 * some like coredumpsize are settable by users
 */
#define RLIMIT_CPU	0		/* cpu time in milliseconds */
#define RLIMIT_FSIZE	1		/* maximum file size */
#define RLIMIT_DATA	2		/* data size */
#define RLIMIT_STACK	3		/* stack size */
#define RLIMIT_CORE	4		/* core file size */
#define RLIMIT_RSS	5		/* resident set size */

#define RLIM_INFINITY	0x7fffffff
'
fi

STD_DUMP="cat /etc/passwd"
NIS_DUMP="ypcat passwd.byname"
NI_DUMP="nidump passwd /"
DUMP_USERS="$STD_DUMP"

set 'test -f /usr/bin/ypcat && $NIS_DUMP > /dev/null 2>&1' HAS_NIS 1 NIS
. bz.ifdef

if test -n "$_yea"
then
  DUMP_USERS="$NIS_DUMP"
else
  test -d /NextApps && $NI_DUMP > /dev/null 2>&1 && DUMP_USERS="$NI_DUMP"
fi

lot_user=`$DUMP_USERS | awk '{if(NR>'$LOTSA_USERS'){print;exit 1}}'`
if test -n "$B_query"
then
{
  echo
  echo "Username caching is useful if there are more than $LOTSA_USERS users..."
} >&2
fi
G_verb2_=use
set 'test -n "$lot_user"' CACHE_USERNAMES 1 'username caching'
. bz.ifdef

set 'egrep "SIG_DFL|sighandler_t" $_signal_hs_ 2>/dev/null | grep void > /dev/null && test -z "$IRIX"' SIGVOID 1 'signal handlers returning void' 'signal handlers returning int'
. bz.ifdef

set 'test -n "`grep SIGTSTP $_signal_hs_ 2>/dev/null`"' \
    HAS_AUTORESETHAND 1 'automatically reset signal handlers' \
    'forced reset signal handlers'
. bz.ifdef

if test -n "$_yea"
then
set 'test -z "$HPUX" -a -z "$MIPS" -a -z "$IRIX" -a -z "$TITAN" -a -z "$AIX" \
   && (man 2 sigset 2>/dev/null | grep handler >/dev/null )' \
    USE_SIGSET 1 'sigset() to install said signal handlers'
. bz.ifdef
fi

{
echo
echo '	finished probing features...'
} >&2

cat <<foo
#if defined(SIGVOID) || defined(IRIX5)
#define HANDTYPE void
#else
#define HANDTYPE int
#define INTHANDTYPE
#endif

/* a string corresponding to the host type */

#define HOSTTYPE "$host"

/* the default editor for the fc builtin */
#define DEFFCEDIT "vi"
foo
echo

if test -n "`egrep 'UTMP_FILE|_PATH_UTMP' $_utmp_hs_ 2>/dev/null`"
then :
else 
set WTMP wtmp "/etc /usr/etc /var/adm /usr/adm" /dev/null
. bz.walk
set UTMP utmp "/etc /usr/etc /var/adm /usr/adm" /dev/null
. bz.walk
cat <<foo
/* the path of wtmp */
#define WTMP_FILE "$WTMP"

/* the path of utmp */
#define UTMP_FILE "$UTMP"
foo
fi

{
  echo
  echo '	defining installation specifics...'
  echo
} >&2

set DEFTMPPREFIX /tmp/zsh 'default prefix for temporary files' '' '"'
. bz.define

set GLOBALZSHENV /etc/zshenv \
"the global file to source absolutely first whenever zsh is run;
if undefined, don't source anything" 1 '"'
. bz.define

set GLOBALZSHRC /etc/zshrc \
"the global file to source whenever zsh is run;
if undefined, don't source anything" 1 '"'
. bz.define

set GLOBALZLOGIN /etc/zlogin \
"the global file to source whenever zsh is run as a login shell;
if undefined, don't source anything" 1 '"'
. bz.define

set GLOBALZPROFILE /etc/zprofile \
"the global file to source whenever zsh is run as a login shell,
before zshrc is read; if undefined, don't source anything" 1 '"'
. bz.define

F_define=yep

if test -n "$B_query"
then
{
  echo
  echo "The following question is about the text printed by zsh"
  echo "when a process is suspended/stopped under job control."
} >&2
fi
G_verb2_=prefer
set true USE_SUSPENDED 1 '"suspended" instead of "stopped"' '"stopped" instead of "suspended"'
. bz.ifdef

set DEFAULT_HISTSIZE 30 \
"the default history buffer size in lines"
. bz.define

cat <<'foo'
#define _BSD_COMPAT		/* this could be IRIX,  you never know */
#define _BSD_TYPES		/* this could be IRIX5, you never know */
#define _BSD			/* this could be HP-UX, you never know */
#define _BSD_INCLUDES		/* this could be AIX,   you never know */
#define _BBN_POSIX_SUPPORT	/* this could be nX,    you never know */

/* if your compiler doesn't like void *,
 * change this to char * and ignore all the warnings. */

typedef void * vptr;

#define JOB_CONTROL

/* define this if you want to use zsh's own allocator */
/* #define USE_ZSH_MALLOC */

#ifdef USE_ZSH_MALLOC

/* define this if you want the allocator to store information */

/* #define MEM_DEBUG */

/* define this if you want to get error messages from the allocator */

/* #define MEM_WARNING */

/* define this if you want free() to be really save */

/* #define SECURE_FREE */

#endif /* USE_ZSH_MALLOC */

/* end of config.h */
foo

{
  echo
  echo '	defined installation specifics...'
} >&2

)
fi
