/*
 * libhigh.c - client library - high level (gpm-Linux)
 *
 * Copyright 1994   rubini@ipvvis.unipv.it (Alessandro Rubini)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#include <stdio.h>
#include <stdlib.h>

#include "gpmInt.h"

Gpm_Roi *gpm_roi=NULL;

/*-------------------------------------------------------------------*/
Gpm_Roi *Gpm_PushRoi(int x, int y, int X, int Y, int mask,
					 Gpm_Handler *fun, void *xtradata)
{
Gpm_Roi *new;

  /* create a Roi and push it */
  new=(Gpm_Roi *)malloc(sizeof(Gpm_Roi));
  if (!new) return NULL;

  new->xMin=x;         new->xMax=X;
  new->yMin=y;         new->yMax=Y;
  new->minMod=0;       new->maxMod=~0;
  new->prev      =     new->next=NULL;
  new->eventMask=mask;
  new->owned=0;        /* use free() */
  new->handler=fun;
  new->xtradata=xtradata;
  return Gpm_RaiseRoi(new,NULL);
}

/*-------------------------------------------------------------------*/
Gpm_Roi *Gpm_UseRoi(Gpm_Roi *new)
{
  /* use a Roi by pushing it */
  new->prev      =     new->next=NULL;
  new->owned=1;        /* don't free() */
  return Gpm_RaiseRoi(new,NULL);
}

/*-------------------------------------------------------------------*/
Gpm_Roi *Gpm_PopRoi(Gpm_Roi *which)
{
  /* extract the Roi and remove it */
  if (which->prev) which->prev->next = which->next;
  if (which->next) which->next->prev = which->prev;
  if (gpm_roi==which) gpm_roi=which->next;
  
  if (which->owned==0) free(which);
  
  return gpm_roi; /* return the new top-of-stack */
}

/*-------------------------------------------------------------------*/
Gpm_Roi *Gpm_RaiseRoi(Gpm_Roi *which, Gpm_Roi *before)
{
  /* raise a Roi above another, or to top-of-stack */
  if (!before) before=gpm_roi;

  if (which->prev) which->prev->next = which->next;
  if (which->next) which->next->prev = which->prev;
  if (gpm_roi==which) gpm_roi=which->next;

  which->prev=before->prev; before->prev=which;
  which->next=before;

  if (which->prev) which->prev->next=which;
  else gpm_roi=which;

  return gpm_roi; /* return the new top-of-stack */
}

/*-------------------------------------------------------------------*/
Gpm_Roi *Gpm_LowerRoi(Gpm_Roi *which, Gpm_Roi *after)
{
  /* lower a Roi below another, or to bottom-of-stack */
  if (!after)
    for (after=gpm_roi; after->next; after=after->next)
      ;
  if (which->prev) which->prev->next = which->next;
  if (which->next) which->next->prev = which->prev;
  if (gpm_roi==which) gpm_roi=which->next;

  which->next=after->next; after->next=which;
  which->prev=after;

  if (which->next) which->next->prev=which;

  return gpm_roi; /* return the new top-of-stack */
}



/*===================================================================*
 * This function is in care of all event dispatching.
 * It generates also GPM_ENTER and GPM_LEAVE events.
 */

int Gpm_HandleRoi(Gpm_Event *ePtr)
{}




