/*
 * gpmInt.h - server-only stuff for gpm-Linux
 *
 * Copyright 1994   rubini@ipvvis.unipv.it (Alessandro Rubini)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ********/

#include "gpmCfg.h"
#include "gpm.h"

#if !defined(__GNUC__)
#define inline
#endif 

#include "wd.h" /* when debugging macros */

/*....................................... Logging */
#ifdef CONFIG_GPM_LOG
#  define LOG(args) Log args
extern int Log(char *fmt, ...);
#else
#  define LOG(args) 1
#endif
/* a placeholder */
#define LOGG(args) 1

/*....................................... Structures */


/*
 * and this is the entry in the mouse-type table
 */
typedef struct Gpm_Type {
  char *name;
  int (*fun)(Gpm_Event *state, unsigned char *data);
  int (*init)(int fd, unsigned short flags, struct Gpm_Type *type);
  unsigned short flags;
  unsigned char proto[5];
  int howmany; /* howmany bytes to read at a time */
}                   Gpm_Type;


typedef struct Gpm_Cinfo {
  Gpm_Connect data;
  int fd;
  struct Gpm_Cinfo *next;
}              Gpm_Cinfo;


/*....................................... Compatibility issues */

#ifdef EWOULDBLOCK
#  define GPM_AGAIN EAGAIN
#else
#  define GPM_AGAIN EAGAIN
#endif

/*....................................... Global variables */

extern char *prgname;
extern char *opt_type, *opt_lut, *opt_dev;
extern char *opt_sequence;
extern int opt_baud, opt_sample, opt_delta, opt_accel, opt_scale;
extern int opt_dirty, opt_test, opt_time, opt_cluster, opt_three, opt_ptrdrag;
extern int opt_kill;

extern Gpm_Type mice[];
extern Gpm_Type *m_type;
extern struct winsize win;
extern int maxx, maxy;
extern Gpm_Cinfo *cinfo[MAX_VC+1];

/*....................................... Prototypes */
       /* gpm.c */
int main(int argc, char **argv);

       /* gpn.c */
int Log(char *fmt,...);              /* the logging utility               */
int _oops(char *f, int n, char *s,int err);  /* printf's and exit(1)      */
#define oops(s) _oops(__FILE__, __LINE__,(s),errno)
int cmdline(int argc, char **argv);

/*....................................... Dirty hacks */

#ifndef linux /* no strerror() on sunos 4.1 */
extern char *sys_errlist[];
#define strerror(foo) (sys_errlist[foo])
#endif

#undef GPM_USE_MAGIC /* magic token foreach message? */


#ifdef GPM_USE_MAGIC
#define MAGIC_P(code) code
#else
#define MAGIC_P(code) 
#endif
