%{
/*
Copyright (c) 1993 Jason Patterson.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted.

Be aware, however, that using this software to extract icons from commercial
Macintosh applications may violate the copyright on these applications.

JASON PATTERSON DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO
EVENT SHALL JASON PATTERSON BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM THE LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/
/************************************************************************/
/*									*/
/* macrestoxpm: extract icons from mac reources and write out xpm icons	*/
/*									*/
/************************************************************************/

#include "y.tab.h"
#include "macres.h"

static void make_resnum();
static void make_bytestr();

int lineno = 0;
%}

%%

"data"				{ return DATA; }
"resource"			{ return DATA; }
"\'ICN#\'"			{ yylval.type = ICN;   return TYPE; }
"\'ics#\'"			{ yylval.type = ics;   return TYPE; }
"\'icl4\'"			{ yylval.type = icl4;  return TYPE; }
"\'ics4\'"			{ yylval.type = ics4;  return TYPE; }
"\'icl8\'"			{ yylval.type = icl8;  return TYPE; }
"\'ics8\'"			{ yylval.type = ics8;  return TYPE; }
"\'ICON\'"			{ yylval.type = ICON;  return TYPE; }
"\'SICN\'"			{ yylval.type = SICN;  return TYPE; }
"\'CURS\'"			{ yylval.type = CURS;  return TYPE; }
"\'"[^\n][^\n][^\n][^\n]"\'"	{ yylval.type = other; return TYPE; }
"("[-]?[0-9]+[^\n]*"{"		{ make_resnum(); return OPEN; }
[ \t]*"$\""[^\n]*"\""[^\n]*	{ make_bytestr(); return STR; }
"}"[ \t]*";"			{ return CLOSE; }
"\n"				{ ++lineno; }
.				{}

%%

static void make_resnum()
{
  if (type != other)
  {
    char *p = yytext;
    while (*p != '-' && (*p < '0' || *p > '9')) ++p;
    yylval.num = atoi(p);
  }
}

static void make_bytestr()
{
  if (type != other)
  {
    static unsigned char hextbl[] =
    {
      0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0,10,11,12,13,14,15,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0,10,11,12,13,14,15
    };
    
    int n;
    char *p = yytext;
    while (*p++ != '\"');
    
    for (n = 0; *p != '\"'; ++n)
    {
      yylval.bytestr[n] = (hextbl[p[0] - '0'] << 4) | hextbl[p[1] - '0'];
      p += 2; if (*p == ' ') ++p;
    }
  }
}

#ifndef yywrap
int yywrap() { return 1; }
#endif
