/*
 ****************************************************************************
 *
 *	File:	calc_cb.C
 *
 *	Function(s):
 *
 *	Description:
 *		calc callback stubs, generated by the OI UIB.
 *
 *	RCSid = "$Id: calc_cb.C,v 1.1.1.1 1993/06/10 17:12:08 mth Exp $"
 *
 ****************************************************************************
 */
#include <OI/oi.H>
#include "calc.H"
#include "calc_bd.H"

/*
 *	The following definitions are generated and read by the user
 *	interface builder to simplify the process of generating prototype
 *	stubs.
 *
 *	The user interface builder will ONLY preserve prototype stubs placed
 *	above the dividing line (below).  If you need to include additional
 *	header files to ensure that your program compiles, please include 
 *	them in
 *		calc.H
 *
 *	CAVEAT
 *		These definitions ensure that a prototype stub is not
 *		regenerated.   PLEASE leave the definition here
 *		even if you move the stub to another file.
 *	
 */

extern void numeric (OI_menu_cell *, void *, OI_number);
extern void decimal (OI_menu_cell *, void *, OI_number);
extern void pending (OI_menu_cell *, void *, OI_number);
extern void clear (OI_menu_cell *, void *, OI_number);


/* End of Function Declarations -- Protected User Code begins at next line */

#include <stdlib.h>
#include <string.h>

static	op_t	pending_op = NONE;	/* currently pending operation */
static	double	pending_value = 0.0;	/* accumulated value */
static	OI_bool	start_new_val = OI_YES;	/* should next input start new value? */

/*
****************************************************************************
*
*	Function Name: push_value
*
*	Description:
*	This routine is called whenever we need to capture the
*	currently displayed value. The displayed value is
*	captured into a global variable, and then a flag is
*	marked to indicate that we need to start building a new
*	value with the next keystroke.
*
*	Returns:
*		nothing
*
*	Side Effects:
*		none.
*
*	Warnings:
*		none.
*
****************************************************************************
*/
static void
push_value()
{
	pending_value = atof( ndisplay->text() );
	start_new_val = OI_YES;
}
/*
****************************************************************************
*
*	Function Name: do_pending
*
*	Description:
*	This routine is called whenever we need to process the currently
*	pending operation.
*
*	Returns:
*		nothing
*
*	Side Effects:
*		none.
*
*	Warnings:
*		none.
*
****************************************************************************
*/
static void
do_pending()
{
	double val;
	char buffer[40];

	if (pending_op != NONE) {
	val = atof( ndisplay->text() );	// capture the current display
	switch (pending_op) {		// process the current operation
		case NONE:
			break;
		case ADD:
			val = pending_value + val;
			break;
		case SUBTRACT:
			val = pending_value - val;
			break;
		case MULTIPLY:
			val = pending_value * val;
			break;
		case DIVIDE:
			val = pending_value / val;
			break;
		}
		pending_op = NONE;		// no pending operations.
		sprintf( buffer, "%f", val );	// build the new display value.
		ndisplay->set_text( buffer );	// display this value.
	}
	push_value();
}

/*
****************************************************************************
*
*	Function Name: clear
*
*	Description:
*		The clear function is invoked any time the mouse button
*		is clicked when the pointer is over over the CLR button.
*		This routine clears the display.
*
*	Returns:
*		nothing
*
*	Side Effects:
*		none.
*
*	Warnings:
*		none.
*
****************************************************************************
*/
void
clear (
	OI_menu_cell	*,	// (unused) ptr to cell which fired
	void 		*,	// (unused) ptr to user supplied argument
	OI_number 	)	// (unused) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
/*
	Procedure:
*/
	ndisplay->set_text("0");	// display NULL
	push_value();			// clear the accumulator.
	return ;
}

/*
****************************************************************************
*
*	Function Name: decimal
*
*	Description:
*		The decimal function is invoked any time the mouse button
*		is clicked when the pointer is over the decimal key in the
*		calculator.  If the accumulator was just pushed, this
*		routine starts off with 0.; otherwise, we test to see if a
*		decimal point already exists.  If a decimal point exists,
*		this one is ignored; if there is no decimal point, it is
*		appended to the currently-displayed number.
*
*	Returns:
*		nothing
*
*	Side Effects:
*		none.
*
*	Warnings:
*		none.
*
****************************************************************************
*/
void
decimal (
	OI_menu_cell 	*,	// (unused) ptr to cell which fired
	void 		*,	// (unused) ptr to user supplied argument
	OI_number 	)	// (unused) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
		char buffer[40];	// temporary buffer
/*
	Procedure:
*/
	if (start_new_val) {		// if starting new value
		ndisplay->set_text( "0." );	// set the display to 0.0
		start_new_val = OI_NO;
	}
	else {
		//
		//	else, copy current value.  If a decimal is
		//	needed, append the decimal, then redisplay
		//	the value
		//
		strcpy( buffer, ndisplay->text() );
		if (strchr( buffer, '.') == NULL) {
			strcat( buffer, "." );
			ndisplay->set_text( buffer );
		}
	}
	return ;
}

/*
****************************************************************************
*
*	Function Name: numeric
*
*	Description:
*		The numeric function is invoked any time the mouse button is
*		clicked when the pointer is over one of the numbered keys in
*		the calculator.  The numeric value is passed in as an integer
*		argument argp.  We then determine whether we need to start a
*		new number, or continue to build the current number by
*		appending the value just entered.  The display is then
*		updated, and we return.
*
*	Returns:
*		nothing
*
*	Side Effects:
*		none.
*
*	Warnings:
*		none.
*
****************************************************************************
*/
void
numeric (
	OI_menu_cell 	*,	// (unused) ptr to cell which fired
	void 		*argp,	// (input) cells numeric value.
	OI_number	)	// (unused) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
		int	len;	//number of characters already displayed
		char	n;	//digit corresponding to button converted to character
		char	buffer[40];	//new text to display after appending new digit
/*
	Procedure:
*/
	n = '0' + (int) argp ;		// capture the numeric as a character
	if (start_new_val) {		// if we are starting a new number,
		buffer[0] = n ;		// set the buffer to this...
		buffer[1] = '\0';	// ... then terminate the buffer.
		start_new_val = OI_NO;
	}
	else {
		strcpy( buffer, ndisplay->text() );	// capture the current display
		if (strcmp( buffer, "0" ) == 0) {	// if display is currently "0"...
			buffer[0] = n;			// set the buffer to this...
			buffer[1] = '\0';		// ... then terminate the buffer.
		}
		else {				// otherwise append the value:
			len = strlen(buffer);	// how long is the displayed value?
			buffer[len++] = n;	// append this number to the buffer...
			buffer[len++] = '\0';	// ... then terminate the buffer.
		}
	}
	ndisplay->set_text( buffer );			// display this value.
	return ;
}
/*
****************************************************************************
*
*	Function Name: pending
*
*	Description:
*		The pending function is invoked any time the mouse button is
*		clicked when the pointer is over one of the operator cells
*		(mul, plus, minus, equal, div).  This routine performs any
*		currently-pending operation, captures the currently-
*		displayed value, then captures the next, pending, operation.
*
*	Returns:
*		nothing
*
*	Side Effects:
*		none.
*
*	Warnings:
*		none.
*
****************************************************************************
*/
void
pending (
	OI_menu_cell 	*,	// (unused) ptr to cell which fired
	void 		*argp,	// (input) op_t enum  {NONE,ADD,SUBTRACT,MULTIPLY,DIVIDE}
	OI_number 	)	// (unused) mouse button used to fire cell
{
/*	External Variables */
/*	External Procedures: */
/*	Local Variables: */
/*
	Procedure:
*/
	do_pending() ;			// perform any pending operation.
	pending_op = (op_t) argp ;	// capture the next operation.
	return ;
}
