/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1991, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	fd_set.H
 *
 *	Functions(s):
 *		FD_ASSIGN	assign bits of src to dst
 *		FD_SET_ASSIGN	set bits of src into dst
 *		FD_CLR_ASSIGN	clear bits of src from dst
 *		FD_ANYSET	are any bits of one fd_set set in the other?
 *		FD_ANYSET	are any bits in the fd_set set?
 *
 *	Description:
 *		logical extensions of the FD_SET, FD_CLR and FD_ISSET macros
 *
 *	RCSid = "$Id: fd_set.H,v 4.6.1.1 1993/06/01 22:54:24 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_fd_set_H
#define OI_fd_set_H

#ifndef	OI_config_H
#include <OI/config.H>
#endif

#include OI_FD_SET_H_FILE	/* ~OIc */

/* The following parameters are only for select().  FD_* still
   takes fd_set.  These can't be in config.H, since it isn't
   supposed to include anything and we need to have OI_FD_SET_H_FILE
   included before we define them. */

#ifdef	sgi
extern "C" {
	int select (int nfds, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout);
	void bzero(void *, int);
};
#endif

typedef OI_SELECT_FD_TYPE fd_set_t;

/* Some systems don't define howmany, so we do that here */
#ifndef	howmany
#define howmany(x, y)   (((x)+((y)-1))/(y))
#endif

extern void	FD_SET_ASSIGN(fd_set *dst, fd_set *src);
extern void	FD_CLR_ASSIGN(fd_set *dst, fd_set *src);
extern void	FD_ASSIGN(fd_set *dst, fd_set *src);
extern int	FD_ANYSET(fd_set *p, fd_set *q);
extern int	FD_ANYSET(fd_set *p);

#endif /* OI_fd_set_H */
