.nr N -1
.nr D 5
.TH LYNX l Local
.UC 4
.SH NAME
lynx \- a general purpose distributed information browser for the World Wide Web
.SH SYNOPSIS
.B Lynx
[options] [path or URL]
.PP
use "lynx -help" to display a complete list of current options.
.SH DESCRIPTION
.\" This defines appropriate quote strings for nroff and troff
.ds lq \&"
.ds rq \&"
.if t .ds lq ``
.if t .ds rq ''
.\" Just in case these number registers aren't set yet...
.if \nN==0 .nr N 10
.if \nD==0 .nr D 5
.I Lynx
is a general-purpose distributed information browser 
and is part of the World Wide Web project.
.I Lynx
was designed to support
a Campus Wide Information System (CWIS), but can be used for many
other applications. 
.PP
When it is started,
.I Lynx
is given a local path specifying a file containing text to be
displayed, or a Uniform Resource Locator (URL) that specifies
a resource to be displayed (usually the name of a file containing text 
information), 
the type of server that will provide the resource, and the Internet
address of the system on which the specified server is running.
If the URL or path specifies a hypertext file, that file will be
a standard ASCII text file in which
hypertext links are embedded.  The simplest hypertext link is just a
URL designating another resource which itself may contain both text and 
links.  
.PP
When a hypertext document is being displayed,
links appear different from standard text, and users press the up- or
down-arrows to "select" a particular link.
Selected links show up as highlighted text, and users press Return or right
arrow when a link is highlighted to "follow" the selected link.  
When the link
is followed 
.I Lynx 
finds the associated file and displays it on the screen
in place of the first file.
.PP
.I Lynx 
data files can reside on any accessable local file system. (i.e. NFS, 
AFS, etc.),
or on remote servers.  Currently supported remote servers are
HTTP, Gopher, FTP, NNTP, and WAIS.  
A single hypertext file may include links pointing to multiple remote
servers, so that 
.I Lynx 
provides a truly distributed hypertext system.
.PP
.I Lynx 
currently understands two hypertext data formats, the 
.I Lynx 
internal hypertext language and HyperText Markup Language (HTML).
The perferred language is HTML and support for the 
.I Lynx 
internal language will
be terminated in a subsequent release.  Documentation regarding the 
.I Lynx
intenal hypertext language and HTML are available online.
.PP
.I Lynx 
is available for most flavors of Unix and VMS
.PP
This Un*x version of Lynx should work on any system with a reasonable 
Curses implementation

.SH COMMANDS

Use the cursor control keys to move around in
.I Lynx.
The up and down arrows move you from one selected link to another.
Use the right arrow (or Return) to follow a link, and use the
left arrow to return from a link.  The numeric keypad, 
or the numbers mapped to the keypad keys, can also be used
(i.e., 6-right 8-up 9-pgup 3-pgdn)
.PP
Other commands include:
.TP
.B m
Return to the main menu (the first screen you see when you start Lynx)
.TP
.B + or Space or PgDn
Scroll down to the next page
.TP
.B - or b or PgUp
Scroll up to the previous page
.TP
.B ?
Help
.TP
.B q Ctrl-D
Quit Lynx
.TP
.B Backspace or Delete
Display a list of links that have already been visited.
The displayed links may be selected and will result in a new display
of the previously displayed information.
.TP
.B / <string> or s <string>
Search a selected file for all occurences of the string "string",
and display the portion of the file containing that string.
.TP
.B n
Find and display the next occurence of a search string.
.TP
.B c
Send a message to the designated file owner or to the Lynx database
administrator 
.TP
.B a
Adds the current link to your bookmark page.
.TP
.B g
Allows you to go to a user-specified URL or file.
.TP
.B i
Displays an index of documents or servers.
.TP
.B p
Allows you to print to a local file, mail to an Internet address, 
print to the screen, or use any commands or printers defined
by your system administrator.
.TP
.B '='
Displays an information screen, showing information about the
document currently being displayed and the link that is 
currently selected.
.TP
.B '!'
Spawns your default shell.
.TP
.B Backslash
Displays the HTML source of the document currently on the screen.
Pressing '\\' again re-renders the document.



.SH NOTES
This is a Beta release of Lynx 2.0 for UN*X/VMS
.PP
Thanks to Earl Fogel, Computing Services, University of Saskatchewan,
fogel@sask.usask.ca, who wrote the original hytelnet code,
and Foteos Macrides <macrides@sci.wfeb.edu> who worked on many
parts of the VMS code.

.SH AUTHOR
Lou Montulli, Computing Services, University of Kansas
montulli@ukanaix.cc.ukans.edu
