#include <ansidecl.h>
#include <stddef.h>
#if 0
#include <errno.h>
#endif

/* This is a list of all known error numbers.  */

CONST char *CONST _sys_errlist[] = {
/* EOK         */  "Unknown error condition",
/* EPERM       */  "Operation not permitted",
/* ENOENT      */  "No such file or directory",
/* ESRCH       */  "No such process",
/* EINTR       */  "Interrupted system call",
/* EIO	       */  "I/O error",
/* ENXIO       */  "No such device or address",
/* E2BIG       */  "Arg list too long",
/* ENOEXEC     */  "Exec format error",
/* EBADF       */  "Bad file number",
/* ECHILD      */  "No child processes",
/* EAGAIN      */  "Try again",
/* ENOMEM      */  "Out of memory",
/* EACCES      */  "Permission denied",
/* EFAULT      */  "Bad address",
/* ENOTBLK     */  "Block device required",
/* EBUSY       */  "Device or resource busy",
/* EEXIST      */  "File exists",
/* EXDEV       */  "Cross-device link",
/* ENODEV      */  "No such device",
/* ENOTDIR     */  "Not a directory",
/* EISDIR      */  "Is a directory",
/* EINVAL      */  "Invalid argument",
/* ENFILE      */  "File table overflow",
/* EMFILE      */  "Too many open files",
/* ENOTTY      */  "Not a typewriter",
/* ETXTBSY     */  "Text file busy",
/* EFBIG       */  "File too large",
/* ENOSPC      */  "No space left on device",
/* ESPIPE      */  "Illegal seek",
/* EROFS       */  "Read-only file system",
/* EMLINK      */  "Too many links",
/* EPIPE       */  "Broken pipe",
/* EDOM	       */  "Math argument out of domain of func",
/* ERANGE      */  "Math result not representable",
/* ENOMSG      */  "No message of desired type",
/* EIDRM       */  "Identifier removed",
/* ECHRNG      */  "Channel number out of range",
/* EL2NSYNC    */  "Level 2 not synchronized",
/* EL3HLT      */  "Level 3 halted",
/* EL3RST      */  "Level 3 reset",
/* ELNRNG      */  "Link number out of range",
/* EUNATCH     */  "Protocol driver not attached",
/* ENOCSI      */  "No CSI structure available",
/* EL2HLT      */  "Level 2 halted",
/* EDEADLK     */  "Resource deadlock would occur",
/* ENOLCK      */  "No record locks available",
                   "error 47",
                   "error 48",
                   "error 49",
                   "error 50",
                   "error 51",
                   "error 52",
                   "error 53",
                   "error 54",
                   "error 55",
                   "error 56",
                   "error 57",
                   "erorr 58",
                   "error 59",
/* ENOSTR      */  "Device not a stream",
/* ENODATA     */  "No data available",
/* ETIME       */  "Timer expired",
/* ENOSR       */  "Out of streams resources",
/* ENONET      */  "Machine is not on the network",
/* ENOPKG      */  "Package not installed",
/* EREMOTE     */  "Object is remote",
/* ENOLINK     */  "Link has been severed",
/* EADV	       */  "Advertise error",
/* ESRMNT      */  "Srmount error",
/* ECOMM       */  "Communication error on send",
/* EPROTO      */  "Protocol error",
                   "error 72",
                   "error 73",
/* EMULTIHOP   */  "Multihop attempted",
                   "error 75",
/* EDOTDOT     */  "RFS specific error",
/* EBADMSG     */  "Not a data message",
/* ENAMETOOLONG*/  "File name too long",
/* EOVERFLOW   */  "Value too large for defined data type",
/* ENOTUNIQ    */  "Name not unique on network",
/* EBADFD      */  "File descriptor in bad state",
/* EREMCHG     */  "Remote address changed",
                   "error 83",
                   "error 84",
                   "error 85",
                   "error 86",
                   "error 87",
                   "error 88",
/* ENOSYS      */  "Function not implemented",
/* EWOULDBLOCK */  "Operation would block",
/* ERESTART    */  "Interrupted system call should be restarted",
/* ESTRPIPE    */  "Streams pipe error",
/* ENOTEMPTY   */  "Directory not empty",
/* EUSERS      */  "Too many users",
/* ESTALE      */  /* Stale NFS file handle */
/* End of list */  NULL
};

#define NR_ERRORS ((sizeof (_sys_errlist))/(sizeof(char *))-1)

CONST int _sys_nerr = NR_ERRORS;

