struct library_symbol{
  struct library_symbol * next;
  char * name;
  char * value;
  char strength;
  unsigned got:1;
  unsigned plt:1;
  unsigned ignore:1;
};

struct elf_resolve{
  struct elf_resolve * next;
  char * libname;
  enum {elf_lib, elf_executable,program_interpreter} libtype;
  unsigned int nbucket;
  unsigned int * elf_buckets;
  /*
   * These are only used with ELF style shared libraries
   */
  unsigned int nchain;
  unsigned int * chains;
  char * loadaddr;
  unsigned int dynamic_info[24];

  unsigned int dynamic_addr;
  unsigned int dynamic_size;
  unsigned int n_phent;
  struct elf_phdr * ppnt;
};

extern struct elf_resolve * _dl_symbol_tables;
extern int _dl_check_hashed_files(char * libname);
extern struct elf_resolve * _dl_add_elf_hash_table(char * libname, 
					       char * loadaddr, 
					       unsigned int * dynamic_info, 
					       unsigned int dynamic_addr, 
					       unsigned int dynamic_size);
extern char * _dl_find_hash(char * name, struct elf_resolve * tpnt1, 
			unsigned int instr_addr);

extern int _dl_linux_dynamic_link();

#define SEND_STDERR(X) _dl_write(2, X, strlen(X));
extern int _dl_write(int, const char *, int);
extern char * _dl_library_path;
extern char * _dl_not_lazy;
extern char * _dl_strdup(const char *);

extern inline int _dl_symbol(char * name)
{
  if(name[0] != '_' || name[1] != 'd' || name[2] != 'l' || name[3] != '_')
    return 0;
  return 1;
}
