/*
 * definitions for the virtual machine
 *
 * Copywrite 1993, Hamish Coleman
 */

#define us unsigned short
#define _regs	vm86s.regs

extern struct vm86_struct vm86s;

/* virtual machine functions */
void emulate_int(int i);
void emulate_iret();
void vm_prep();
int vm();

#define I_int		0xcd
#define I_int3		0xcc
#define I_iret		0xcf
#define I_inw		0xe5
#define I_inb		0xe4
#define I_inw_dx	0xed
#define I_inb_dx	0xec
#define I_outw		0xe7
#define I_outb		0xe6
#define I_outw_dx	0xef
#define I_outb_dx	0xee
#define I_cli		0xfa
#define I_sti		0xfb
#define I_pushf		0x9c
#define I_popf		0x9d
#define I_hlt		0xf4
#define I_lock		0xf0
#define I_bound		0x62
#define	I_insb		0x6c
#define I_insw		0x6d
#define I_outsb		0x6e
#define I_outsw		0x6f
#define I_retfar	0xcb


#define F_sigsegv	0x100
#define F_sigill	0x200
#define F_mathem	0x300
#define F_sigfpe	0x400
#define F_sigalrm	0x500
