
FOREIGN MODULE msEnum;

(*
 *  Enumeration Library for Modula-2*
 *
 *  allows for efficient enumeration operations
 *  on arbitrarily large and distributed arrays
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 12.10.1992
 *)

(*
 *  naming conventions:
 *  -------------------
 *
 *    <as>MaskEnum<ts>( mask: ARRAY ... OF BOOLEAN;
 *                      VAR x: ARRAY ... OF <type> );
 *
 *    <as>SegEnum<ts>( segs: ARRAY ... OF BOOLEAN;
 *                     VAR x: ARRAY ... OF <type> );
 *
 *    <as>UnivEnum<ts>( mask, segs: ARRAY ... OF BOOLEAN;
 *                      VAR x: ARRAY ... OF <type> );
 *
 *    <as> = "allocator shortcut",  <ts> = "type shortcut"
 *
 *  examples:
 *  ---------
 *
 *    SMaskEnumI( mask: ARRAY SPREAD OF BOOLEAN;
 *                VAR x: ARRAY SPREAD OF LONGINT );
 *
 *    SSegEnumI( segs: ARRAY SPREAD OF BOOLEAN;
 *               VAR x: ARRAY SPREAD OF LONGINT );
 *
 *    SUnivEnumI( mask, segs: ARRAY SPREAD OF BOOLEAN;
 *                VAR x: ARRAY SPREAD OF LONGINT );
 *
 *    <as> = S,  <ts> = I,  <type> = LONGINT
 *)

(*
 *  masked enumeration routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(mask) = HIGH(x)
 *)

PROCEDURE SMaskEnumCh( mask: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF CHAR );
PROCEDURE SMaskEnumSC( mask: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SMaskEnumC ( mask: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF LONGCARD );
PROCEDURE SMaskEnumSI( mask: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF SHORTINT );
PROCEDURE SMaskEnumI ( mask: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF LONGINT );
PROCEDURE SMaskEnumR ( mask: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF REAL );
PROCEDURE SMaskEnumLR( mask: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF LONGREAL );

(*
 *  segmented enumeration routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(segs) = HIGH(x)
 *)

PROCEDURE SSegEnumCh( segs: ARRAY SPREAD OF BOOLEAN;
		      VAR x: ARRAY SPREAD OF CHAR );
PROCEDURE SSegEnumSC( segs: ARRAY SPREAD OF BOOLEAN;
		      VAR x: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SSegEnumC ( segs: ARRAY SPREAD OF BOOLEAN;
		      VAR x: ARRAY SPREAD OF LONGCARD );
PROCEDURE SSegEnumSI( segs: ARRAY SPREAD OF BOOLEAN;
		      VAR x: ARRAY SPREAD OF SHORTINT );
PROCEDURE SSegEnumI ( segs: ARRAY SPREAD OF BOOLEAN;
		      VAR x: ARRAY SPREAD OF LONGINT );
PROCEDURE SSegEnumR ( segs: ARRAY SPREAD OF BOOLEAN;
		      VAR x: ARRAY SPREAD OF REAL );
PROCEDURE SSegEnumLR( segs: ARRAY SPREAD OF BOOLEAN;
		      VAR x: ARRAY SPREAD OF LONGREAL );

(*
 *  universal enumeration routines for 1-dimensional SPREAD arrays
 *
 *  necessary condition:  HIGH(mask) = HIGH(segs) = HIGH(x)
 *)

PROCEDURE SUnivEnumCh( mask, segs: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF CHAR );
PROCEDURE SUnivEnumSC( mask, segs: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF SHORTCARD );
PROCEDURE SUnivEnumC ( mask, segs: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF LONGCARD );
PROCEDURE SUnivEnumSI( mask, segs: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF SHORTINT );
PROCEDURE SUnivEnumI ( mask, segs: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF LONGINT );
PROCEDURE SUnivEnumR ( mask, segs: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF REAL );
PROCEDURE SUnivEnumLR( mask, segs: ARRAY SPREAD OF BOOLEAN;
		       VAR x: ARRAY SPREAD OF LONGREAL );

END msEnum.
