------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 S Y S T E M . R E A L _ T I M E . C O N V                --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.4 $                             --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2,  or  (at  your  option) any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

package body System.Real_Time.Conv is

   -----------------------
   -- Time_To_Stimespec --
   -----------------------

   function Time_To_Stimespec
     (T    : Real_Time.time)
      return Task_Clock.Stimespec
   is
   begin
      return Task_Clock.Stimespec (T);
   end  Time_To_Stimespec;

   -----------------------
   -- Stimespec_To_Time --
   -----------------------

   function Stimespec_To_Time
     (T    : Task_Clock.Stimespec)
      return Real_Time.Time
   is
   begin
      return Real_Time.Time (T);
   end Stimespec_To_Time;

   ----------------------------
   -- Time_Span_To_Stimespec --
   ----------------------------

   function Time_Span_To_Stimespec
     (T    : Real_Time.Time_Span)
      return Task_Clock.Stimespec
   is
   begin
      return Task_Clock.Stimespec (T);
   end  Time_Span_To_Stimespec;

   ----------------------------
   -- Stimespec_To_Time_Span --
   ----------------------------

   function Stimespec_To_Time_Span
     (T    : Task_Clock.Stimespec)
      return Real_Time.Time_Span
   is
   begin
      return Real_Time.Time_Span (T);
   end Stimespec_To_Time_Span;

end System.Real_Time.Conv;
