------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                        S Y S T E M . I M G _ S F                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.6 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

function System.Img_SF (V : Short_Float; B : Address) return Natural is

   procedure sprintf (Target, Fmt : Address;
                      Prec        : Natural;
                      Val         : Long_Float;
                      Length_Ptr  : Address);
   pragma Import (C, sprintf);

   Fmt    : constant String := "% .*e%n" & Ascii.NUL;
   Length : aliased Natural;

begin
   sprintf
     (B, Fmt'Address, Short_Float'digits, Long_Float (V), Length'Address);
   return Length;
end System.Img_SF;
