/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                              A _ A T R E E                               */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.28 $                             */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This is the C header corresponding to the Ada package specification for
   Atree. It also contains the implementations of inlined functions from the
   package body for Tree.  It was generated manually from atree.ads and
   atree.adb and must be kept synchronized with changes in these files.

   Note that only routines for reading the tree are included, since the tree
   transformer is not supposed to modify the tree in any way. */

struct Non_Extended
{
  Source_Ptr   sloc;
  Int	       link;
  Int	       field1;
  Int	       field2;
  Int	       field3;
  Int	       field4;
  Int	       field5;
};

/* The Following structure corresponds to variant with is_extension = True.  */
struct Extended
{
  Int	       field6;
  Int	       field7;
  Int	       field8;
  Int	       field9;
  Int	       field10;
  Int	       field11;
  Int	       field12;
};

struct Node
{
  Boolean      is_extension :  1;
  Boolean      pflag1       :  1;
  Boolean      pflag2       :  1;
  Boolean      in_list	    :  1;
  Boolean      rewrite_sub  :  1;
  Boolean      rewrite_ins  :  1;
  Boolean      flag1	       :  1;
  Boolean      flag2	       :  1;

  Boolean      flag3	       :  1;
  Boolean      flag4	       :  1;
  Boolean      flag5	       :  1;
  Boolean      flag6	       :  1;
  Boolean      flag7	       :  1;
  Boolean      flag8	       :  1;
  Boolean      flag9	       :  1;
  Boolean      flag10	    :  1;

  Boolean      flag11	    :  1;
  Boolean      flag12	    :  1;
  Boolean      flag13	    :  1;
  Boolean      flag14	    :  1;
  Boolean      flag15	    :  1;
  Boolean      flag16	    :  1;
  Boolean      flag17	    :  1;
  Boolean      flag18	    :  1;

  unsigned char kind	    :  8;

  union variant
    {
      struct Non_Extended NX;
      struct Extended EX;
    } V;
};

/* The actual tree is an array of nodes. The pointer to this array is passed
   as a parameter to the tree transformer procedure and stored in the global
   variable Nodes_Ptr after adjusting it by subtracting Node_First_Entry, so
   that Node_Id values can be used as subscripts.  */
extern struct Node *Nodes_Ptr;

#define Parent atree__parent
extern Node_Id Parent PROTO((Node_Id));

/* Overloaded Functions:

   These functions are overloaded in the original Ada source, but there is
   only one corresponding C function, which works as described below.	*/

/* Type used for union of Node_Id, List_Id, Elist_Id. */
typedef Int Tree_Id;

/* These two functions can only be used for Node_Id and List_Id values and
   they work in the C version because Empty = No_List = 0.  */

INLINE Boolean
No (N)
     Tree_Id N;
{
  return N == Empty;
}

INLINE Boolean
Present (N)
     Tree_Id N;
{
  return N != Empty;
}

/* Test the range of N to distinguish between the cases of Node_Id, List_Id
   and Elist_Id arguments.  */
extern Node_Id Parent		PROTO((Tree_Id));

/* Node Access Functions:  */

#define Nkind(N) ((Node_Kind)(Nodes_Ptr [N].kind))
#define Ekind(N) ((Entity_Kind)(Nodes_Ptr [N + 1].kind))
#define Sloc(N) (Nodes_Ptr [N].V.NX.sloc)
#define Paren_Count (N) (Nodes_Ptr [N].Pflag1 + 2 * Nodes_Ptr [N].Pflag2)

#define Field1(N) (Nodes_Ptr [N].V.NX.field1)
#define Field2(N) (Nodes_Ptr [N].V.NX.field2)
#define Field3(N) (Nodes_Ptr [N].V.NX.field3)
#define Field4(N) (Nodes_Ptr [N].V.NX.field4)
#define Field5(N) (Nodes_Ptr [N].V.NX.Field5)
#define Field6(N) (Nodes_Ptr [N+1].V.EX.field6)
#define Field7(N) (Nodes_Ptr [N+1].V.EX.field7)
#define Field8(N) (Nodes_Ptr [N+1].V.EX.field8)
#define Field9(N) (Nodes_Ptr [N+1].V.EX.field9)
#define Field10(N) (Nodes_Ptr [N+1].V.EX.field10)
#define Field11(N) (Nodes_Ptr [N+1].V.EX.field11)
#define Field12(N) (Nodes_Ptr [N+1].V.EX.field12)
#define Field13(N) (Nodes_Ptr [N+2].V.EX.field6)
#define Field14(N) (Nodes_Ptr [N+2].V.EX.field7)
#define Field15(N) (Nodes_Ptr [N+2].V.EX.field8)
#define Field16(N) (Nodes_Ptr [N+2].V.EX.field9)
#define Field17(N) (Nodes_Ptr [N+2].V.EX.field10)

#define Node1(N) (Nodes_Ptr [N].V.NX.field1)
#define Node2(N) (Nodes_Ptr [N].V.NX.field2)
#define Node3(N) (Nodes_Ptr [N].V.NX.field3)
#define Node4(N) (Nodes_Ptr [N].V.NX.field4)
#define Node5(N) (Nodes_Ptr [N].V.NX.field5)
#define Node6(N) (Nodes_Ptr [N+1].V.EX.field6)
#define Node7(N) (Nodes_Ptr [N+1].V.EX.field7)
#define Node8(N) (Nodes_Ptr [N+1].V.EX.field8)
#define Node9(N) (Nodes_Ptr [N+1].V.EX.field9)
#define Node10(N) (Nodes_Ptr [N+1].V.EX.field10)
#define Node11(N) (Nodes_Ptr [N+1].V.EX.field11)
#define Node12(N) (Nodes_Ptr [N+1].V.EX.field12)
#define Node13(N) (Nodes_Ptr [N+2].V.EX.field6)
#define Node14(N) (Nodes_Ptr [N+2].V.EX.field7)
#define Node15(N) (Nodes_Ptr [N+2].V.EX.field8)
#define Node16(N) (Nodes_Ptr [N+2].V.EX.field9)
#define Node17(N) (Nodes_Ptr [N+2].V.EX.field10)

#define List1(N) (Nodes_Ptr [N].V.NX.field1)
#define List2(N) (Nodes_Ptr [N].V.NX.field2)
#define List3(N) (Nodes_Ptr [N].V.NX.field3)
#define List4(N) (Nodes_Ptr [N].V.NX.field4)
#define List5(N) (Nodes_Ptr [N].V.NX.field5)

#define Elist1(N) (Nodes_Ptr [N].V.NX.field1)
#define Elist2(N) (Nodes_Ptr [N].V.NX.field2)
#define Elist3(N) (Nodes_Ptr [N].V.NX.field3)
#define Elist4(N) (Nodes_Ptr [N].V.NX.field4)
#define Elist5(N) (Nodes_Ptr [N].V.NX.field5)
#define Elist6(N) (Nodes_Ptr [N+1].V.EX.field6)
#define Elist7(N) (Nodes_Ptr [N+1].V.EX.field7)
#define Elist8(N) (Nodes_Ptr [N+1].V.EX.field8)
#define Elist9(N) (Nodes_Ptr [N+1].V.EX.field9)
#define Elist10(N) (Nodes_Ptr [N+1].V.EX.field10)
#define Elist11(N) (Nodes_Ptr [N+1].V.EX.field11)
#define Elist12(N) (Nodes_Ptr [N+1].V.EX.field12)
#define Elist13(N) (Nodes_Ptr [N+2].V.EX.field6)
#define Elist14(N) (Nodes_Ptr [N+2].V.EX.field7)
#define Elist15(N) (Nodes_Ptr [N+2].V.EX.field8)
#define Elist16(N) (Nodes_Ptr [N+2].V.EX.field9)
#define Elist17(N) (Nodes_Ptr [N+2].V.EX.field10)

#define Name1(N) (Nodes_Ptr [N].V.NX.field1)
#define Name2(N) (Nodes_Ptr [N].V.NX.field2)
#define Name3(N) (Nodes_Ptr [N].V.NX.field3)
#define Name4(N) (Nodes_Ptr [N].V.NX.field4)
#define Name5(N) (Nodes_Ptr [N].V.NX.field5)

#define Char_Code1(N) (Nodes_Ptr [N].V.NX.field1 - Char_Code_Bias)
#define Char_Code2(N) (Nodes_Ptr [N].V.NX.field2 - Char_Code_Bias)
#define Char_Code3(N) (Nodes_Ptr [N].V.NX.field3 - Char_Code_Bias)
#define Char_Code4(N) (Nodes_Ptr [N].V.NX.field4 - Char_Code_Bias)
#define Char_Code5(N) (Nodes_Ptr [N].V.NX.field5 - Char_Code_Bias)

#define Str1(N) (Nodes_Ptr [N].V.NX.field1)
#define Str2(N) (Nodes_Ptr [N].V.NX.field2)
#define Str3(N) (Nodes_Ptr [N].V.NX.field3)
#define Str4(N) (Nodes_Ptr [N].V.NX.field4)
#define Str5(N) (Nodes_Ptr [N].V.NX.field5)

#define Uint1(N) (Nodes_Ptr [N].V.NX.field1)
#define Uint2(N) (Nodes_Ptr [N].V.NX.field2)
#define Uint3(N) (Nodes_Ptr [N].V.NX.field3)
#define Uint4(N) (Nodes_Ptr [N].V.NX.field4)
#define Uint5(N) (Nodes_Ptr [N].V.NX.field5)
#define Uint6(N) (Nodes_Ptr [N+1].V.EX.field6)
#define Uint7(N) (Nodes_Ptr [N+1].V.EX.field7)
#define Uint8(N) (Nodes_Ptr [N+1].V.EX.field8)
#define Uint9(N) (Nodes_Ptr [N+1].V.EX.field9)
#define Uint10(N) (Nodes_Ptr [N+1].V.EX.field10)
#define Uint11(N) (Nodes_Ptr [N+1].V.EX.field11)
#define Uint12(N) (Nodes_Ptr [N+1].V.EX.field12)
#define Uint13(N) (Nodes_Ptr [N+2].V.EX.field6)
#define Uint14(N) (Nodes_Ptr [N+2].V.EX.field7)
#define Uint15(N) (Nodes_Ptr [N+2].V.EX.field8)
#define Uint16(N) (Nodes_Ptr [N+2].V.EX.field9)
#define Uint17(N) (Nodes_Ptr [N+2].V.EX.field10)

#define Flag1(N) (Nodes_Ptr [N].flag1)
#define Flag2(N) (Nodes_Ptr [N].flag2)
#define Flag3(N) (Nodes_Ptr [N].flag3)
#define Flag4(N) (Nodes_Ptr [N].flag4)
#define Flag5(N) (Nodes_Ptr [N].flag5)
#define Flag6(N) (Nodes_Ptr [N].flag6)
#define Flag7(N) (Nodes_Ptr [N].flag7)
#define Flag8(N) (Nodes_Ptr [N].flag8)
#define Flag9(N) (Nodes_Ptr [N].flag9)
#define Flag10(N) (Nodes_Ptr [N].flag10)
#define Flag11(N) (Nodes_Ptr [N].flag11)
#define Flag12(N) (Nodes_Ptr [N].flag12)
#define Flag13(N) (Nodes_Ptr [N].flag13)
#define Flag14(N) (Nodes_Ptr [N].flag14)
#define Flag15(N) (Nodes_Ptr [N].flag15)
#define Flag16(N) (Nodes_Ptr [N].flag16)
#define Flag17(N) (Nodes_Ptr [N].flag17)
#define Flag18(N) (Nodes_Ptr [N].flag18)

#define Flag19(N) (Nodes_Ptr [N+1].in_list)
#define Flag20(N) (Nodes_Ptr [N+1].rewrite_sub)
#define Flag21(N) (Nodes_Ptr [N+1].rewrite_ins)
#define Flag22(N) (Nodes_Ptr [N+1].flag1)
#define Flag23(N) (Nodes_Ptr [N+1].flag2)
#define Flag24(N) (Nodes_Ptr [N+1].flag3)
#define Flag25(N) (Nodes_Ptr [N+1].flag4)
#define Flag26(N) (Nodes_Ptr [N+1].flag5)
#define Flag27(N) (Nodes_Ptr [N+1].flag6)
#define Flag28(N) (Nodes_Ptr [N+1].flag7)
#define Flag29(N) (Nodes_Ptr [N+1].flag8)
#define Flag30(N) (Nodes_Ptr [N+1].flag9)
#define Flag31(N) (Nodes_Ptr [N+1].flag10)
#define Flag32(N) (Nodes_Ptr [N+1].flag11)
#define Flag33(N) (Nodes_Ptr [N+1].flag12)
#define Flag34(N) (Nodes_Ptr [N+1].flag13)
#define Flag35(N) (Nodes_Ptr [N+1].flag14)
#define Flag36(N) (Nodes_Ptr [N+1].flag15)
#define Flag37(N) (Nodes_Ptr [N+1].flag16)
#define Flag38(N) (Nodes_Ptr [N+1].flag17)
#define Flag39(N) (Nodes_Ptr [N+1].flag18)

#define Flag40(N) (Nodes_Ptr [N+2].in_list)
#define Flag41(N) (Nodes_Ptr [N+2].rewrite_sub)
#define Flag42(N) (Nodes_Ptr [N+2].rewrite_ins)
#define Flag43(N) (Nodes_Ptr [N+2].flag1)
#define Flag44(N) (Nodes_Ptr [N+2].flag2)
#define Flag45(N) (Nodes_Ptr [N+2].flag3)
#define Flag46(N) (Nodes_Ptr [N+2].flag4)
#define Flag47(N) (Nodes_Ptr [N+2].flag5)
#define Flag48(N) (Nodes_Ptr [N+2].flag6)
#define Flag49(N) (Nodes_Ptr [N+2].flag7)
#define Flag50(N) (Nodes_Ptr [N+2].flag8)
#define Flag51(N) (Nodes_Ptr [N+2].flag9)
#define Flag52(N) (Nodes_Ptr [N+2].flag10)
#define Flag53(N) (Nodes_Ptr [N+2].flag11)
#define Flag54(N) (Nodes_Ptr [N+2].flag12)
#define Flag55(N) (Nodes_Ptr [N+2].flag13)
#define Flag56(N) (Nodes_Ptr [N+2].flag14)
#define Flag57(N) (Nodes_Ptr [N+2].flag15)
#define Flag58(N) (Nodes_Ptr [N+2].flag16)
#define Flag59(N) (Nodes_Ptr [N+2].flag17)
#define Flag60(N) (Nodes_Ptr [N+2].flag18)
#define Flag61(N) (Nodes_Ptr [N+1].pflag1)
#define Flag62(N) (Nodes_Ptr [N+1].pflag2)
#define Flag63(N) (Nodes_Ptr [N+2].pflag1)
#define Flag64(N) (Nodes_Ptr [N+2].pflag2)

/* End of a-atree.h (C version of Atree package specification) */
