/* vdu.h - 20:46 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin */

#ifndef VDU_H
#define VDU_H

/* Include file ../include/vdu.h from vis630vdu.c */


/* VDU implements the screen-driving routines used by DVItoVDU.
   InitVDU initializes the parameters for the VDU screen.
   After starting up, DVItoVDU breaks the screen into 2 parts:

   1. The DIALOGUE REGION will consist of the top 4 text lines on the screen.
      This region is used to display DVI and window status information,
      various kinds of messages and the command prompt.  DVItoVDU assumes
      text lines on the screen start at 1 and increase downwards.  The bottom
      text line on the screen is given by the parameter bottoml (also the total
      number of text lines).

   2. The WINDOW REGION is typically the remaining area of the screen and
      is used to display some sort of representation of the current DVI page.
      The user can move the window over any part of the current page,
      or even completely outside the page edges (but only just).
      The user can scale the page display by changing the width and height of
      the window region; windowwd and windowht are the initial, unscaled
      dimensions where one paper pixel equals one screen pixel.
      When addressing screen pixels, DVItoVDU assumes the top left pixel
      in the screen is at (0,0); horizontal coordinates increase to the right
      and vertical coordinates increase down the screen.  The top left pixel
      in the window region is at (windowh,windowv) in this coordinate scheme.

   The following diagram illustrates the screen coordinate system used by
   DVItoVDU and shows what the VDU parameters refer to.

                --> h increases to the right
   h,v=(0,0) *------------------------------------------------
             |                               DVIstatusl      | top text line = 1
       |     |              DIALOGUE REGION  windowstatusl   | (lines increase
       V     |                               messagel        |  downwards)
             |                               commandl        |
       v     * (windowh,windowv) ----------------------------|   ---
   increases |                                               |    |
     down    |                                               |    |
             |                                               |    |
             |                                               |    |
             |                WINDOW REGION                  | windowht
             |     contains windowwd * windowht pixels       |    |
             |                                               |    |
             |                                               |    |
             |                               bottoml         |    |
             -------------------------------------------------   ---

             |------------------ windowwd -------------------|

*/

extern int DVIstatusl;     /* DVI status line                                */
extern int windowstatusl;  /* window status line                             */
extern int messagel;       /* message line                                   */
extern int commandl;       /* command line                                   */
extern int bottoml;        /* bottom line; also num. of text lines in screen */

extern int windowh;   /* horizontal coord for window's top left screen pixel */
extern int windowv;   /* vertical coord for window's top left screen pixel   */
extern int windowwd;  /* width of window in screen pixels                    */
extern int windowht;  /* height of window in screen pixels                   */

extern boolean vdu_clears_lines;  /* Can current VDU clear a single line? */
extern boolean vdu_unixio;        /* Use normal Unix terminal I/O?        */

extern Void InitVDU (VOID);
extern Void LogClearScreen (VOID);

extern Void (*StartText) (VOID);
extern Void (*MoveToTextLine) __((int line));
extern Void (*ClearTextLine) __((int line));
extern Void (*ClearScreen) (VOID);
extern Void (*StartGraphics) (VOID);
extern Void (*LoadFont) __((Char *fontname, int fontsize, double mag, double hscale, double vscale));
extern Void (*ShowChar) __((int screenh, int screenv, Char ch));
extern Void (*ShowRectangle) __((int screenh, int screenv, int width, int height, Char ch));
extern Void (*ResetVDU) (VOID);
extern Void (*WriteTextChar) __((Char c));
extern Void (*ReadTextString) __((Char *s));

#endif /* VDU_H */

/* end vdu.h */
