/* ncsatelvdu.c - 18:31 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin */
/*********************************************************************
     vdu driver for NCSA Telnet with Tektronix Graphics
     created by vijay@ncst.ernet.in on 25th Dec 92.
     "No reason why it should not work on a real tek 4010 too."
*********************************************************************/

#include "config.h"
#include "globals.h"
#include "screenio.h"
#include "vdu.h"
#include "tek4010emu.h"

/******************************************************************************/

Void NCSATELClearScreen (VOID)
{
  /* NCSA Telnet (2.3.0.3) tek emulator gets stuck on an extra GS which
     TEK4010ClearScreen puts out.
     Set in alpha mode and invoke TEK4010ClearScreen.
  */

  WriteChar (ESC);
  WriteChar (FF);   /* erase graphics and put in alpha mode */

  TEK4010ClearScreen();
}
/* NCSATELClearScreen */

/******************************************************************************/

#ifdef __STDC__
Void NCSATELClearTextLine (int line)
#else
Void NCSATELClearTextLine (line)
  int line;
#endif
{
  /* Do nothing as NCSA Telnet (version 2.3.0.3) can only clear
     the entire screen in tek4010 and NOT just a line.
     Live with the overwriting.  In any case,
     the next DisplayPage will clear and rewrite the status lines.
  */
}
/* NCSATELClearTextLine */

/******************************************************************************/

/* NCSATELShowChar: use TEK4010ShowChar */

/******************************************************************************/

/* NCSATELShowRectangle: use TEK4010ShowRectangle */

/******************************************************************************/

Void NCSATELResetVDU (VOID)
{
  WriteChar (CAN);
  WriteChar (CAN);
}
/* NCSATELResetVDU */

/******************************************************************************/

Void InitNCSATEL (VOID)
{
  /* The dialog region will be the top 4 text lines in Tek mode:
        Line 1 = DVI status line,
        Line 2 = window status line,
        Line 3 = message line,
        Line 4 = command line.
     The window region will be text lines 5 to 33 in TEK mode.
     gt - in NCSA Telnet in TEK mode on my monitor (Viewsonic 5E VGA),
          only 30 lines fit.  If we use line 33, it wraps around!
  */

  InitTEK4010emu();  /* We overwrite the values we don't want */

  /* The following line numbers assume NCSA Telnet is in VT100 mode. */

  DVIstatusl = 1;    /* DVItoVDU assumes top text line = 1 */
  windowstatusl = 2;
  messagel = 3;
  commandl = 4;
#ifdef VIJAY_BOTTOML
  bottoml = 33;   /* also number of text lines on screen */
#else /* according to gt's experience */
  bottoml = 30;   /* also number of text lines on screen */
#endif

  /* The following values assume NCSA Telnet is emulating
     a Tektronix 4010.
     Note that windowv must be given a value using DVItoVDU's
     coordinate scheme, where top left pixel is (0,0).
  */

  /* 
     Approx. height, in TEK4010 pixels, of 4 text lines, viz. 92
     (i.e. ~ 4 * 780/34), does not work in the case of NCSA Telnet's
     Tek mode.  Value 115 arrived at by pure trial and error.
  */
  windowv = 115;
  windowh = 0;
  windowht = 780 - windowv;
  windowwd = 1024;

  textlinewidth = 72;  /* text characters per line - a guess */

  MoveToTextLine = TEK4010MoveToTextLine;
  ClearTextLine  = NCSATELClearTextLine;
  ClearScreen    = NCSATELClearScreen;
  StartText      = TEK4010StartText;
  StartGraphics  = TEK4010StartGraphics;
  LoadFont       = TEK4010LoadFont;
  ShowChar       = TEK4010ShowChar;
  ShowRectangle  = TEK4010ShowRectangle;
  ResetVDU       = NCSATELResetVDU;

  WriteChar (GS);
}
/*InitNCSATEL */

/******************************************************************************/

/* end ncsatelvdu.c */
