/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	dpy_1d.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_display_1d class header
 *
 *	RCSid = "$Id: dpy_1d.H,v 4.15.1.3 1993/07/12 22:34:51 imp Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_dpy_1d_H
#define OI_dpy_1d_H

#ifndef OI_wdtech_H
#include <OI/wdtech.H>
#endif /* OI_wdtech_H */

	class	OI_marker;

	enum OI_display_1d_ends {
		OI_display_1d_ends_none		= 0,
		OI_DISPLAY_1D_ENDS_NONE		= OI_display_1d_ends_none,
		OI_display_1d_ends_numeric	= 1,
		OI_DISPLAY_1D_ENDS_NUMERIC	= OI_display_1d_ends_numeric,
		OI_display_1d_ends_strings	= 2,
		OI_DISPLAY_1D_ENDS_STRINGS	= OI_display_1d_ends_strings
	} ;
	enum OI_display_1d_current {
		OI_display_1d_current_none	= 0,
		OI_DISPLAY_1D_CURRENT_NONE	= OI_display_1d_current_none,
		OI_display_1d_current_ro	= 1,
		OI_DISPLAY_1D_CURRENT_RO	= OI_display_1d_current_ro,
		OI_display_1d_current_rw	= 2,
		OI_DISPLAY_1D_CURRENT_RW	= OI_display_1d_current_rw
	};
	enum OI_display_1d_ticks {
		OI_display_1d_ticks_none	= 0,
		OI_DISPLAY_1D_TICKS_NONE	= OI_display_1d_ticks_none,
		OI_display_1d_ticks_ends	= 1,
		OI_DISPLAY_1D_TICKS_ENDS	= OI_display_1d_ticks_ends,
		OI_display_1d_ticks_all		= 2,
		OI_DISPLAY_1D_TICKS_ALL		= OI_display_1d_ticks_all,
		OI_display_1d_ticks_ends_custom	= 3,
		OI_DISPLAY_1D_TICKS_ENDS_CUSTOM	= OI_display_1d_ticks_ends_custom,
		OI_display_1d_ticks_all_custom	= 4,
		OI_DISPLAY_1D_TICKS_ALL_CUSTOM	= OI_display_1d_ticks_all_custom
	};

#define	OI_DISPLAY_1D_LBL_PAINTED		0x2	/* 1 => Label is painted. */
#define	OI_DISPLAY_1D_CUR_PAINTED		0x4	/* 1 => Current value painted. */
#define	OI_DISPLAY_1D_TCK_PAINTED		0x8	/* 1 => Ticks are painted. */
#define	OI_DISPLAY_1D_MIN_PAINTED		0x10	/* 1 => minimum label painted. */
#define	OI_DISPLAY_1D_MAX_PAINTED		0x20	/* 1 => maximum label painted. */
#define	OI_DISPLAY_1D_NEEDS_REPAINT		0x80	/* 1 => repaint is required */
#define	OI_DISPLAY_1D_IN_MY_CONSTRUCTOR		0x100	/* 1 => in middle of construction process */
#define OI_DISPLAY_1D_FONT_CHANGED		0x200	/* 1 => Font has changed on us */

#define	OI_DISPLAY_1D_MIN_LABEL_SPACE		2	/* Space between bar and minimum label */
#define	OI_DISPLAY_1D_MAX_LABEL_SPACE		2	/* Space between bar and max label */
#define	OI_DISPLAY_1D_CUR_VALUE_SPACE		2	/* Space between bar and cur label */

#define	OI_DISPLAY_1D_MAX_DICIMAL_VALUE		9	/* Max value of signed long is ~2x10**9, Use this to avoid overflow while computing values. */

	class OI_display_1d : public OI_w_d_tech {
			unsigned long		ctl_bits ;		/* class private control bits */
	 protected:
			OI_font_bounds		*lbl_fntbnds;		/* font bounds for the label */
			OI_font			*lbl_fntp ;		/* ptr to font info in font cache */
			OI_string		*lbl;			/* main label */
			OI_number		lbl_x;			/* where to paint the label */
			OI_number		lbl_y;			/* where to paint the label */
			OI_number		lbl_wid ;		/* width of label in pixels */
			OI_number		lbl_right_space;	/* label right space in pixels */
			OI_display_1d_ends	ends_typ;		/* what to display on the ends */
			OI_string		*min_end;		/* min label */
			OI_number		min_end_x ;		/* the X coordinate of the min label */
			OI_number		min_end_y ;		/* the Y coordinate of the min label */
			OI_number		min_end_wid ;		/* width of minimum label in pixels */
			OI_number		min_lab_sp;		/* Space between min label and slider bar. */
			OI_string		*max_end;		/* max label */
			OI_number		max_end_x ;		/* the X coordinate of the max label */
			OI_number		max_end_y ;		/* the Y coordinate of the max label */
			OI_number		max_end_wid ;		/* width of maximum label in pixels */
			OI_number		max_lab_sp;		/* Space between max label and slider bar. */
			OI_display_1d_current	cur_typ ;		/* How to display current value */
			OI_number		cur_x;			/* X coordinate for current field */
			OI_number		cur_y;			/* Y coordinate for current field */
			OI_number		cur_len;		/* How many characters to paint for current value */
			OI_number		cur_wid ;		/* width of current value in pixels */
			OI_number		cur_val_sp;		/* Space between cur value and slider bar. */
			OI_number		ticks ;			/* number of tick marks */
			OI_display_1d_ticks	tick_typ ;		/* what to display on the tick marks*/
			OI_marker		**mrkr;			/* tick mark labels. */
			long			obj_span ;		/* size of object being scrolled; arbitrary units */
			long			hdl_psn ;		/* current value for object, user units, 0 relative (actual psn is obj_min+hdl_psn) */
			long			obj_min ;		/* minimum value for object, user units */
			OI_position		mrkr_pos;		/* Marker position with respect to bar. */
			OI_number		dec_pos;		/* Decimal point position. */
			OI_number		n_labp;			/* Number of tick labels set. */
			char			**labp;			/* Array of custom tick labels. */
	 public:
		static	OI_class		*clsp ;			/* ptr to class record */
	 private:
			void			clear_in_my_constructor()	{ ctl_bits &= ~OI_DISPLAY_1D_IN_MY_CONSTRUCTOR; }
			void			construct(long,long,const char*,OI_display_1d_ends,const char*,const char*,
							OI_display_1d_current,OI_number,OI_display_1d_ticks,const char* const *) ;
			OI_bool			in_my_constructor()		{ return((ctl_bits & OI_DISPLAY_1D_IN_MY_CONSTRUCTOR) ?
											OI_YES : OI_NO); }
			void			sane() ;
			void			set_in_my_constructor()		{ ctl_bits |= OI_DISPLAY_1D_IN_MY_CONSTRUCTOR; }
	 protected:
			OI_stat			check_decimal_position(OI_number);
			void			clear_needs_repaint()		{ ctl_bits &= ~OI_DISPLAY_1D_NEEDS_REPAINT; }
			void			clear_font_changed()		{ ctl_bits &= ~OI_DISPLAY_1D_FONT_CHANGED; }
			void			free_markers(OI_bool) ;
			void			free_label_list( char ** );
			OI_bool			is_cur_painted()		{ return((ctl_bits & OI_DISPLAY_1D_CUR_PAINTED) ? OI_YES : OI_NO); }
			OI_bool			is_font_changed()		{ return((ctl_bits & OI_DISPLAY_1D_FONT_CHANGED) ? OI_YES : OI_NO); }
			OI_bool			is_lbl_painted()		{ return((ctl_bits & OI_DISPLAY_1D_LBL_PAINTED) ? OI_YES : OI_NO); }
			OI_bool			is_max_painted()		{ return((ctl_bits & OI_DISPLAY_1D_MAX_PAINTED) ? OI_YES : OI_NO); }
			OI_bool			is_min_painted()		{ return((ctl_bits & OI_DISPLAY_1D_MIN_PAINTED) ? OI_YES : OI_NO); }
			OI_bool			needs_repaint()			{ return((ctl_bits & OI_DISPLAY_1D_NEEDS_REPAINT) ? OI_YES : OI_NO); }
		virtual	void			paint_current() = 0 ;				/* paint current value, if displayed somewhere */
		virtual	void			paint_value(long) = 0 ;				/* paint value (bar, needle position, etc */
		virtual	void			re_layout() = 0 ;				/* readjust geometry due to resource changes */
		virtual	void			new_connection(OI_connection*);
			void			new_current_value_type(OI_display_1d_current) ;
			OI_stat			new_decimal_position(OI_number);
			void			new_endType(OI_display_1d_ends) ;
			void			new_label(const char*,OI_char_encode_type) ;
			void			new_label_font(OI_font *, OI_charset=OI_charset_latin1);
			void			new_label_fontset(OI_font_bounds *);
			void			new_label_right_space(OI_number);
			void			new_maximum(long) ;
			void			new_maxLabel(const char*,OI_char_encode_type) ;
			void			new_minimum(long) ;
			void			new_minLabel(const char*,OI_char_encode_type) ;
			void			new_numTick(OI_number) ;
			OI_stat			new_span(long,long) ;
			void			new_tickLabels(const char* const *,OI_char_encode_type) ;
			void			new_tickType(OI_display_1d_ticks) ;
			void			recalc_current_label_parameters() ;
			OI_number		num_markers() ;			/* Number of tick mark labels allocated */

						OI_display_1d(OI_class *clsp, const char *usr_namp, long mx, long mn=0, const char* =NULL,
							OI_display_1d_ends=OI_DISPLAY_1D_ENDS_NONE, const char* =NULL, const char* =NULL,
							OI_display_1d_current cv=OI_DISPLAY_1D_CURRENT_NONE, OI_number nt=0,
							OI_display_1d_ticks tt=OI_DISPLAY_1D_TICKS_NONE, const char* const *tlbl=NULL);
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						~OI_display_1d() ;

			void			adjust_markers(OI_number);			/* Adjust the number of mrkr's */
		virtual	OI_number		alignment_loc_x(OI_alignment = OI_alignment_default);
		virtual	OI_number		alignment_loc_y(OI_alignment = OI_alignment_default);
		virtual	void			clear_painted() ;
		virtual	void			clone_adjust(OI_d_tech*) ;
		virtual	void			compute_display_value(char*, double);		/* From value and decimal position get the string */
			OI_number		current_value_length()		{ return(cur_len); }
			OI_number		current_value_x()		{ return(cur_x); }
			OI_number		current_value_y()		{ return(cur_y); }
			OI_number		current_value_width()		{ return(cur_wid); }
			OI_number		current_value_space()		{ return(cur_val_sp); }
			char			**custom_tick_labels(OI_number *n) {*n = n_labp; return(labp);}
			virtual	void		font_resize() ;						/* resize object because of font change */
			void			force_layout() ;
		static	OI_bool			init(OI_connection*) ;
		virtual	OI_bool			is_write_resq(XrmQuark);
			OI_font			*label_font();
			OI_font_bounds		*label_fontset() ;
			OI_number		label_width()			{ return(lbl_wid); }
			OI_number		label_x()			{ return(lbl_x); }
			OI_number		label_y()			{ return(lbl_y); }
			OI_marker		*marker(OI_number i)		{ return(mrkr[i]);}
			OI_number		marker_horizontal_extent();			/* return maximum space occupied by marker */
			OI_number		marker_vertical_extent();			/* return maximum space occupied by marker */
			void			marker_overflow(OI_number, OI_number, OI_number, OI_orient, OI_number*, OI_number*);
												/* Adjust eof_sp, bof_sp for tck-lab overflow*/
			OI_number		max_label_width()		{ return(max_end_wid); }
			OI_number		max_label_x()			{ return(max_end_x); }
			OI_number		max_label_y()			{ return(max_end_y); }
			OI_number		max_label_space()		{ return(max_lab_sp); }
			OI_number		min_label_width()		{ return(min_end_wid); }
			OI_number		min_label_x()			{ return(min_end_x); }
			OI_number		min_label_y()			{ return(min_end_y); }
			OI_number		min_label_space()		{ return(min_lab_sp); }
		virtual	void			new_tick_position(OI_position);			/* set tick position relative to the bar. */
			OI_string		*ply_label()			{ return(lbl); }
			OI_string		*ply_min_label()		{ return(min_end); }
			OI_string		*ply_max_label()		{ return(max_end); }
			OI_string		*ply_tick_label(OI_number);
		virtual	void			post_get_resources();
			void			recalc_ends_numeric() ;
			void			recalc_markers() ;
			OI_stat			res_decimalPosition(void *);
			void			res_endType(void *) ;
			char			*res_get_maxLabel() ;
			char			*res_get_minLabel() ;
			char			**res_get_tickLabels() ;
			void			res_label_font(void *);
			void			res_label_fontset(void *);
			void			res_label_right_space(void *);
			void			res_maximum(void *) ;
			void			res_minimum(void *) ;
			void			res_numTick(void *) ;
			void			res_label(void *) ;
			void			res_maxLabel(void *) ;
			void			res_minLabel(void *) ;
			void			res_set_tickLabels(void *) ;
			void			res_showValue(void *) ;
			void			res_tickPosition(void *);			/* set tick position relative to the bar. */
			void			res_tickType(void *) ;
			void			res_value(void *) ;
			void			set_current_value_length(OI_number l)		{ cur_len=l; }
			void			set_cvalue_type(OI_display_1d_current t)	{ cur_typ=t; }
			void			set_current_value_x(OI_number x)		{ cur_x=x; }
			void			set_current_value_y(OI_number y)		{ cur_y=y; }
			void			set_current_value_width(OI_number w)		{ cur_wid = w; }
			void			set_cur_painted()		{ ctl_bits |= OI_DISPLAY_1D_CUR_PAINTED; }
			void			set_font_changed()		{ ctl_bits |= OI_DISPLAY_1D_FONT_CHANGED; }
			void			set_label_x(OI_number x)	{ lbl_x=x; }
			void			set_label_y(OI_number y)	{ lbl_y=y; }
			void			set_lbl_painted()		{ ctl_bits |= OI_DISPLAY_1D_LBL_PAINTED; }
			void			set_marker_labels();				/* Set of marker labels from labp */
		virtual	void			set_marker_orientation(OI_marker*);		/* Set orientation of the marker */
			void			set_max_label_x(OI_number x)	{ max_end_x=x; }
			void			set_max_label_y(OI_number y)	{ max_end_y=y; }
			void			set_max_painted()		{ ctl_bits |= OI_DISPLAY_1D_MAX_PAINTED; }
			void			set_min_label_x(OI_number x)	{ min_end_x=x; }
			void			set_min_label_y(OI_number y)	{ min_end_y=y; }
			void			set_min_painted()		{ ctl_bits |= OI_DISPLAY_1D_MIN_PAINTED; }
			void			set_needs_repaint()		{ ctl_bits |= OI_DISPLAY_1D_NEEDS_REPAINT; }
 			char			*tick_label(OI_number);					/* ptr to label for tick #i */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	char			*alpha_value() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			OI_display_1d_current	current_value_type()		{ return(cur_typ); }	/* type of current value display */
			OI_number		decimal_position()		{ return(dec_pos);}
			OI_display_1d_ends	end_label_type()		{ return(ends_typ); }	/* type of labeling for ends */
			char			*label() ;
			OI_number		label_right_space()		{ return(lbl_right_space); }
			long			maximum()			{ return(obj_min+obj_span-1); }	/* maximum allowed value */
			char			*max_label() ;
			long			minimum()			{ return(obj_min); }		/* minimum allowed value */
			char			*min_label() ;
			OI_number		num_ticks()			{ return(ticks); }	/* number of tick marks */
			void			set_current_value_type(OI_display_1d_current);
			OI_stat			set_decimal_position(OI_number);			/* set where decimal point should be displayed. */
			void			set_end_type(OI_display_1d_ends);
			void			set_label(const char *);
			void			set_label_font(const char *, OI_charset = OI_charset_latin1);
			void			set_label_right_space(OI_number);
			void			set_max_label(const char *);
			void			set_min_label(const char *);
			void			set_num_tick(OI_number) ;
		virtual	OI_stat			set_span(long,long) ;					/* set # user units spanned by display */
		virtual	OI_stat			set_span(long r) ;
			void			set_tick_labels(const char* const *);
			void			set_tick_type(OI_display_1d_ticks);
			void			set_tick_position(OI_position);				/* set tick position relative to the bar. */
		virtual	OI_stat			set_value(long) ;
			long			span()				{ return(obj_span); }	/* number of possible values */
			char			**tick_labels() ;					/* ptr to the array of lbls */
			OI_position		tick_position()			{ return(mrkr_pos);}
			OI_display_1d_ticks	tick_type()			{ return(tick_typ); }	/* of tick mark labeling desired */
			long			value()				{ return(obj_min+hdl_psn); }	/* user units; obj_min <= value <= obj_max */
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		


//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

#endif /* OI_dpy_1d_H */
