From owner-amd-workers@acl.lanl.gov Thu Jun 17 12:30:51 1993
Received: from cs.columbia.edu by shekel.cs.columbia.edu with SMTP id AA17809
  (5.65c/IDA-1.4.4.5/jba/jtt/ad for ezk); Thu, 17 Jun 1993 12:30:50 -0400
Received: from cunixf.cc.columbia.edu by cs.columbia.edu (5.65c/0.6/jba+ad+jtt) with SMTP 
	id AA28062; Thu, 17 Jun 1993 12:30:47 -0400
Received: from acl.lanl.gov by cunixf.cc.columbia.edu (5.59/FCB/jba)
	id AA26724; Thu, 17 Jun 93 12:30:24 EDT
Received: by acl.lanl.gov (5.67/SMI-4.1)
	id AA17907; Thu, 17 Jun 93 09:57:06 -0600
Received: from rave.larc.nasa.gov by acl.lanl.gov (5.67/SMI-4.1)
	id AA17901; Thu, 17 Jun 93 09:57:04 -0600
Received: by rave.larc.nasa.gov (5.65.2/server2.4)
	id AA15082; Thu, 17 Jun 93 11:57:01 -0400
Path: tab00.larc.nasa.gov!mike
Newsgroups: mail.amd-workers
Organization: NASA Langley Research Center, Hampton VA, USA
Lines: 81
Message-Id: <MIKE.93Jun17115700@tab12.larc.nasa.gov>
References: <receive.740254207.usenet@news.larc.nasa.gov>
Nntp-Posting-Host: tab12.larc.nasa.gov
In-Reply-To: ecb@galileo.res.utc.com's message of 16 Jun 1993 12:44:14 -0400
Comments: Hyperbole mail buttons accepted, v3.06.
Errors-To: owner-amd-workers@acl.lanl.gov
Reply-To: mike@tab00.larc.nasa.gov (Mike Walker)
From: mike@tab00.larc.nasa.gov (Mike Walker)
Sender: <owner-amd-workers@acl.lanl.gov>
Subject: Re: scripts to change automount maps to amd maps
To: amd-workers@acl.lanl.gov
Date: 17 Jun 1993 15:57:00 GMT

Here's something I used here. You will need to do some hand
editing afterwords, but it's a good start...

Mike
++
#!/bin/perl
#
# Convert Sun automount map format to amd format
#
# This program expects maps with the format
#
#   dir  [ -options ]  machine:/path [ # optional comment ]
#   ...
#
# and generates an equivalent amd map as follows:
#
#   # generated by sun2amd on Fri May 21  9:16:56 1993
#  
#   /defaults \
#     type:=nfs;opts:=rw,grpid,nosuid,utimeout=600
#  
#   ## optional comment
#   ## options: -options
#   dir \
#     hostd==machine.larc.nasa.gov;type:=link;fs:=/path || \
#     domain==larc.nasa.gov;rhost:=machine;rfs:=/path || \
#     rhost:=machine.larc.nasa.gov;rfs:=/path
#   ...
#
# You should set the DOMAIN and DEFAULT variables to your preferences.
#
# $Id: sun2amd,v 1.4 1993/05/24 21:10:05 mike Exp mike $
#

require "ctime.pl";

# amd domain name (doesn't have to be the DNS domain; isn't overloading great!)
# Should be what you will pass to amd via the -d command-line switch.
$DOMAIN='larc.nasa.gov';

# amd default settings; consult the docs for what you can/should do here.
# Note, in particular, that if your disk mount points follow a common scheme
# you can specify ``rfs:=/common/path/${key}'' and not have to insert that
# line (twice) in every entry below!
$DEFAULTS='type:=nfs;opts:=rw,grpid,nosuid,utimeout=600';


# print comment header and default string
printf "# generated by sun2amd on %s\n", &ctime(time);
printf "/defaults \\\n  %s\n\n", $DEFAULTS;

# loop through map
$has_options = 0;
while (<>) {
  if (m,^(\w\S*)(\s+\-\w\S*\s+|\s+)(\w[^:]*):(\/\S*)\s*(.*),) {
    ($dir, $options, $machine, $path, $rest) = ($1, $2, $3, $4, $5);
    print "#$rest\n" if ($rest =~ m/\w/);
    if ($options =~ m/-/) {
      $options =~ s/ //g;
      print "## options: $options\n";
      $has_options++;
    }
    print "$dir \\\n";
    printf "  hostd==%s.%s;type:=link;fs:=%s || \\\n",
	   $machine, $DOMAIN, $path;
    printf "  domain==%s;rhost:=%s;rfs:=%s || \\\n",
	   $DOMAIN, $machine, $path;
    printf "  rhost:=%s.%s;rfs:=%s\n\n", $machine, $DOMAIN, $path;
  }
}

if ($has_options) {
  print STDERR <<"OPTION_NOTE";

NOTE: $has_options entries had custom options which you will need to correct by
      hand. Search for the string \"## options:\" in the new map to find them.

OPTION_NOTE
}
--
Mike Walker  AS&M Inc/NASA LaRC  Voice: +1 804 864 2305  Fax: +1 804 864 6134

