/*
 *  linux/ibcs/socksys.h
 *
 *  Copyright (C) 1994  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: socksys.h,v 1.1 1994/02/21 08:59:00 mike Exp $
 * $Source: /var/CVS/ibcs/include/ibcs/socksys.h,v $
 */

/* Interface to /dev/socksys as used for streams based TCP/IP in SYSV */

/* Get struct rtentry from linux/route.h - this should be compatible. */
#include <linux/route.h>

/* Get struct arpreq from linux/if_arp.h - this should be compatible. */
#include <linux/if_arp.h>

/* Get struct ifreq and struct ifconf from linux/if.h - these should
 * be compatible.
 */
#include <linux/if.h>


struct socksysreq {
	int             args[7];
};


struct socknewproto {
	int             family;	/* address family (AF_INET, etc.) */
	int             type;	/* protocol type (SOCK_STREAM, etc.) */
	int             proto;	/* per family proto number */
	dev_t           dev;	/* major/minor to use (must be a clone) */
	int             flags;	/* protosw flags */
};


/* These are nothing to do with what we know as SO_*. I think they
 * are the command requests which appear in socksysreq structures?
 */
#define  SSYS_SO_ACCEPT		1
#define  SSYS_SO_BIND		2
#define  SSYS_SO_CONNECT	3
#define  SSYS_SO_GETPEERNAME	4
#define  SSYS_SO_GETSOCKNAME	5
#define  SSYS_SO_GETSOCKOPT	6
#define  SSYS_SO_LISTEN		7
#define  SSYS_SO_RECV		8
#define  SSYS_SO_RECVFROM	9
#define  SSYS_SO_SEND		10
#define  SSYS_SO_SENDTO		11
#define  SSYS_SO_SETSOCKOPT	12
#define  SSYS_SO_SHUTDOWN	13
#define  SSYS_SO_SOCKET		14
#define  SSYS_SO_SELECT		15
#define  SSYS_SO_GETIPDOMAIN	16
#define  SSYS_SO_SETIPDOMAIN	17
#define  SSYS_SO_ADJTIME	18
#define  SSYS_SO_SETREUID	19
#define  SSYS_SO_SETREGID	20
#define  SSYS_SO_GETTIME	21
#define  SSYS_SO_SETTIME	22
#define  SSYS_SO_GETITIMER	23
#define  SSYS_SO_SETITIMER	24


/* We encode the ioctl numbers using the argument size as part of
 * the number. This will warn us if we haven't got compatible
 * structures :-).
 */

#define	SSYS_IOCPARM_MASK	0x7f		/* parameters must be < 128 bytes */
#define	SSYS_IOC_VOID		0x20000000	/* no parameters */
#define	SSYS_IOC_OUT		0x40000000	/* copy out parameters */
#define	SSYS_IOC_IN		0x80000000	/* copy in parameters */
#define	SSYS_IOC_INOUT		(SSYS_IOC_IN|SSYS_IOC_OUT)

#define	SSYS_IOS(x,y)		(SSYS_IOC_VOID|(x<<8)|y)
#define	SSYS_IOSR(x,y,t)	(SSYS_IOC_OUT|((sizeof(t)&SSYS_IOCPARM_MASK)<<16)|(x<<8)|y)
#define	SSYS_IOSW(x,y,t)	(SSYS_IOC_IN|((sizeof(t)&SSYS_IOCPARM_MASK)<<16)|(x<<8)|y)
#define	SSYS_IOSWR(x,y,t)	(SSYS_IOC_INOUT|((sizeof(t)&SSYS_IOCPARM_MASK)<<16)|(x<<8)|y)

#define SSYS_SIOCSHIWAT		SSYS_IOSW('S', 1, int)	/* set high watermark */
#define SSYS_SIOCGHIWAT		SSYS_IOSR('S', 2, int)	/* get high watermark */
#define SSYS_SIOCSLOWAT		SSYS_IOSW('S', 3, int)	/* set low watermark */
#define SSYS_SIOCGLOWAT		SSYS_IOSR('S', 4, int)	/* get low watermark */
#define SSYS_SIOCATMARK		SSYS_IOSR('S', 5, int)	/* at oob mark? */
#define SSYS_SIOCSPGRP		SSYS_IOSW('S', 6, int)	/* set process group */
#define SSYS_SIOCGPGRP		SSYS_IOSR('S', 7, int)	/* get process group */
#define SSYS_FIONREAD		SSYS_IOSR('S', 8, int)	/* BSD compatibilty */
#define SSYS_FIONBIO		SSYS_IOSW('S', 9, int)	/* BSD compatibilty */
#define SSYS_FIOASYNC		SSYS_IOSW('S', 10, int)	/* BSD compatibilty */
#define SSYS_SIOCPROTO		SSYS_IOSW('S', 11, struct socknewproto)	/* link proto */
#define SSYS_SIOCGETNAME	SSYS_IOSR('S', 12, struct sockaddr)	/* getsockname */
#define SSYS_SIOCGETPEER	SSYS_IOSR('S', 13, struct sockaddr)	/* getpeername */
#define SSYS_IF_UNITSEL		SSYS_IOSW('S', 14, int)	/* set unit number */
#define SSYS_SIOCXPROTO		SSYS_IOS('S', 15)	/* empty proto table */

#define	SSYS_SIOCADDRT		SSYS_IOSW('R', 9, struct rtentry)	/* add route */
#define	SSYS_SIOCDELRT		SSYS_IOSW('R', 10, struct rtentry)	/* delete route */

#define	SSYS_SIOCSIFADDR	SSYS_IOSW('I', 11, struct ifreq)	/* set ifnet address */
#define	SSYS_SIOCGIFADDR	SSYS_IOSWR('I', 12, struct ifreq)	/* get ifnet address */
#define	SSYS_SIOCSIFDSTADDR	SSYS_IOSW('I', 13, struct ifreq)	/* set p-p address */
#define	SSYS_SIOCGIFDSTADDR	SSYS_IOSWR('I', 14, struct ifreq)	/* get p-p address */
#define	SSYS_SIOCSIFFLAGS	SSYS_IOSW('I', 15, struct ifreq)	/* set ifnet flags */
#define	SSYS_SIOCGIFFLAGS	SSYS_IOSWR('I', 16, struct ifreq)	/* get ifnet flags */
#define	SSYS_SIOCGIFCONF	SSYS_IOSWR('I', 17, struct ifconf)	/* get ifnet list */

#define	SSYS_SIOCSIFMTU		SSYS_IOSW('I', 21, struct ifreq)	/* get if_mtu */
#define	SSYS_SIOCGIFMTU		SSYS_IOSWR('I', 22, struct ifreq)	/* set if_mtu */

#define SSYS_SIOCIFDETACH	SSYS_IOSW('I', 26, struct ifreq)	/* detach interface */
#define SSYS_SIOCGENPSTATS	SSYS_IOSWR('I', 27, struct ifreq)	/* get ENP stats */

#define SSYS_SIOCX25XMT		SSYS_IOSWR('I', 29, struct ifreq)	/* start a slp proc in
							 * x25if */
#define SSYS_SIOCX25RCV		SSYS_IOSWR('I', 30, struct ifreq)	/* start a slp proc in
							 * x25if */
#define SSYS_SIOCX25TBL		SSYS_IOSWR('I', 31, struct ifreq)	/* xfer lun table to
							 * kernel */

#define	SSYS_SIOCGIFBRDADDR	SSYS_IOSWR('I', 32, struct ifreq)	/* get broadcast addr */
#define	SSYS_SIOCSIFBRDADDR	SSYS_IOSW('I', 33, struct ifreq)	/* set broadcast addr */
#define	SSYS_SIOCGIFNETMASK	SSYS_IOSWR('I', 34, struct ifreq)	/* get net addr mask */
#define	SSYS_SIOCSIFNETMASK	SSYS_IOSW('I', 35, struct ifreq)	/* set net addr mask */
#define	SSYS_SIOCGIFMETRIC	SSYS_IOSWR('I', 36, struct ifreq)	/* get IF metric */
#define	SSYS_SIOCSIFMETRIC	SSYS_IOSW('I', 37, struct ifreq)	/* set IF metric */

#define	SSYS_SIOCSARP		SSYS_IOSW('I', 38, struct arpreq)	/* set arp entry */
#define	SSYS_SIOCGARP		SSYS_IOSWR('I', 39, struct arpreq)	/* get arp entry */
#define	SSYS_SIOCDARP		SSYS_IOSW('I', 40, struct arpreq)	/* delete arp entry */

#define SSYS_SIOCSIFNAME	SSYS_IOSW('I', 41, struct ifreq)	/* set interface name */
#define	SSYS_SIOCGIFONEP	SSYS_IOSWR('I', 42, struct ifreq)	/* get one-packet params */
#define	SSYS_SIOCSIFONEP	SSYS_IOSW('I', 43, struct ifreq)	/* set one-packet params */

#define SSYS_SIOCGENADDR	SSYS_IOSWR('I', 65, struct ifreq)	/* Get ethernet addr */

#define SSYS_SIOCSOCKSYS	SSYS_IOSW('I', 66, struct socksysreq)	/* Pseudo socket syscall */
