#ifndef _QIC117_H
#define _QIC117_H

/*
 *      Copyright (C) 1993,1994 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-0.9.10/RCS/qic117.h,v $
 $Author: bas $
 *
 $Revision: 1.17 $
 $Date: 1994/02/20 15:26:55 $
 $State: Alpha $
 *
 *      This file contains QIC-117 spec. related definitions
 *      for the QIC-40/80 floppy-tape driver for Linux.
 *
 *      These data were taken from the Quarter-Inch Cartridge
 *      Drive Standards, Inc. document titled:
 *      `Common Command Set Interface Specification for Flexible
 *       Disk Controller Based Minicartridge Tape Drives'
 *       document QIC-117 Revision C, 3 Dec 92.
 *      For more information, contact:
 *       Quarter-Inch Cartridge Drive Standards, Inc.
 *       311 East Carrillo Street
 *       Santa Barbara, California 93101
 *       Telephone (805) 963-3853
 *       Fax       (805) 962-1541
 *
 */

/*
 *      QIC-117 common command set.
 *      These commands are sent to the tape unit
 *      as number of pulses over the step line.
 */

#define QIC_RESET			1
#define QIC_REPORT_NEXT_BIT		2
#define QIC_PAUSE			3
#define QIC_MICRO_STEP_PAUSE		4
#define QIC_ALTERNATE_TIMEOUT		5
#define QIC_REPORT_DRIVE_STATUS		6
#define QIC_REPORT_ERROR_CODE		7
#define QIC_REPORT_DRIVE_CONFIGURATION	8
#define QIC_REPORT_ROM_VERSION		9
#define QIC_LOGICAL_FORWARD		10
#define QIC_PHYSICAL_REVERSE		11
#define QIC_PHYSICAL_FORWARD		12
#define QIC_SEEK_HEAD_TO_TRACK		13
#define QIC_SEEK_LOAD_POINT		14
#define QIC_ENTER_FORMAT_MODE		15
#define QIC_WRITE_REFERENCE_BURST	16
#define QIC_ENTER_VERIFY_MODE		17
#define QIC_STOP_TAPE			18
#define QIC_MICRO_STEP_HEAD_UP		21
#define QIC_MICRO_STEP_HEAD_DOWN	22
#define QIC_REPORT_VENDOR		24
#define QIC_SKIP_REVERSE		25
#define QIC_SKIP_FORWARD		26
#define QIC_SELECT_RATE			27
#define QIC_ENTER_DIAGNOSTIC_1		28
#define QIC_ENTER_DIAGNOSTIC_2		29
#define QIC_ENTER_PRIMARY_MODE		30
#define QIC_REPORT_VENDOR_ID		32
#define QIC_REPORT_TAPE_STATUS		33
#define QIC_SKIP_EXTENDED_REVERSE	34
#define QIC_SKIP_EXTENDED_FORWARD	35

/*
 *      Some none-common command set commands.
 *      In order to allow the tape drives to coexist with floppy drives
 *      at the same unit, manufacturers have added their own commands that
 *      enable and disable the tape drives.  The Mountain Tape drive
 *      requires two commands to enable.  However, this drive doesn't care
 *      about motor on so it is conceivable that ordinary floppy use could
 *      enable the drive causing unusual havoc.
 */

#define QIC_COLORADO_ENABLE1		46
#define QIC_COLORADO_DISABLE		47

#define QIC_MOUNTAIN_ENABLE1		23
#define QIC_MOUNTAIN_ENABLE2		20
#define QIC_MOUNTAIN_DISABLE		24

#define QIC117_COMMANDS {\
/* 0*/  NULL,\
/* 1*/  "reset",\
/* 2*/  "report next bit",\
/* 3*/  "pause",\
/* 4*/  "micro step pause",\
/* 5*/  "alternate timeout",\
/* 6*/  "report drive status",\
/* 7*/  "report error code",\
/* 8*/  "report drive configuration",\
/* 9*/  "report rom version",\
/*10*/  "logical forward",\
/*11*/  "physical reverse",\
/*12*/  "physical forward",\
/*13*/  "seek head to track",\
/*14*/  "seek load point",\
/*15*/  "enter format mode",\
/*16*/  "write reference burst",\
/*17*/  "enter verify mode",\
/*18*/  "stop tape",\
/*19*/  NULL,\
/*20*/  "mountain select 2",\
/*21*/  "micro step head up",\
/*22*/  "micro step head down",\
/*23*/  "mountain select 1",\
/*24*/  "mountain deselect / report vendor",\
/*25*/  "skip reverse",\
/*26*/  "skip forward",\
/*27*/  "select rate",\
/*28*/  "enter diagnostic mode 1",\
/*29*/  "enter diagnostic mode 2",\
/*30*/  "enter primary mode",\
/*31*/  NULL,\
/*32*/  "report vendor id",\
/*33*/  "report tape status",\
/*34*/  "skip extended reverse",\
/*35*/  "skip extended forward",\
/*36*/  NULL,\
/*37*/  NULL,\
/*38*/  NULL,\
/*39*/  NULL,\
/*40*/  NULL,\
/*41*/  NULL,\
/*42*/  NULL,\
/*43*/  NULL,\
/*44*/  NULL,\
/*45*/  NULL,\
/*46*/  "colorado select 1",\
/*47*/  "colorado deselect",\
}

struct qic117_command_restriction {
  byte mask;
  byte state;
};

/*
 *      command-restrictions is a table specifying the state
 *      the drive status should be in at command execution.
 */

#define QIC117_RESTRICTIONS { \
/* command:                       mask state */ \
/* 0 invalid */                 { 0x00, 0x00 }, \
/* 1 reset */                   { 0x00, 0x00 }, \
/* 2 report next bit */         { 0x00, 0x00 }, \
/* 3 pause */                   { 0x36, 0x24 }, \
/* 4 micro step pause */        { 0x36, 0x24 }, \
/* 5 alternate timeout */       { 0x00, 0x00 }, \
/* 6 report drive status */     { 0x00, 0x00 }, \
/* 7 report error code */       { 0x01, 0x01 }, \
/* 8 report drive configuration */ { 0x00, 0x00 }, \
/* 9 report rom version */      { 0x00, 0x00 }, \
/*10 logical forward */         { 0x37, 0x25 }, \
/*11 physical reverse */        { 0x17, 0x05 }, \
/*12 physical forward */        { 0x17, 0x05 }, \
/*13 seek head to track */      { 0x37, 0x25 }, \
/*14 seek load point */         { 0x17, 0x05 }, \
/*15 enter format mode */       { 0x1f, 0x05 }, \
/*16 write reference burst */   { 0x1f, 0x05 }, \
/*17 enter verify mode */       { 0x37, 0x25 }, \
/*18 stop tape */               { 0x00, 0x00 }, \
/*19 --- */                     { 0x00, 0x00 }, \
/*20 (mountain) enable2 */      { 0x00, 0x00 }, \
/*21 micro step head up */      { 0x02, 0x00 }, \
/*22 micro step head down */    { 0x02, 0x00 }, \
/*23 (mountain) enable1 */      { 0x00, 0x00 }, \
/*24 (mountain) disable */      { 0x00, 0x00 }, \
/*25 skip reverse */            { 0x36, 0x24 }, \
/*26 skip forward */            { 0x36, 0x24 }, \
/*27 select rate */             { 0x03, 0x01 }, \
/*28 enter diag mode 1 */       { 0x00, 0x00 }, \
/*29 enter diag mode 2 */       { 0x00, 0x00 }, \
/*30 enter primary mode */      { 0x00, 0x00 }, \
/*31 --- */                     { 0x00, 0x00 }, \
/*32 report vendor id */        { 0x00, 0x00 }, \
/*33 report tape status */      { 0x04, 0x04 }, \
/*34 skip extended reverse */   { 0x36, 0x24 }, \
/*35 skip extended forward */   { 0x36, 0x24 }, \
/*36 --- */                     { 0x00, 0x00 }, \
/*37 --- */                     { 0x00, 0x00 }, \
/*38 --- */                     { 0x00, 0x00 }, \
/*39 --- */                     { 0x00, 0x00 }, \
/*40 --- */                     { 0x00, 0x00 }, \
/*41 --- */                     { 0x00, 0x00 }, \
/*42 --- */                     { 0x00, 0x00 }, \
/*43 --- */                     { 0x00, 0x00 }, \
/*44 --- */                     { 0x00, 0x00 }, \
/*45 --- */                     { 0x00, 0x00 }, \
/*46 (colorodo) enable1 */      { 0x00, 0x00 }, \
/*47 (colorado) disable */      { 0x00, 0x00 }, \
}

/*
 *      Status bits returned by QIC_REPORT_DRIVE_STATUS
 */

#define QIC_STATUS_READY	0x01 /* Drive is ready or idle. */
#define QIC_STATUS_ERROR	0x02 /* Error detected, must read
                                        error code to clear this */
#define QIC_STATUS_CARTRIDGE_PRESENT 0x04 /* Tape is present */
#define QIC_STATUS_WRITE_PROTECT 0x08 /* Tape is write protected */
#define QIC_STATUS_NEW_CARTRIDGE 0x10 /* New cartridge inserted, must
					 read error status to clear. */
#define QIC_STATUS_REFERENCED	0x20 /* Cartridge appears to have been
					formatted. */
#define QIC_STATUS_AT_BOT	0x40 /* Cartridge is at physical
					beginning of tape. */
#define QIC_STATUS_AT_EOT	0x80 /* Cartridge is at physical end
					of tape. */
/*
 *      Status bits returned by QIC_REPORT_DRIVE_CONFIGURATION
 */

#define QIC_CONFIG_RATE_MASK	0x18
#define QIC_CONFIG_RATE_250	0x00
#define QIC_CONFIG_RATE_500	0x10
#define QIC_CONFIG_RATE_1000	0x18

#define QIC_CONFIG_LONG		0x40 /* Extra Length Tape Detected */
#define QIC_CONFIG_80		0x80 /* QIC-80 detected. */

/*
 *      Status bits returned by QIC_REPORT_TAPE_STATUS
 */

#define QIC_TAPE_STD_MASK       0x0f
#define QIC_TAPE_QIC40  	0x01
#define QIC_TAPE_QIC80  	0x02
#define QIC_TAPE_QIC500  	0x03

#define QIC_TAPE_LEN_MASK       0xf0
#define QIC_TAPE_205FT          0x10
#define QIC_TAPE_307FT          0x20
#define QIC_TAPE_295FT          0x30

/*
 *      Errors: List of error codes, and their fatalness.
 */

typedef struct {
    char *message;		/* Text describing the error. */
    int fatal;			/* Non-zero if the error is fatal. */
} ftape_error;

#define QIC117_ERRORS {\
  /* 0*/ { "No error", 0, },\
  /* 1*/ { "Command Received while Drive Not Ready", 0, },\
  /* 2*/ { "Cartridge Not Present or Removed", 1, },\
  /* 3*/ { "Motor Speed Error", 1, },\
  /* 4*/ { "Motor Speed fault", 1, },\
  /* 5*/ { "Cartridge Write Protected", 1, },\
  /* 6*/ { "Undefined or Reserved Command Code", 1, },\
  /* 7*/ { "Illegal Track address specified for Seek", 1, },\
  /* 8*/ { "Illegal Command in Report Subcontext", 0, },\
  /* 9*/ { "Illegal Entry into a Diagnostic Mode", 1, },\
  /*10*/ { "Broken Tape Detected", 1, },\
  /*11*/ { "Warning--Read Gain Setting Error", 1, },\
  /*12*/ { "Command Received while Error Status Pending", 1, },\
  /*13*/ { "Command Received while New Cartridge Pending", 1, },\
  /*14*/ { "Command Illegal or Undefined in Primary Mode", 1, },\
  /*15*/ { "Command Illegal or Undefined in Format Mode", 1, },\
  /*16*/ { "Command Illegal or Undefined in Verify Mode", 1, },\
  /*17*/ { "Logical Forward not a Logical BOT in Format Mode", 1, },\
  /*18*/ { "Logical EOT before all Segments generated", 1, },\
  /*19*/ { "Command Illegal when Cartridge Not Referenced", 1, },\
  /*20*/ { "Self-Diagnostic Failed", 1, },\
  /*21*/ { "Warning EEPROM Not Initialized, defaults set", 1, },\
  /*22*/ { "EEPROM Corrupted or Hardware Failure", 1, },\
  /*23*/ { "Motion Time-out error", 1, },\
  /*24*/ { "Datat Segment Too Long--Logical Forward or Pause", 1, },\
  /*25*/ { "Transmit Overrun", 1, },\
  /*26*/ { "Power On Reset Occurred", 0, },\
  /*27*/ { "Software Reset Occurred", 0, },\
  /*28*/ { "Diagnostic Mode 1 Error", 1, },\
  /*29*/ { "Diagnostic Mode 2 Error", 1, },\
  /*30*/ { "Command Received During Non-Interruptable Process", 1, },\
  /*31*/ { "Rate Selection error", 1, },\
  /*32*/ { "Illegal command while in high speed mode", 1, },\
  /*33*/ { "Illegal seek segment value", 1, },\
  /*34*/ { "?Invalid tape media (QIC-80)", 1, },\
  /*35*/ { "?Head reference failure (QIC-80)", 1, },\
  /*36*/ { "?Seek to edge tracks failed (QIC-80)", 1, },\
  /*37*/ { "?Missing training table", 1, },\
  /*38*/ { "?Invalid format", 1, },\
  /*39*/ { "?EOT/BOT sensor failure", 1, },\
  /*40*/ { "?Training table checksum failure", 1, },\
  /*41*/ { "?Reset by watchdog timer", 1, },\
  /*42*/ { "?Illegal error number", 1, },\
}

#endif /* _QIC117_H */
