/*
 * util.c
 *
 * Copyright (c) 1990, 1991, John W. Eaton.
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * John W. Eaton
 * jwe@che.utexas.edu
 * Department of Chemical Engineering
 * The University of Texas at Austin
 * Austin, Texas  78712
 *
 * Wed May  4 15:44:47 BST 1994 Wilf. (G.Wilford@ee.surrey.ac.uk): slight
 * changes to all routines, mainly cosmetic.
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
/* #include <sys/types.h> */
#include <sys/stat.h>

#ifdef STDC_HEADERS
#include <stdlib.h>
#else
extern int fprintf ();
extern int tolower ();
#endif

/* extern char *strdup ();
extern int system (); */

#include "gripes.h"

/*
 * Extract last element of a name like /foo/bar/baz.
 */
char *mkprogname (char *s)
{
	char *t;

	s = ( (t = strrchr (s, '/')) == NULL) ? s : ++t;

	return strdup (s);
}

void downcase (char *s)
{
	while (*s != '\0'){
		tolower (*(s++));
	}
}

/*
 * Is file a newer than file b?
 *
 * case:
 *
 *   a is man_page, b is cat_page
 *
 *   a newer than b         returns    1/3  (ret & 1) == 1
 *   a older than b         returns    0/2  !(ret & 1) == 1
 *   a is zero in length    returns    + 2 (for Wilf. and his stray cats)
 *   stat on a fails        returns   -1
 *   stat on b fails        returns   -2
 *   stat on a and b fails  returns   -3
 */
int is_newer (char *fa, char *fb)
{
	struct stat fa_sb;
	struct stat fb_sb;
	int fa_stat;
	int fb_stat;
	int status = 0;

	fa_stat = stat (fa, &fa_sb);
	if (fa_stat != 0)
		status = 1;

	fb_stat = stat (fb, &fb_sb);
	if (fb_stat != 0)
		status |= 2;

	if (status != 0)
		return -status;

	if (fa_sb.st_size == 0)
		status |= 2;		

	return status | (fa_sb.st_mtime > fb_sb.st_mtime);
}

/*
 * Is path a directory?
 */
int is_directory (char *path)
{
	struct stat sb;
	int status;

	status = stat (path, &sb);

	if (status != 0)
		return status;

	return S_ISDIR(sb.st_mode);
}

/*
 * Attempt a system () call.  Return 1 for success and 0 for failure
 * (handy for counting successes :-).
 */
int do_system_command (char *command)
{
	int status = 0;
	extern int debug;

  	/*
  	 * If we're debugging, don't really execute the command -- you never
  	 * know what might be in that mangled string :-O.
  	 */
  	 
	if (debug)
		fprintf (stderr, "\ntrying command: %s\n", command);
	else
		status = system (command);

	/*
  	 * Ultrix returns 127 for failure.  Is this normal?
  	 * Most OS's return != 0 for failure, use that instead, Wilf.
  	 */
  	 
	if (status != 0){
		gripe_system_command (status);
		return 0;
	}
	else
		return 1;
}
