/* valageniescanner.c generated by valac, the Vala compiler
 * generated from valageniescanner.vala, do not modify */

/* valageniescanner.vala
 *
 * Copyright (C) 2008-2012  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define VALA_GENIE_SCANNER_TYPE_CONDITIONAL (vala_genie_scanner_conditional_get_type ())
typedef struct _ValaGenieScannerConditional ValaGenieScannerConditional;
typedef enum  {
	VALA_GENIE_SCANNER_STATE_PARENS,
	VALA_GENIE_SCANNER_STATE_BRACE,
	VALA_GENIE_SCANNER_STATE_BRACKET,
	VALA_GENIE_SCANNER_STATE_REGEX_LITERAL,
	VALA_GENIE_SCANNER_STATE_TEMPLATE,
	VALA_GENIE_SCANNER_STATE_TEMPLATE_PART
} ValaGenieScannerState;

#define VALA_GENIE_SCANNER_TYPE_STATE (vala_genie_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaGenieParamSpecScanner ValaGenieParamSpecScanner;

struct _ValaGenieScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

struct _ValaGenieScannerPrivate {
	ValaSourceFile* _source_file;
	gint _indent_spaces;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	gint current_indent_level;
	gint indent_level;
	gint pending_dedents;
	gint open_parens_count;
	gint open_brace_count;
	ValaGenieTokenType last_token;
	gboolean parse_started;
	ValaComment* _comment;
	ValaGenieScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaGenieScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaGenieParamSpecScanner {
	GParamSpec parent_instance;
};

static gint ValaGenieScanner_private_offset;
static gpointer vala_genie_scanner_parent_class = NULL;

static GType vala_genie_scanner_conditional_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self);
static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self);
static GType vala_genie_scanner_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                         ValaSourceFile* value);
static gboolean vala_genie_scanner_in_template (ValaGenieScanner* self);
static gboolean vala_genie_scanner_in_template_part (ValaGenieScanner* self);
static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                           gchar c);
static gboolean vala_genie_scanner_in_regex_literal (ValaGenieScanner* self);
static ValaSourceReference* vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                                              gint offset,
                                                              gint length);
static gboolean vala_genie_scanner_matches (gchar* begin,
                                     const gchar* keyword);
static void _vala_array_add3 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add4 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add5 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add6 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void vala_genie_scanner_space (ValaGenieScanner* self);
static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self);
static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self);
static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self);
static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self);
static void _vala_array_add7 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add8 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add9 (ValaGenieScannerState* * array,
                       gint* length,
                       gint* size,
                       ValaGenieScannerState value);
static void _vala_array_add10 (ValaGenieScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaGenieScannerState value);
static void _vala_array_add11 (ValaGenieScannerState* * array,
                        gint* length,
                        gint* size,
                        ValaGenieScannerState value);
static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_directive (ValaGenieScanner* self);
static gboolean vala_genie_scanner_comment (ValaGenieScanner* self,
                                     gboolean file_comment);
static void vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                      const gchar* comment_item,
                                      ValaSourceReference* source_reference,
                                      gboolean file_comment);
static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self);
static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_space (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self);
static void vala_genie_scanner_pp_eol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self);
static void _vala_array_add12 (ValaGenieScannerConditional* * array,
                        gint* length,
                        gint* size,
                        const ValaGenieScannerConditional* value);
static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self);
static void vala_genie_scanner_finalize (ValaGenieScanner * obj);
static GType vala_genie_scanner_get_type_once (void);

static inline gpointer
vala_genie_scanner_get_instance_private (ValaGenieScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGenieScanner_private_offset);
}

static GType
vala_genie_scanner_state_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_GENIE_SCANNER_STATE_PARENS, "VALA_GENIE_SCANNER_STATE_PARENS", "parens"}, {VALA_GENIE_SCANNER_STATE_BRACE, "VALA_GENIE_SCANNER_STATE_BRACE", "brace"}, {VALA_GENIE_SCANNER_STATE_BRACKET, "VALA_GENIE_SCANNER_STATE_BRACKET", "bracket"}, {VALA_GENIE_SCANNER_STATE_REGEX_LITERAL, "VALA_GENIE_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE, "VALA_GENIE_SCANNER_STATE_TEMPLATE", "template"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE_PART, "VALA_GENIE_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {0, NULL, NULL}};
	GType vala_genie_scanner_state_type_id;
	vala_genie_scanner_state_type_id = g_enum_register_static ("ValaGenieScannerState", values);
	return vala_genie_scanner_state_type_id;
}

static GType
vala_genie_scanner_state_get_type (void)
{
	static volatile gsize vala_genie_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_state_type_id__volatile)) {
		GType vala_genie_scanner_state_type_id;
		vala_genie_scanner_state_type_id = vala_genie_scanner_state_get_type_once ();
		g_once_init_leave (&vala_genie_scanner_state_type_id__volatile, vala_genie_scanner_state_type_id);
	}
	return vala_genie_scanner_state_type_id__volatile;
}

ValaSourceFile*
vala_genie_scanner_get_source_file (ValaGenieScanner* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static void
vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                    ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp0_;
}

gint
vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_indent_spaces;
	return result;
}

void
vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_indent_spaces = value;
}

ValaGenieScanner*
vala_genie_scanner_construct (GType object_type,
                              ValaSourceFile* source_file)
{
	ValaGenieScanner* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaGenieScanner*) g_type_create_instance (object_type);
	vala_genie_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	self->priv->begin = _tmp0_;
	_tmp1_ = self->priv->begin;
	self->priv->end = _tmp1_ + vala_source_file_get_mapped_length (source_file);
	_tmp2_ = self->priv->begin;
	self->priv->current = _tmp2_;
	self->priv->_indent_spaces = 0;
	self->priv->line = 1;
	self->priv->column = 1;
	self->priv->current_indent_level = 0;
	self->priv->indent_level = 0;
	self->priv->pending_dedents = 0;
	self->priv->open_parens_count = 0;
	self->priv->open_brace_count = 0;
	self->priv->parse_started = FALSE;
	self->priv->last_token = VALA_GENIE_TOKEN_TYPE_NONE;
	return self;
}

ValaGenieScanner*
vala_genie_scanner_new (ValaSourceFile* source_file)
{
	return vala_genie_scanner_construct (VALA_GENIE_TYPE_SCANNER, source_file);
}

static gboolean
vala_genie_scanner_in_template (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_in_template_part (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                  gchar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_genie_scanner_in_regex_literal (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static ValaSourceReference*
vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                         gint offset,
                                         gint length)
{
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	ValaSourceReference* _tmp5_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	vala_source_location_init (&_tmp2_, _tmp1_, self->priv->line, self->priv->column + offset);
	_tmp3_ = self->priv->current;
	vala_source_location_init (&_tmp4_, _tmp3_ + length, self->priv->line, (self->priv->column + offset) + length);
	_tmp5_ = vala_source_reference_new (_tmp0_, &_tmp2_, &_tmp4_);
	result = _tmp5_;
	return result;
}

ValaGenieTokenType
vala_genie_scanner_read_regex_token (ValaGenieScanner* self,
                                     ValaSourceLocation* token_begin,
                                     ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp111_;
	ValaGenieTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '/':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				gboolean fl_i = FALSE;
				gboolean fl_s = FALSE;
				gboolean fl_m = FALSE;
				gboolean fl_x = FALSE;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					gboolean _tmp10_ = FALSE;
					gchar* _tmp11_;
					gchar _tmp12_;
					gchar* _tmp19_;
					gchar _tmp20_;
					gchar* _tmp29_;
					gint _tmp30_;
					_tmp11_ = self->priv->current;
					_tmp12_ = _tmp11_[0];
					if (_tmp12_ == 'i') {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp13_;
						gchar _tmp14_;
						_tmp13_ = self->priv->current;
						_tmp14_ = _tmp13_[0];
						_tmp10_ = _tmp14_ == 's';
					}
					if (_tmp10_) {
						_tmp9_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp9_ = _tmp16_ == 'm';
					}
					if (_tmp9_) {
						_tmp8_ = TRUE;
					} else {
						gchar* _tmp17_;
						gchar _tmp18_;
						_tmp17_ = self->priv->current;
						_tmp18_ = _tmp17_[0];
						_tmp8_ = _tmp18_ == 'x';
					}
					if (!_tmp8_) {
						break;
					}
					_tmp19_ = self->priv->current;
					_tmp20_ = _tmp19_[0];
					switch (_tmp20_) {
						case 'i':
						{
							if (fl_i) {
								ValaSourceReference* _tmp21_;
								ValaSourceReference* _tmp22_;
								_tmp21_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp22_ = _tmp21_;
								vala_report_error (_tmp22_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp22_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							if (fl_s) {
								ValaSourceReference* _tmp23_;
								ValaSourceReference* _tmp24_;
								_tmp23_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp24_ = _tmp23_;
								vala_report_error (_tmp24_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp24_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							if (fl_m) {
								ValaSourceReference* _tmp25_;
								ValaSourceReference* _tmp26_;
								_tmp25_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp26_ = _tmp25_;
								vala_report_error (_tmp26_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp26_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							if (fl_x) {
								ValaSourceReference* _tmp27_;
								ValaSourceReference* _tmp28_;
								_tmp27_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp28_ = _tmp27_;
								vala_report_error (_tmp28_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp28_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp29_ = self->priv->current;
					self->priv->current = _tmp29_ + 1;
					_tmp30_ = token_length_in_chars;
					token_length_in_chars = _tmp30_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp98_ = FALSE;
				gchar* _tmp99_;
				gchar* _tmp100_;
				type = VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp31_ = FALSE;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp36_;
					gchar _tmp37_;
					_tmp32_ = self->priv->current;
					_tmp33_ = self->priv->end;
					if (_tmp32_ < _tmp33_) {
						gchar* _tmp34_;
						gchar _tmp35_;
						_tmp34_ = self->priv->current;
						_tmp35_ = _tmp34_[0];
						_tmp31_ = _tmp35_ != '/';
					} else {
						_tmp31_ = FALSE;
					}
					if (!_tmp31_) {
						break;
					}
					_tmp36_ = self->priv->current;
					_tmp37_ = _tmp36_[0];
					if (_tmp37_ == '\\') {
						gchar* _tmp38_;
						gint _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar _tmp43_;
						_tmp38_ = self->priv->current;
						self->priv->current = _tmp38_ + 1;
						_tmp39_ = token_length_in_chars;
						token_length_in_chars = _tmp39_ + 1;
						_tmp40_ = self->priv->current;
						_tmp41_ = self->priv->end;
						if (_tmp40_ >= _tmp41_) {
							break;
						}
						_tmp42_ = self->priv->current;
						_tmp43_ = _tmp42_[0];
						switch (_tmp43_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'N':
							case 'r':
							case 'R':
							case 't':
							case 'v':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp44_;
								gint _tmp45_;
								_tmp44_ = self->priv->current;
								self->priv->current = _tmp44_ + 1;
								_tmp45_ = token_length_in_chars;
								token_length_in_chars = _tmp45_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp46_;
								gint _tmp47_;
								gint digit_length = 0;
								_tmp46_ = self->priv->current;
								self->priv->current = _tmp46_ + 1;
								_tmp47_ = token_length_in_chars;
								token_length_in_chars = _tmp47_ + 1;
								{
									gboolean _tmp48_ = FALSE;
									digit_length = 0;
									_tmp48_ = TRUE;
									while (TRUE) {
										gboolean _tmp50_ = FALSE;
										gchar* _tmp51_;
										gchar* _tmp52_;
										gchar* _tmp55_;
										gint _tmp56_;
										if (!_tmp48_) {
											gint _tmp49_;
											_tmp49_ = digit_length;
											digit_length = _tmp49_ + 1;
										}
										_tmp48_ = FALSE;
										_tmp51_ = self->priv->current;
										_tmp52_ = self->priv->end;
										if (_tmp51_ < _tmp52_) {
											gchar* _tmp53_;
											gchar _tmp54_;
											_tmp53_ = self->priv->current;
											_tmp54_ = _tmp53_[0];
											_tmp50_ = g_ascii_isxdigit (_tmp54_);
										} else {
											_tmp50_ = FALSE;
										}
										if (!_tmp50_) {
											break;
										}
										_tmp55_ = self->priv->current;
										self->priv->current = _tmp55_ + 1;
										_tmp56_ = token_length_in_chars;
										token_length_in_chars = _tmp56_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp57_;
									ValaSourceReference* _tmp58_;
									_tmp57_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp58_ = _tmp57_;
									vala_report_error (_tmp58_, "\\u used with no following hex digits");
									_vala_source_reference_unref0 (_tmp58_);
								} else {
									if (digit_length < 4) {
										ValaSourceReference* _tmp59_;
										ValaSourceReference* _tmp60_;
										_tmp59_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp60_ = _tmp59_;
										vala_report_error (_tmp60_, "incomplete universal character name");
										_vala_source_reference_unref0 (_tmp60_);
									}
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp61_;
								gint _tmp62_;
								gint digit_length = 0;
								_tmp61_ = self->priv->current;
								self->priv->current = _tmp61_ + 1;
								_tmp62_ = token_length_in_chars;
								token_length_in_chars = _tmp62_ + 1;
								{
									gboolean _tmp63_ = FALSE;
									digit_length = 0;
									_tmp63_ = TRUE;
									while (TRUE) {
										gboolean _tmp64_ = FALSE;
										gchar* _tmp65_;
										gchar* _tmp66_;
										gchar* _tmp69_;
										gchar _tmp70_;
										gchar* _tmp72_;
										gint _tmp73_;
										if (!_tmp63_) {
										}
										_tmp63_ = FALSE;
										_tmp65_ = self->priv->current;
										_tmp66_ = self->priv->end;
										if (_tmp65_ < _tmp66_) {
											gchar* _tmp67_;
											gchar _tmp68_;
											_tmp67_ = self->priv->current;
											_tmp68_ = _tmp67_[0];
											_tmp64_ = g_ascii_isxdigit (_tmp68_);
										} else {
											_tmp64_ = FALSE;
										}
										if (!_tmp64_) {
											break;
										}
										_tmp69_ = self->priv->current;
										_tmp70_ = _tmp69_[0];
										if (_tmp70_ != '0') {
											gint _tmp71_;
											_tmp71_ = digit_length;
											digit_length = _tmp71_ + 1;
										}
										_tmp72_ = self->priv->current;
										self->priv->current = _tmp72_ + 1;
										_tmp73_ = token_length_in_chars;
										token_length_in_chars = _tmp73_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp74_;
									ValaSourceReference* _tmp75_;
									_tmp74_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp75_ = _tmp74_;
									vala_report_error (_tmp75_, "\\x used with no following hex digits");
									_vala_source_reference_unref0 (_tmp75_);
								} else {
									if (digit_length > 2) {
										ValaSourceReference* _tmp76_;
										ValaSourceReference* _tmp77_;
										_tmp76_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp77_ = _tmp76_;
										vala_report_error (_tmp77_, "hex escape sequence out of range");
										_vala_source_reference_unref0 (_tmp77_);
									}
								}
								break;
							}
							default:
							{
								gchar* _tmp78_;
								gchar _tmp79_;
								_tmp78_ = self->priv->current;
								_tmp79_ = _tmp78_[0];
								if (g_ascii_isdigit (_tmp79_)) {
									gchar* _tmp80_;
									gint _tmp81_;
									gchar* _tmp82_;
									gchar _tmp83_;
									_tmp80_ = self->priv->current;
									self->priv->current = _tmp80_ + 1;
									_tmp81_ = token_length_in_chars;
									token_length_in_chars = _tmp81_ + 1;
									_tmp82_ = self->priv->current;
									_tmp83_ = _tmp82_[0];
									if (g_ascii_isdigit (_tmp83_)) {
										gchar* _tmp84_;
										gint _tmp85_;
										_tmp84_ = self->priv->current;
										self->priv->current = _tmp84_ + 1;
										_tmp85_ = token_length_in_chars;
										token_length_in_chars = _tmp85_ + 1;
									}
								} else {
									ValaSourceReference* _tmp86_;
									ValaSourceReference* _tmp87_;
									_tmp86_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp87_ = _tmp86_;
									vala_report_error (_tmp87_, "invalid escape sequence");
									_vala_source_reference_unref0 (_tmp87_);
								}
								break;
							}
						}
					} else {
						gchar* _tmp88_;
						gchar _tmp89_;
						_tmp88_ = self->priv->current;
						_tmp89_ = _tmp88_[0];
						if (_tmp89_ == '\n') {
							break;
						} else {
							gunichar u = 0U;
							gchar* _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							_tmp90_ = self->priv->current;
							_tmp91_ = self->priv->end;
							_tmp92_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp90_, (gssize) ((glong) (_tmp91_ - _tmp92_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp93_;
								gint _tmp94_;
								_tmp93_ = self->priv->current;
								self->priv->current = _tmp93_ + g_unichar_to_utf8 (u, NULL);
								_tmp94_ = token_length_in_chars;
								token_length_in_chars = _tmp94_ + 1;
							} else {
								gchar* _tmp95_;
								ValaSourceReference* _tmp96_;
								ValaSourceReference* _tmp97_;
								_tmp95_ = self->priv->current;
								self->priv->current = _tmp95_ + 1;
								_tmp96_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp97_ = _tmp96_;
								vala_report_error (_tmp97_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp97_);
							}
						}
					}
				}
				_tmp99_ = self->priv->current;
				_tmp100_ = self->priv->end;
				if (_tmp99_ >= _tmp100_) {
					_tmp98_ = TRUE;
				} else {
					gchar* _tmp101_;
					gchar _tmp102_;
					_tmp101_ = self->priv->current;
					_tmp102_ = _tmp101_[0];
					_tmp98_ = _tmp102_ == '\n';
				}
				if (_tmp98_) {
					ValaSourceReference* _tmp103_;
					ValaSourceReference* _tmp104_;
					gint _tmp105_;
					ValaSourceLocation _tmp106_ = {0};
					ValaSourceLocation _tmp107_ = {0};
					ValaGenieTokenType _tmp108_;
					_tmp103_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp104_ = _tmp103_;
					vala_report_error (_tmp104_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp104_);
					_tmp105_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp105_ - 1;
					_tmp108_ = vala_genie_scanner_read_token (self, &_tmp106_, &_tmp107_);
					_vala_token_begin = _tmp106_;
					_vala_token_end = _tmp107_;
					result = _tmp108_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp109_;
		gchar* _tmp110_;
		_tmp109_ = self->priv->current;
		_tmp110_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp109_ - _tmp110_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp111_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp111_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

void
vala_genie_scanner_seek (ValaGenieScanner* self,
                         ValaSourceLocation* location)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	self->priv->line = _tmp2_.line;
	_tmp3_ = *location;
	self->priv->column = _tmp3_.column;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}

ValaGenieTokenType
vala_genie_scanner_get_identifier_or_keyword (gchar* begin,
                                              gint len)
{
	ValaGenieTokenType result = 0;
	switch (len) {
		case 2:
		{
			gchar _tmp0_;
			_tmp0_ = begin[0];
			switch (_tmp0_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "as")) {
						result = VALA_GENIE_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "do")) {
						result = VALA_GENIE_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar _tmp1_;
					_tmp1_ = begin[1];
					switch (_tmp1_) {
						case 'f':
						{
							result = VALA_GENIE_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_GENIE_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_GENIE_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "of")) {
						result = VALA_GENIE_TOKEN_TYPE_OF;
						return result;
					}
					if (vala_genie_scanner_matches (begin, "or")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_OR;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "to")) {
						result = VALA_GENIE_TOKEN_TYPE_TO;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar _tmp2_;
			_tmp2_ = begin[0];
			switch (_tmp2_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "and")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_AND;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "def")) {
						result = VALA_GENIE_TOKEN_TYPE_DEF;
						return result;
					}
					break;
				}
				case 'f':
				{
					if (vala_genie_scanner_matches (begin, "for")) {
						result = VALA_GENIE_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					if (vala_genie_scanner_matches (begin, "get")) {
						result = VALA_GENIE_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "isa")) {
						result = VALA_GENIE_TOKEN_TYPE_ISA;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar _tmp3_;
					_tmp3_ = begin[1];
					switch (_tmp3_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "new")) {
								result = VALA_GENIE_TOKEN_TYPE_NEW;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "not")) {
								result = VALA_GENIE_TOKEN_TYPE_OP_NEG;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "out")) {
						result = VALA_GENIE_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "ref")) {
						result = VALA_GENIE_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "set")) {
						result = VALA_GENIE_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "try")) {
						result = VALA_GENIE_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "var")) {
						result = VALA_GENIE_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar _tmp4_;
			_tmp4_ = begin[0];
			switch (_tmp4_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "case")) {
						result = VALA_GENIE_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "dict")) {
						result = VALA_GENIE_TOKEN_TYPE_DICT;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp5_;
					_tmp5_ = begin[1];
					switch (_tmp5_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "else")) {
								result = VALA_GENIE_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							if (vala_genie_scanner_matches (begin, "enum")) {
								result = VALA_GENIE_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "init")) {
						result = VALA_GENIE_TOKEN_TYPE_INIT;
						return result;
					}
					break;
				}
				case 'l':
				{
					gchar _tmp6_;
					_tmp6_ = begin[1];
					switch (_tmp6_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "list")) {
								result = VALA_GENIE_TOKEN_TYPE_LIST;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "lock")) {
								result = VALA_GENIE_TOKEN_TYPE_LOCK;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "null")) {
						result = VALA_GENIE_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp7_;
					_tmp7_ = begin[1];
					switch (_tmp7_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "pass")) {
								result = VALA_GENIE_TOKEN_TYPE_PASS;
								return result;
							}
							break;
						}
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "prop")) {
								result = VALA_GENIE_TOKEN_TYPE_PROP;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "self")) {
						result = VALA_GENIE_TOKEN_TYPE_SELF;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "true")) {
						result = VALA_GENIE_TOKEN_TYPE_TRUE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "uses")) {
						result = VALA_GENIE_TOKEN_TYPE_USES;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "void")) {
						result = VALA_GENIE_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar _tmp8_;
					_tmp8_ = begin[1];
					switch (_tmp8_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "weak")) {
								result = VALA_GENIE_TOKEN_TYPE_WEAK;
								return result;
							}
							break;
						}
						case 'h':
						{
							if (vala_genie_scanner_matches (begin, "when")) {
								result = VALA_GENIE_TOKEN_TYPE_WHEN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar _tmp9_;
			_tmp9_ = begin[0];
			switch (_tmp9_) {
				case 'a':
				{
					gchar _tmp10_;
					_tmp10_ = begin[1];
					switch (_tmp10_) {
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "array")) {
								result = VALA_GENIE_TOKEN_TYPE_ARRAY;
								return result;
							}
							break;
						}
						case 's':
						{
							if (vala_genie_scanner_matches (begin, "async")) {
								result = VALA_GENIE_TOKEN_TYPE_ASYNC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'b':
				{
					if (vala_genie_scanner_matches (begin, "break")) {
						result = VALA_GENIE_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar _tmp11_;
					_tmp11_ = begin[1];
					switch (_tmp11_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "class")) {
								result = VALA_GENIE_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "const")) {
								result = VALA_GENIE_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "event")) {
						result = VALA_GENIE_TOKEN_TYPE_EVENT;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp12_;
					_tmp12_ = begin[1];
					switch (_tmp12_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "false")) {
								result = VALA_GENIE_TOKEN_TYPE_FALSE;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "final")) {
								result = VALA_GENIE_TOKEN_TYPE_FINAL;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "owned")) {
						result = VALA_GENIE_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "print")) {
						result = VALA_GENIE_TOKEN_TYPE_PRINT;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "super")) {
						result = VALA_GENIE_TOKEN_TYPE_SUPER;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "raise")) {
						result = VALA_GENIE_TOKEN_TYPE_RAISE;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_genie_scanner_matches (begin, "while")) {
						result = VALA_GENIE_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					if (vala_genie_scanner_matches (begin, "yield")) {
						result = VALA_GENIE_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar _tmp13_;
			_tmp13_ = begin[0];
			switch (_tmp13_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "assert")) {
						result = VALA_GENIE_TOKEN_TYPE_ASSERT;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar _tmp14_;
					_tmp14_ = begin[1];
					switch (_tmp14_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "delete")) {
								result = VALA_GENIE_TOKEN_TYPE_DELETE;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "downto")) {
								result = VALA_GENIE_TOKEN_TYPE_DOWNTO;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp15_;
					_tmp15_ = begin[1];
					switch (_tmp15_) {
						case 'x':
						{
							gchar _tmp16_;
							_tmp16_ = begin[2];
							switch (_tmp16_) {
								case 'c':
								{
									if (vala_genie_scanner_matches (begin, "except")) {
										result = VALA_GENIE_TOKEN_TYPE_EXCEPT;
										return result;
									}
									break;
								}
								case 't':
								{
									if (vala_genie_scanner_matches (begin, "extern")) {
										result = VALA_GENIE_TOKEN_TYPE_EXTERN;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "inline")) {
						result = VALA_GENIE_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp17_;
					_tmp17_ = begin[1];
					switch (_tmp17_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "params")) {
								result = VALA_GENIE_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							if (vala_genie_scanner_matches (begin, "public")) {
								result = VALA_GENIE_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp18_;
					_tmp18_ = begin[1];
					switch (_tmp18_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "raises")) {
								result = VALA_GENIE_TOKEN_TYPE_RAISES;
								return result;
							}
							break;
						}
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "return")) {
								result = VALA_GENIE_TOKEN_TYPE_RETURN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					gchar _tmp19_;
					_tmp19_ = begin[1];
					switch (_tmp19_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "sealed")) {
								result = VALA_GENIE_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "sizeof")) {
								result = VALA_GENIE_TOKEN_TYPE_SIZEOF;
								return result;
							}
							break;
						}
						case 't':
						{
							gchar _tmp20_;
							_tmp20_ = begin[2];
							switch (_tmp20_) {
								case 'a':
								{
									if (vala_genie_scanner_matches (begin, "static")) {
										result = VALA_GENIE_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									if (vala_genie_scanner_matches (begin, "struct")) {
										result = VALA_GENIE_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "typeof")) {
						result = VALA_GENIE_TOKEN_TYPE_TYPEOF;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar _tmp21_;
			_tmp21_ = begin[0];
			switch (_tmp21_) {
				case 'd':
				{
					gchar _tmp22_;
					_tmp22_ = begin[1];
					switch (_tmp22_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "default")) {
								result = VALA_GENIE_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_genie_scanner_matches (begin, "dynamic")) {
								result = VALA_GENIE_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "ensures")) {
						result = VALA_GENIE_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp23_;
					_tmp23_ = begin[1];
					switch (_tmp23_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "finally")) {
								result = VALA_GENIE_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "private")) {
						result = VALA_GENIE_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "unowned")) {
						result = VALA_GENIE_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "virtual")) {
						result = VALA_GENIE_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar _tmp24_;
			_tmp24_ = begin[0];
			switch (_tmp24_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "abstract")) {
						result = VALA_GENIE_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "continue")) {
						result = VALA_GENIE_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "delegate")) {
						result = VALA_GENIE_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "internal")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "override")) {
						result = VALA_GENIE_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp25_;
					_tmp25_ = begin[2];
					switch (_tmp25_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "readonly")) {
								result = VALA_GENIE_TOKEN_TYPE_READONLY;
								return result;
							}
							break;
						}
						case 'q':
						{
							if (vala_genie_scanner_matches (begin, "requires")) {
								result = VALA_GENIE_TOKEN_TYPE_REQUIRES;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "volatile")) {
						result = VALA_GENIE_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar _tmp26_;
			_tmp26_ = begin[0];
			switch (_tmp26_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "construct")) {
						result = VALA_GENIE_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "exception")) {
						result = VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "interface")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "namespace")) {
						result = VALA_GENIE_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "protected")) {
						result = VALA_GENIE_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 10:
		{
			gchar _tmp27_;
			_tmp27_ = begin[0];
			switch (_tmp27_) {
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "implements")) {
						result = VALA_GENIE_TOKEN_TYPE_IMPLEMENTS;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
	return result;
}

static void
_vala_array_add3 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add4 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add5 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add6 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaGenieTokenType
vala_genie_scanner_read_template_token (ValaGenieScanner* self,
                                        ValaSourceLocation* token_begin,
                                        ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint token_length_in_chars = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp110_;
	ValaGenieTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	_tmp2_ = self->priv->current;
	_tmp3_ = self->priv->end;
	if (_tmp2_ >= _tmp3_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		switch (_tmp5_) {
			case '"':
			{
				gchar* _tmp6_;
				gint _tmp7_;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp6_ = self->priv->current;
				self->priv->current = _tmp6_ + 1;
				_tmp7_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp7_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar _tmp12_;
				_tmp8_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp8_ + 1;
				_tmp9_ = self->priv->current;
				self->priv->current = _tmp9_ + 1;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_[0];
				if (g_ascii_isalpha (_tmp12_)) {
					_tmp10_ = TRUE;
				} else {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == '_';
				}
				if (_tmp10_) {
					gint len = 0;
					len = 0;
					while (TRUE) {
						gboolean _tmp15_ = FALSE;
						gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp20_;
						gint _tmp21_;
						_tmp16_ = self->priv->current;
						_tmp17_ = self->priv->end;
						if (_tmp16_ < _tmp17_) {
							gchar* _tmp18_;
							gchar _tmp19_;
							_tmp18_ = self->priv->current;
							_tmp19_ = _tmp18_[0];
							_tmp15_ = vala_genie_scanner_is_ident_char (self, _tmp19_);
						} else {
							_tmp15_ = FALSE;
						}
						if (!_tmp15_) {
							break;
						}
						_tmp20_ = self->priv->current;
						self->priv->current = _tmp20_ + 1;
						_tmp21_ = len;
						len = _tmp21_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
					_vala_array_add3 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp22_;
					gchar _tmp23_;
					_tmp22_ = self->priv->current;
					_tmp23_ = _tmp22_[0];
					if (_tmp23_ == '(') {
						gchar* _tmp24_;
						ValaSourceLocation _tmp25_ = {0};
						ValaSourceLocation _tmp26_ = {0};
						ValaGenieTokenType _tmp27_;
						_tmp24_ = self->priv->current;
						self->priv->current = _tmp24_ + 1;
						self->priv->column = self->priv->column + 2;
						_vala_array_add4 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
						_tmp27_ = vala_genie_scanner_read_token (self, &_tmp25_, &_tmp26_);
						_vala_token_begin = _tmp25_;
						_vala_token_end = _tmp26_;
						result = _tmp27_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp28_;
						gchar _tmp29_;
						_tmp28_ = self->priv->current;
						_tmp29_ = _tmp28_[0];
						if (_tmp29_ == '$') {
							gchar* _tmp30_;
							type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp30_ = self->priv->current;
							self->priv->current = _tmp30_ + 1;
							_vala_array_add5 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp31_;
							ValaSourceReference* _tmp32_;
							ValaSourceLocation _tmp33_ = {0};
							ValaSourceLocation _tmp34_ = {0};
							ValaGenieTokenType _tmp35_;
							_tmp31_ = vala_genie_scanner_get_source_reference (self, 1, 0);
							_tmp32_ = _tmp31_;
							vala_report_error (_tmp32_, "unexpected character");
							_vala_source_reference_unref0 (_tmp32_);
							_tmp35_ = vala_genie_scanner_read_template_token (self, &_tmp33_, &_tmp34_);
							_vala_token_begin = _tmp33_;
							_vala_token_end = _tmp34_;
							result = _tmp35_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp100_;
				gchar* _tmp101_;
				type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp36_ = FALSE;
					gboolean _tmp37_ = FALSE;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp44_;
					gchar _tmp45_;
					_tmp38_ = self->priv->current;
					_tmp39_ = self->priv->end;
					if (_tmp38_ < _tmp39_) {
						gchar* _tmp40_;
						gchar _tmp41_;
						_tmp40_ = self->priv->current;
						_tmp41_ = _tmp40_[0];
						_tmp37_ = _tmp41_ != '"';
					} else {
						_tmp37_ = FALSE;
					}
					if (_tmp37_) {
						gchar* _tmp42_;
						gchar _tmp43_;
						_tmp42_ = self->priv->current;
						_tmp43_ = _tmp42_[0];
						_tmp36_ = _tmp43_ != '$';
					} else {
						_tmp36_ = FALSE;
					}
					if (!_tmp36_) {
						break;
					}
					_tmp44_ = self->priv->current;
					_tmp45_ = _tmp44_[0];
					if (_tmp45_ == '\\') {
						gchar* _tmp46_;
						gint _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gchar _tmp51_;
						_tmp46_ = self->priv->current;
						self->priv->current = _tmp46_ + 1;
						_tmp47_ = token_length_in_chars;
						token_length_in_chars = _tmp47_ + 1;
						_tmp48_ = self->priv->current;
						_tmp49_ = self->priv->end;
						if (_tmp48_ >= _tmp49_) {
							break;
						}
						_tmp50_ = self->priv->current;
						_tmp51_ = _tmp50_[0];
						switch (_tmp51_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'v':
							{
								gchar* _tmp52_;
								gint _tmp53_;
								_tmp52_ = self->priv->current;
								self->priv->current = _tmp52_ + 1;
								_tmp53_ = token_length_in_chars;
								token_length_in_chars = _tmp53_ + 1;
								break;
							}
							case 'u':
							{
								gchar* _tmp54_;
								gint _tmp55_;
								gint digit_length = 0;
								_tmp54_ = self->priv->current;
								self->priv->current = _tmp54_ + 1;
								_tmp55_ = token_length_in_chars;
								token_length_in_chars = _tmp55_ + 1;
								{
									gboolean _tmp56_ = FALSE;
									digit_length = 0;
									_tmp56_ = TRUE;
									while (TRUE) {
										gboolean _tmp58_ = FALSE;
										gchar* _tmp59_;
										gchar* _tmp60_;
										gchar* _tmp63_;
										gint _tmp64_;
										if (!_tmp56_) {
											gint _tmp57_;
											_tmp57_ = digit_length;
											digit_length = _tmp57_ + 1;
										}
										_tmp56_ = FALSE;
										_tmp59_ = self->priv->current;
										_tmp60_ = self->priv->end;
										if (_tmp59_ < _tmp60_) {
											gchar* _tmp61_;
											gchar _tmp62_;
											_tmp61_ = self->priv->current;
											_tmp62_ = _tmp61_[0];
											_tmp58_ = g_ascii_isxdigit (_tmp62_);
										} else {
											_tmp58_ = FALSE;
										}
										if (!_tmp58_) {
											break;
										}
										_tmp63_ = self->priv->current;
										self->priv->current = _tmp63_ + 1;
										_tmp64_ = token_length_in_chars;
										token_length_in_chars = _tmp64_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp65_;
									ValaSourceReference* _tmp66_;
									_tmp65_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp66_ = _tmp65_;
									vala_report_error (_tmp66_, "\\u used with no following hex digits");
									_vala_source_reference_unref0 (_tmp66_);
								} else {
									if (digit_length < 4) {
										ValaSourceReference* _tmp67_;
										ValaSourceReference* _tmp68_;
										_tmp67_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp68_ = _tmp67_;
										vala_report_error (_tmp68_, "incomplete universal character name");
										_vala_source_reference_unref0 (_tmp68_);
									}
								}
								break;
							}
							case 'x':
							{
								gchar* _tmp69_;
								gint _tmp70_;
								gint digit_length = 0;
								_tmp69_ = self->priv->current;
								self->priv->current = _tmp69_ + 1;
								_tmp70_ = token_length_in_chars;
								token_length_in_chars = _tmp70_ + 1;
								{
									gboolean _tmp71_ = FALSE;
									digit_length = 0;
									_tmp71_ = TRUE;
									while (TRUE) {
										gboolean _tmp72_ = FALSE;
										gchar* _tmp73_;
										gchar* _tmp74_;
										gchar* _tmp77_;
										gchar _tmp78_;
										gchar* _tmp80_;
										gint _tmp81_;
										if (!_tmp71_) {
										}
										_tmp71_ = FALSE;
										_tmp73_ = self->priv->current;
										_tmp74_ = self->priv->end;
										if (_tmp73_ < _tmp74_) {
											gchar* _tmp75_;
											gchar _tmp76_;
											_tmp75_ = self->priv->current;
											_tmp76_ = _tmp75_[0];
											_tmp72_ = g_ascii_isxdigit (_tmp76_);
										} else {
											_tmp72_ = FALSE;
										}
										if (!_tmp72_) {
											break;
										}
										_tmp77_ = self->priv->current;
										_tmp78_ = _tmp77_[0];
										if (_tmp78_ != '0') {
											gint _tmp79_;
											_tmp79_ = digit_length;
											digit_length = _tmp79_ + 1;
										}
										_tmp80_ = self->priv->current;
										self->priv->current = _tmp80_ + 1;
										_tmp81_ = token_length_in_chars;
										token_length_in_chars = _tmp81_ + 1;
									}
								}
								if (digit_length < 1) {
									ValaSourceReference* _tmp82_;
									ValaSourceReference* _tmp83_;
									_tmp82_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp83_ = _tmp82_;
									vala_report_error (_tmp83_, "\\x used with no following hex digits");
									_vala_source_reference_unref0 (_tmp83_);
								} else {
									if (digit_length > 2) {
										ValaSourceReference* _tmp84_;
										ValaSourceReference* _tmp85_;
										_tmp84_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp85_ = _tmp84_;
										vala_report_error (_tmp85_, "hex escape sequence out of range");
										_vala_source_reference_unref0 (_tmp85_);
									}
								}
								break;
							}
							default:
							{
								ValaSourceReference* _tmp86_;
								ValaSourceReference* _tmp87_;
								_tmp86_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp87_ = _tmp86_;
								vala_report_error (_tmp87_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp87_);
								break;
							}
						}
					} else {
						gchar* _tmp88_;
						gchar _tmp89_;
						_tmp88_ = self->priv->current;
						_tmp89_ = _tmp88_[0];
						if (_tmp89_ == '\n') {
							gchar* _tmp90_;
							gint _tmp91_;
							_tmp90_ = self->priv->current;
							self->priv->current = _tmp90_ + 1;
							_tmp91_ = self->priv->line;
							self->priv->line = _tmp91_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u = 0U;
							gchar* _tmp92_;
							gchar* _tmp93_;
							gchar* _tmp94_;
							_tmp92_ = self->priv->current;
							_tmp93_ = self->priv->end;
							_tmp94_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp92_, (gssize) ((glong) (_tmp93_ - _tmp94_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp95_;
								gint _tmp96_;
								_tmp95_ = self->priv->current;
								self->priv->current = _tmp95_ + g_unichar_to_utf8 (u, NULL);
								_tmp96_ = token_length_in_chars;
								token_length_in_chars = _tmp96_ + 1;
							} else {
								gchar* _tmp97_;
								ValaSourceReference* _tmp98_;
								ValaSourceReference* _tmp99_;
								_tmp97_ = self->priv->current;
								self->priv->current = _tmp97_ + 1;
								_tmp98_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp99_ = _tmp98_;
								vala_report_error (_tmp99_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp99_);
							}
						}
					}
				}
				_tmp100_ = self->priv->current;
				_tmp101_ = self->priv->end;
				if (_tmp100_ >= _tmp101_) {
					ValaSourceReference* _tmp102_;
					ValaSourceReference* _tmp103_;
					gint _tmp104_;
					ValaSourceLocation _tmp105_ = {0};
					ValaSourceLocation _tmp106_ = {0};
					ValaGenieTokenType _tmp107_;
					_tmp102_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
					_tmp103_ = _tmp102_;
					vala_report_error (_tmp103_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp103_);
					_tmp104_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp104_ - 1;
					_tmp107_ = vala_genie_scanner_read_token (self, &_tmp105_, &_tmp106_);
					_vala_token_begin = _tmp105_;
					_vala_token_end = _tmp106_;
					result = _tmp107_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_vala_array_add6 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp108_;
		gchar* _tmp109_;
		_tmp108_ = self->priv->current;
		_tmp109_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp108_ - _tmp109_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp110_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp110_, self->priv->line, self->priv->column - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static void
_vala_array_add7 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add8 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add9 (ValaGenieScannerState* * array,
                  gint* length,
                  gint* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add10 (ValaGenieScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add11 (ValaGenieScannerState* * array,
                   gint* length,
                   gint* size,
                   ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}

ValaGenieTokenType
vala_genie_scanner_read_token (ValaGenieScanner* self,
                               ValaSourceLocation* token_begin,
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	gchar* _tmp0_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gint token_length_in_chars = 0;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp459_;
	ValaGenieTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp1_, self->priv->line, self->priv->column);
		_tmp2_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp2_, self->priv->line, self->priv->column);
		result = VALA_GENIE_TOKEN_TYPE_EOF;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	if (vala_genie_scanner_in_template (self)) {
		ValaSourceLocation _tmp3_ = {0};
		ValaSourceLocation _tmp4_ = {0};
		ValaGenieTokenType _tmp5_;
		_tmp5_ = vala_genie_scanner_read_template_token (self, &_tmp3_, &_tmp4_);
		_vala_token_begin = _tmp3_;
		_vala_token_end = _tmp4_;
		result = _tmp5_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		if (vala_genie_scanner_in_template_part (self)) {
			gint _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp6_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp6_ - 1;
			_tmp7_ = self->priv->current;
			vala_source_location_init (&_vala_token_begin, _tmp7_, self->priv->line, self->priv->column);
			_tmp8_ = self->priv->current;
			vala_source_location_init (&_vala_token_end, _tmp8_, self->priv->line, self->priv->column - 1);
			result = VALA_GENIE_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (vala_genie_scanner_in_regex_literal (self)) {
				ValaSourceLocation _tmp9_ = {0};
				ValaSourceLocation _tmp10_ = {0};
				ValaGenieTokenType _tmp11_;
				_tmp11_ = vala_genie_scanner_read_regex_token (self, &_tmp9_, &_tmp10_);
				_vala_token_begin = _tmp9_;
				_vala_token_end = _tmp10_;
				result = _tmp11_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	if (self->priv->pending_dedents > 0) {
		gint _tmp12_;
		gint _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = self->priv->pending_dedents;
		self->priv->pending_dedents = _tmp12_ - 1;
		_tmp13_ = self->priv->indent_level;
		self->priv->indent_level = _tmp13_ - 1;
		_tmp14_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp14_, self->priv->line, self->priv->column);
		_tmp15_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp15_, self->priv->line, self->priv->column);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
		result = VALA_GENIE_TOKEN_TYPE_DEDENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	if (self->priv->_indent_spaces == 0) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp16_) {
		vala_genie_scanner_space (self);
	}
	while (TRUE) {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp25_;
		gint _tmp26_;
		_tmp19_ = self->priv->current;
		_tmp20_ = self->priv->end;
		if (_tmp19_ < _tmp20_) {
			gchar* _tmp21_;
			gchar _tmp22_;
			_tmp21_ = self->priv->current;
			_tmp22_ = _tmp21_[0];
			_tmp18_ = _tmp22_ == '\\';
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			gchar* _tmp23_;
			gchar _tmp24_;
			_tmp23_ = self->priv->current;
			_tmp24_ = _tmp23_[1];
			_tmp17_ = _tmp24_ == '\n';
		} else {
			_tmp17_ = FALSE;
		}
		if (!_tmp17_) {
			break;
		}
		_tmp25_ = self->priv->current;
		self->priv->current = _tmp25_ + 2;
		_tmp26_ = self->priv->line;
		self->priv->line = _tmp26_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp34_;
		gint _tmp35_;
		_tmp29_ = self->priv->current;
		_tmp30_ = self->priv->end;
		if (_tmp29_ < _tmp30_) {
			gchar* _tmp31_;
			gchar _tmp32_;
			_tmp31_ = self->priv->current;
			_tmp32_ = _tmp31_[0];
			_tmp28_ = _tmp32_ == '\n';
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			gboolean _tmp33_ = FALSE;
			if (self->priv->open_parens_count > 0) {
				_tmp33_ = TRUE;
			} else {
				_tmp33_ = self->priv->open_brace_count > 0;
			}
			_tmp27_ = _tmp33_;
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp34_ = self->priv->current;
		self->priv->current = _tmp34_ + 1;
		_tmp35_ = self->priv->line;
		self->priv->line = _tmp35_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	if (vala_genie_scanner_newline (self)) {
		_tmp38_ = self->priv->parse_started;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		_tmp37_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_tmp36_ = self->priv->last_token != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		gchar* _tmp39_;
		gchar* _tmp40_;
		_tmp39_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp39_, self->priv->line, self->priv->column);
		_tmp40_ = self->priv->current;
		vala_source_location_init (&_vala_token_end, _tmp40_, self->priv->line, self->priv->column);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_EOL;
		result = VALA_GENIE_TOKEN_TYPE_EOL;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	while (TRUE) {
		gchar* _tmp41_;
		if (!vala_genie_scanner_skip_newlines (self)) {
			break;
		}
		_tmp41_ = self->priv->current;
		vala_source_location_init (&_vala_token_begin, _tmp41_, self->priv->line, self->priv->column);
		self->priv->current_indent_level = vala_genie_scanner_count_tabs (self);
		if (self->priv->current_indent_level == -1) {
			continue;
		}
		if (self->priv->current_indent_level > self->priv->indent_level) {
			gchar* _tmp42_;
			self->priv->indent_level = self->priv->current_indent_level;
			_tmp42_ = self->priv->current;
			vala_source_location_init (&_vala_token_end, _tmp42_, self->priv->line, self->priv->column);
			self->priv->last_token = VALA_GENIE_TOKEN_TYPE_INDENT;
			result = VALA_GENIE_TOKEN_TYPE_INDENT;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (self->priv->current_indent_level < self->priv->indent_level) {
				gint _tmp43_;
				gchar* _tmp44_;
				_tmp43_ = self->priv->indent_level;
				self->priv->indent_level = _tmp43_ - 1;
				self->priv->pending_dedents = self->priv->indent_level - self->priv->current_indent_level;
				_tmp44_ = self->priv->current;
				vala_source_location_init (&_vala_token_end, _tmp44_, self->priv->line, self->priv->column);
				self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
				result = VALA_GENIE_TOKEN_TYPE_DEDENT;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	_tmp45_ = self->priv->current;
	begin = _tmp45_;
	_tmp46_ = begin;
	vala_source_location_init (&_vala_token_begin, _tmp46_, self->priv->line, self->priv->column);
	token_length_in_chars = -1;
	self->priv->parse_started = TRUE;
	_tmp47_ = self->priv->current;
	_tmp48_ = self->priv->end;
	if (_tmp47_ >= _tmp48_) {
		if (self->priv->indent_level > 0) {
			gint _tmp49_;
			_tmp49_ = self->priv->indent_level;
			self->priv->indent_level = _tmp49_ - 1;
			self->priv->pending_dedents = self->priv->indent_level;
			type = VALA_GENIE_TOKEN_TYPE_DEDENT;
		} else {
			type = VALA_GENIE_TOKEN_TYPE_EOF;
		}
	} else {
		gboolean _tmp50_ = FALSE;
		gchar* _tmp51_;
		gchar _tmp52_;
		_tmp51_ = self->priv->current;
		_tmp52_ = _tmp51_[0];
		if (g_ascii_isalpha (_tmp52_)) {
			_tmp50_ = TRUE;
		} else {
			gchar* _tmp53_;
			gchar _tmp54_;
			_tmp53_ = self->priv->current;
			_tmp54_ = _tmp53_[0];
			_tmp50_ = _tmp54_ == '_';
		}
		if (_tmp50_) {
			gint len = 0;
			gchar* _tmp62_;
			len = 0;
			while (TRUE) {
				gboolean _tmp55_ = FALSE;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp60_;
				gint _tmp61_;
				_tmp56_ = self->priv->current;
				_tmp57_ = self->priv->end;
				if (_tmp56_ < _tmp57_) {
					gchar* _tmp58_;
					gchar _tmp59_;
					_tmp58_ = self->priv->current;
					_tmp59_ = _tmp58_[0];
					_tmp55_ = vala_genie_scanner_is_ident_char (self, _tmp59_);
				} else {
					_tmp55_ = FALSE;
				}
				if (!_tmp55_) {
					break;
				}
				_tmp60_ = self->priv->current;
				self->priv->current = _tmp60_ + 1;
				_tmp61_ = len;
				len = _tmp61_ + 1;
			}
			_tmp62_ = begin;
			type = vala_genie_scanner_get_identifier_or_keyword (_tmp62_, len);
		} else {
			gchar* _tmp63_;
			gchar _tmp64_;
			_tmp63_ = self->priv->current;
			_tmp64_ = _tmp63_[0];
			if (_tmp64_ == '@') {
				gboolean _tmp65_ = FALSE;
				gchar* _tmp66_;
				gchar* _tmp67_;
				_tmp66_ = self->priv->current;
				_tmp67_ = self->priv->end;
				if (_tmp66_ < (_tmp67_ - 1)) {
					gchar* _tmp68_;
					gchar _tmp69_;
					_tmp68_ = self->priv->current;
					_tmp69_ = _tmp68_[1];
					_tmp65_ = _tmp69_ == '"';
				} else {
					_tmp65_ = FALSE;
				}
				if (_tmp65_) {
					gchar* _tmp70_;
					type = VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp70_ = self->priv->current;
					self->priv->current = _tmp70_ + 2;
					_vala_array_add7 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp71_;
					gchar* _tmp72_;
					gint len = 0;
					_tmp71_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp71_ + 1;
					_tmp72_ = self->priv->current;
					self->priv->current = _tmp72_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp73_ = FALSE;
						gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp78_;
						gint _tmp79_;
						_tmp74_ = self->priv->current;
						_tmp75_ = self->priv->end;
						if (_tmp74_ < _tmp75_) {
							gchar* _tmp76_;
							gchar _tmp77_;
							_tmp76_ = self->priv->current;
							_tmp77_ = _tmp76_[0];
							_tmp73_ = vala_genie_scanner_is_ident_char (self, _tmp77_);
						} else {
							_tmp73_ = FALSE;
						}
						if (!_tmp73_) {
							break;
						}
						_tmp78_ = self->priv->current;
						self->priv->current = _tmp78_ + 1;
						_tmp79_ = len;
						len = _tmp79_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp80_;
				gchar _tmp81_;
				_tmp80_ = self->priv->current;
				_tmp81_ = _tmp80_[0];
				if (g_ascii_isdigit (_tmp81_)) {
					gboolean _tmp88_ = FALSE;
					gchar* _tmp89_;
					gchar* _tmp90_;
					while (TRUE) {
						gboolean _tmp82_ = FALSE;
						gchar* _tmp83_;
						gchar* _tmp84_;
						gchar* _tmp87_;
						_tmp83_ = self->priv->current;
						_tmp84_ = self->priv->end;
						if (_tmp83_ < _tmp84_) {
							gchar* _tmp85_;
							gchar _tmp86_;
							_tmp85_ = self->priv->current;
							_tmp86_ = _tmp85_[0];
							_tmp82_ = g_ascii_isdigit (_tmp86_);
						} else {
							_tmp82_ = FALSE;
						}
						if (!_tmp82_) {
							break;
						}
						_tmp87_ = self->priv->current;
						self->priv->current = _tmp87_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL;
					_tmp89_ = self->priv->current;
					_tmp90_ = self->priv->end;
					if (_tmp89_ < _tmp90_) {
						gchar* _tmp91_;
						gchar _tmp92_;
						_tmp91_ = self->priv->current;
						_tmp92_ = _tmp91_[0];
						_tmp88_ = g_ascii_tolower (_tmp92_) == 'l';
					} else {
						_tmp88_ = FALSE;
					}
					if (_tmp88_) {
						gchar* _tmp93_;
						gboolean _tmp94_ = FALSE;
						gchar* _tmp95_;
						gchar* _tmp96_;
						_tmp93_ = self->priv->current;
						self->priv->current = _tmp93_ + 1;
						_tmp95_ = self->priv->current;
						_tmp96_ = self->priv->end;
						if (_tmp95_ < _tmp96_) {
							gchar* _tmp97_;
							gchar _tmp98_;
							_tmp97_ = self->priv->current;
							_tmp98_ = _tmp97_[0];
							_tmp94_ = g_ascii_tolower (_tmp98_) == 'l';
						} else {
							_tmp94_ = FALSE;
						}
						if (_tmp94_) {
							gchar* _tmp99_;
							_tmp99_ = self->priv->current;
							self->priv->current = _tmp99_ + 1;
						}
					} else {
						gboolean _tmp100_ = FALSE;
						gchar* _tmp101_;
						gchar* _tmp102_;
						_tmp101_ = self->priv->current;
						_tmp102_ = self->priv->end;
						if (_tmp101_ < _tmp102_) {
							gchar* _tmp103_;
							gchar _tmp104_;
							_tmp103_ = self->priv->current;
							_tmp104_ = _tmp103_[0];
							_tmp100_ = g_ascii_tolower (_tmp104_) == 'u';
						} else {
							_tmp100_ = FALSE;
						}
						if (_tmp100_) {
							gchar* _tmp105_;
							gboolean _tmp106_ = FALSE;
							gchar* _tmp107_;
							gchar* _tmp108_;
							_tmp105_ = self->priv->current;
							self->priv->current = _tmp105_ + 1;
							_tmp107_ = self->priv->current;
							_tmp108_ = self->priv->end;
							if (_tmp107_ < _tmp108_) {
								gchar* _tmp109_;
								gchar _tmp110_;
								_tmp109_ = self->priv->current;
								_tmp110_ = _tmp109_[0];
								_tmp106_ = g_ascii_tolower (_tmp110_) == 'l';
							} else {
								_tmp106_ = FALSE;
							}
							if (_tmp106_) {
								gchar* _tmp111_;
								gboolean _tmp112_ = FALSE;
								gchar* _tmp113_;
								gchar* _tmp114_;
								_tmp111_ = self->priv->current;
								self->priv->current = _tmp111_ + 1;
								_tmp113_ = self->priv->current;
								_tmp114_ = self->priv->end;
								if (_tmp113_ < _tmp114_) {
									gchar* _tmp115_;
									gchar _tmp116_;
									_tmp115_ = self->priv->current;
									_tmp116_ = _tmp115_[0];
									_tmp112_ = g_ascii_tolower (_tmp116_) == 'l';
								} else {
									_tmp112_ = FALSE;
								}
								if (_tmp112_) {
									gchar* _tmp117_;
									_tmp117_ = self->priv->current;
									self->priv->current = _tmp117_ + 1;
								}
							}
						} else {
							gboolean _tmp118_ = FALSE;
							gboolean _tmp119_ = FALSE;
							gchar* _tmp120_;
							gchar* _tmp121_;
							_tmp120_ = self->priv->current;
							_tmp121_ = self->priv->end;
							if (_tmp120_ < (_tmp121_ - 1)) {
								gchar* _tmp122_;
								gchar _tmp123_;
								_tmp122_ = self->priv->current;
								_tmp123_ = _tmp122_[0];
								_tmp119_ = _tmp123_ == '.';
							} else {
								_tmp119_ = FALSE;
							}
							if (_tmp119_) {
								gchar* _tmp124_;
								gchar _tmp125_;
								_tmp124_ = self->priv->current;
								_tmp125_ = _tmp124_[1];
								_tmp118_ = g_ascii_isdigit (_tmp125_);
							} else {
								_tmp118_ = FALSE;
							}
							if (_tmp118_) {
								gchar* _tmp126_;
								gboolean _tmp133_ = FALSE;
								gchar* _tmp134_;
								gchar* _tmp135_;
								gboolean _tmp154_ = FALSE;
								gchar* _tmp155_;
								gchar* _tmp156_;
								_tmp126_ = self->priv->current;
								self->priv->current = _tmp126_ + 1;
								while (TRUE) {
									gboolean _tmp127_ = FALSE;
									gchar* _tmp128_;
									gchar* _tmp129_;
									gchar* _tmp132_;
									_tmp128_ = self->priv->current;
									_tmp129_ = self->priv->end;
									if (_tmp128_ < _tmp129_) {
										gchar* _tmp130_;
										gchar _tmp131_;
										_tmp130_ = self->priv->current;
										_tmp131_ = _tmp130_[0];
										_tmp127_ = g_ascii_isdigit (_tmp131_);
									} else {
										_tmp127_ = FALSE;
									}
									if (!_tmp127_) {
										break;
									}
									_tmp132_ = self->priv->current;
									self->priv->current = _tmp132_ + 1;
								}
								_tmp134_ = self->priv->current;
								_tmp135_ = self->priv->end;
								if (_tmp134_ < _tmp135_) {
									gchar* _tmp136_;
									gchar _tmp137_;
									_tmp136_ = self->priv->current;
									_tmp137_ = _tmp136_[0];
									_tmp133_ = g_ascii_tolower (_tmp137_) == 'e';
								} else {
									_tmp133_ = FALSE;
								}
								if (_tmp133_) {
									gchar* _tmp138_;
									gboolean _tmp139_ = FALSE;
									gchar* _tmp140_;
									gchar* _tmp141_;
									_tmp138_ = self->priv->current;
									self->priv->current = _tmp138_ + 1;
									_tmp140_ = self->priv->current;
									_tmp141_ = self->priv->end;
									if (_tmp140_ < _tmp141_) {
										gboolean _tmp142_ = FALSE;
										gchar* _tmp143_;
										gchar _tmp144_;
										_tmp143_ = self->priv->current;
										_tmp144_ = _tmp143_[0];
										if (_tmp144_ == '+') {
											_tmp142_ = TRUE;
										} else {
											gchar* _tmp145_;
											gchar _tmp146_;
											_tmp145_ = self->priv->current;
											_tmp146_ = _tmp145_[0];
											_tmp142_ = _tmp146_ == '-';
										}
										_tmp139_ = _tmp142_;
									} else {
										_tmp139_ = FALSE;
									}
									if (_tmp139_) {
										gchar* _tmp147_;
										_tmp147_ = self->priv->current;
										self->priv->current = _tmp147_ + 1;
									}
									while (TRUE) {
										gboolean _tmp148_ = FALSE;
										gchar* _tmp149_;
										gchar* _tmp150_;
										gchar* _tmp153_;
										_tmp149_ = self->priv->current;
										_tmp150_ = self->priv->end;
										if (_tmp149_ < _tmp150_) {
											gchar* _tmp151_;
											gchar _tmp152_;
											_tmp151_ = self->priv->current;
											_tmp152_ = _tmp151_[0];
											_tmp148_ = g_ascii_isdigit (_tmp152_);
										} else {
											_tmp148_ = FALSE;
										}
										if (!_tmp148_) {
											break;
										}
										_tmp153_ = self->priv->current;
										self->priv->current = _tmp153_ + 1;
									}
								}
								_tmp155_ = self->priv->current;
								_tmp156_ = self->priv->end;
								if (_tmp155_ < _tmp156_) {
									gchar* _tmp157_;
									gchar _tmp158_;
									_tmp157_ = self->priv->current;
									_tmp158_ = _tmp157_[0];
									_tmp154_ = g_ascii_tolower (_tmp158_) == 'f';
								} else {
									_tmp154_ = FALSE;
								}
								if (_tmp154_) {
									gchar* _tmp159_;
									_tmp159_ = self->priv->current;
									self->priv->current = _tmp159_ + 1;
								}
								type = VALA_GENIE_TOKEN_TYPE_REAL_LITERAL;
							} else {
								gboolean _tmp160_ = FALSE;
								gboolean _tmp161_ = FALSE;
								gboolean _tmp162_ = FALSE;
								gboolean _tmp163_ = FALSE;
								gchar* _tmp164_;
								gchar* _tmp165_;
								_tmp164_ = self->priv->current;
								_tmp165_ = self->priv->end;
								if (_tmp164_ < _tmp165_) {
									gchar* _tmp166_;
									gchar* _tmp167_;
									_tmp166_ = self->priv->current;
									_tmp167_ = begin;
									_tmp163_ = _tmp166_ == (_tmp167_ + 1);
								} else {
									_tmp163_ = FALSE;
								}
								if (_tmp163_) {
									gchar* _tmp168_;
									gchar _tmp169_;
									_tmp168_ = begin;
									_tmp169_ = _tmp168_[0];
									_tmp162_ = _tmp169_ == '0';
								} else {
									_tmp162_ = FALSE;
								}
								if (_tmp162_) {
									gchar* _tmp170_;
									gchar _tmp171_;
									_tmp170_ = begin;
									_tmp171_ = _tmp170_[1];
									_tmp161_ = _tmp171_ == 'x';
								} else {
									_tmp161_ = FALSE;
								}
								if (_tmp161_) {
									gchar* _tmp172_;
									gchar _tmp173_;
									_tmp172_ = begin;
									_tmp173_ = _tmp172_[2];
									_tmp160_ = g_ascii_isxdigit (_tmp173_);
								} else {
									_tmp160_ = FALSE;
								}
								if (_tmp160_) {
									gchar* _tmp174_;
									_tmp174_ = self->priv->current;
									self->priv->current = _tmp174_ + 1;
									while (TRUE) {
										gboolean _tmp175_ = FALSE;
										gchar* _tmp176_;
										gchar* _tmp177_;
										gchar* _tmp180_;
										_tmp176_ = self->priv->current;
										_tmp177_ = self->priv->end;
										if (_tmp176_ < _tmp177_) {
											gchar* _tmp178_;
											gchar _tmp179_;
											_tmp178_ = self->priv->current;
											_tmp179_ = _tmp178_[0];
											_tmp175_ = g_ascii_isxdigit (_tmp179_);
										} else {
											_tmp175_ = FALSE;
										}
										if (!_tmp175_) {
											break;
										}
										_tmp180_ = self->priv->current;
										self->priv->current = _tmp180_ + 1;
									}
								} else {
									gboolean _tmp181_ = FALSE;
									gchar* _tmp182_;
									gchar* _tmp183_;
									_tmp182_ = self->priv->current;
									_tmp183_ = self->priv->end;
									if (_tmp182_ < _tmp183_) {
										gchar* _tmp184_;
										gchar _tmp185_;
										_tmp184_ = self->priv->current;
										_tmp185_ = _tmp184_[0];
										_tmp181_ = vala_genie_scanner_is_ident_char (self, _tmp185_);
									} else {
										_tmp181_ = FALSE;
									}
									if (_tmp181_) {
										while (TRUE) {
											gboolean _tmp186_ = FALSE;
											gchar* _tmp187_;
											gchar* _tmp188_;
											gchar* _tmp191_;
											_tmp187_ = self->priv->current;
											_tmp188_ = self->priv->end;
											if (_tmp187_ < _tmp188_) {
												gchar* _tmp189_;
												gchar _tmp190_;
												_tmp189_ = self->priv->current;
												_tmp190_ = _tmp189_[0];
												_tmp186_ = vala_genie_scanner_is_ident_char (self, _tmp190_);
											} else {
												_tmp186_ = FALSE;
											}
											if (!_tmp186_) {
												break;
											}
											_tmp191_ = self->priv->current;
											self->priv->current = _tmp191_ + 1;
										}
										type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
									}
								}
							}
						}
					}
				} else {
					gchar* _tmp192_;
					gchar _tmp193_;
					_tmp192_ = self->priv->current;
					_tmp193_ = _tmp192_[0];
					switch (_tmp193_) {
						case '{':
						{
							gint _tmp194_;
							gchar* _tmp195_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACE;
							_tmp194_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp194_ + 1;
							_vala_array_add8 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACE);
							_tmp195_ = self->priv->current;
							self->priv->current = _tmp195_ + 1;
							break;
						}
						case '}':
						{
							gint _tmp196_;
							ValaGenieScannerState* _tmp197_;
							gint _tmp197__length1;
							gchar* _tmp199_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE;
							_tmp196_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp196_ - 1;
							_tmp197_ = self->priv->state_stack;
							_tmp197__length1 = self->priv->state_stack_length1;
							if (_tmp197__length1 > 0) {
								gint _tmp198_;
								_tmp198_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp198_ - 1;
							}
							_tmp199_ = self->priv->current;
							self->priv->current = _tmp199_ + 1;
							break;
						}
						case '(':
						{
							gint _tmp200_;
							gchar* _tmp201_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_PARENS;
							_tmp200_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp200_ + 1;
							_vala_array_add9 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
							_tmp201_ = self->priv->current;
							self->priv->current = _tmp201_ + 1;
							break;
						}
						case ')':
						{
							gint _tmp202_;
							gchar* _tmp203_;
							ValaGenieScannerState* _tmp204_;
							gint _tmp204__length1;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS;
							_tmp202_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp202_ - 1;
							_tmp203_ = self->priv->current;
							self->priv->current = _tmp203_ + 1;
							_tmp204_ = self->priv->state_stack;
							_tmp204__length1 = self->priv->state_stack_length1;
							if (_tmp204__length1 > 0) {
								gint _tmp205_;
								_tmp205_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp205_ - 1;
							}
							if (vala_genie_scanner_in_template (self)) {
								type = VALA_GENIE_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							gchar* _tmp206_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET;
							_vala_array_add10 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACKET);
							_tmp206_ = self->priv->current;
							self->priv->current = _tmp206_ + 1;
							break;
						}
						case ']':
						{
							ValaGenieScannerState* _tmp207_;
							gint _tmp207__length1;
							gchar* _tmp209_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp207_ = self->priv->state_stack;
							_tmp207__length1 = self->priv->state_stack_length1;
							if (_tmp207__length1 > 0) {
								gint _tmp208_;
								_tmp208_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp208_ - 1;
							}
							_tmp209_ = self->priv->current;
							self->priv->current = _tmp209_ + 1;
							break;
						}
						case '.':
						{
							gchar* _tmp210_;
							gchar* _tmp211_;
							gchar* _tmp212_;
							type = VALA_GENIE_TOKEN_TYPE_DOT;
							_tmp210_ = self->priv->current;
							self->priv->current = _tmp210_ + 1;
							_tmp211_ = self->priv->current;
							_tmp212_ = self->priv->end;
							if (_tmp211_ < (_tmp212_ - 1)) {
								gboolean _tmp213_ = FALSE;
								gchar* _tmp214_;
								gchar _tmp215_;
								_tmp214_ = self->priv->current;
								_tmp215_ = _tmp214_[0];
								if (_tmp215_ == '.') {
									gchar* _tmp216_;
									gchar _tmp217_;
									_tmp216_ = self->priv->current;
									_tmp217_ = _tmp216_[1];
									_tmp213_ = _tmp217_ == '.';
								} else {
									_tmp213_ = FALSE;
								}
								if (_tmp213_) {
									gchar* _tmp218_;
									type = VALA_GENIE_TOKEN_TYPE_ELLIPSIS;
									_tmp218_ = self->priv->current;
									self->priv->current = _tmp218_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp219_;
							type = VALA_GENIE_TOKEN_TYPE_COLON;
							_tmp219_ = self->priv->current;
							self->priv->current = _tmp219_ + 1;
							break;
						}
						case ',':
						{
							gchar* _tmp220_;
							type = VALA_GENIE_TOKEN_TYPE_COMMA;
							_tmp220_ = self->priv->current;
							self->priv->current = _tmp220_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp221_;
							type = VALA_GENIE_TOKEN_TYPE_SEMICOLON;
							_tmp221_ = self->priv->current;
							self->priv->current = _tmp221_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp222_;
							type = VALA_GENIE_TOKEN_TYPE_HASH;
							_tmp222_ = self->priv->current;
							self->priv->current = _tmp222_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp223_;
							type = VALA_GENIE_TOKEN_TYPE_INTERR;
							_tmp223_ = self->priv->current;
							self->priv->current = _tmp223_ + 1;
							break;
						}
						case '|':
						{
							gchar* _tmp224_;
							gchar* _tmp225_;
							gchar* _tmp226_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_OR;
							_tmp224_ = self->priv->current;
							self->priv->current = _tmp224_ + 1;
							_tmp225_ = self->priv->current;
							_tmp226_ = self->priv->end;
							if (_tmp225_ < _tmp226_) {
								gchar* _tmp227_;
								gchar _tmp228_;
								_tmp227_ = self->priv->current;
								_tmp228_ = _tmp227_[0];
								switch (_tmp228_) {
									case '=':
									{
										gchar* _tmp229_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp229_ = self->priv->current;
										self->priv->current = _tmp229_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp230_;
										type = VALA_GENIE_TOKEN_TYPE_OP_OR;
										_tmp230_ = self->priv->current;
										self->priv->current = _tmp230_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp231_;
							gchar* _tmp232_;
							gchar* _tmp233_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_AND;
							_tmp231_ = self->priv->current;
							self->priv->current = _tmp231_ + 1;
							_tmp232_ = self->priv->current;
							_tmp233_ = self->priv->end;
							if (_tmp232_ < _tmp233_) {
								gchar* _tmp234_;
								gchar _tmp235_;
								_tmp234_ = self->priv->current;
								_tmp235_ = _tmp234_[0];
								switch (_tmp235_) {
									case '=':
									{
										gchar* _tmp236_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp236_ = self->priv->current;
										self->priv->current = _tmp236_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp237_;
										type = VALA_GENIE_TOKEN_TYPE_OP_AND;
										_tmp237_ = self->priv->current;
										self->priv->current = _tmp237_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp238_;
							gboolean _tmp239_ = FALSE;
							gchar* _tmp240_;
							gchar* _tmp241_;
							type = VALA_GENIE_TOKEN_TYPE_CARRET;
							_tmp238_ = self->priv->current;
							self->priv->current = _tmp238_ + 1;
							_tmp240_ = self->priv->current;
							_tmp241_ = self->priv->end;
							if (_tmp240_ < _tmp241_) {
								gchar* _tmp242_;
								gchar _tmp243_;
								_tmp242_ = self->priv->current;
								_tmp243_ = _tmp242_[0];
								_tmp239_ = _tmp243_ == '=';
							} else {
								_tmp239_ = FALSE;
							}
							if (_tmp239_) {
								gchar* _tmp244_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp244_ = self->priv->current;
								self->priv->current = _tmp244_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp245_;
							type = VALA_GENIE_TOKEN_TYPE_TILDE;
							_tmp245_ = self->priv->current;
							self->priv->current = _tmp245_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp246_;
							gchar* _tmp247_;
							gchar* _tmp248_;
							type = VALA_GENIE_TOKEN_TYPE_ASSIGN;
							_tmp246_ = self->priv->current;
							self->priv->current = _tmp246_ + 1;
							_tmp247_ = self->priv->current;
							_tmp248_ = self->priv->end;
							if (_tmp247_ < _tmp248_) {
								gchar* _tmp249_;
								gchar _tmp250_;
								_tmp249_ = self->priv->current;
								_tmp250_ = _tmp249_[0];
								switch (_tmp250_) {
									case '=':
									{
										gchar* _tmp251_;
										type = VALA_GENIE_TOKEN_TYPE_OP_EQ;
										_tmp251_ = self->priv->current;
										self->priv->current = _tmp251_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp252_;
										type = VALA_GENIE_TOKEN_TYPE_LAMBDA;
										_tmp252_ = self->priv->current;
										self->priv->current = _tmp252_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp253_;
							gchar* _tmp254_;
							gchar* _tmp255_;
							type = VALA_GENIE_TOKEN_TYPE_OP_LT;
							_tmp253_ = self->priv->current;
							self->priv->current = _tmp253_ + 1;
							_tmp254_ = self->priv->current;
							_tmp255_ = self->priv->end;
							if (_tmp254_ < _tmp255_) {
								gchar* _tmp256_;
								gchar _tmp257_;
								_tmp256_ = self->priv->current;
								_tmp257_ = _tmp256_[0];
								switch (_tmp257_) {
									case '=':
									{
										gchar* _tmp258_;
										type = VALA_GENIE_TOKEN_TYPE_OP_LE;
										_tmp258_ = self->priv->current;
										self->priv->current = _tmp258_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp259_;
										gboolean _tmp260_ = FALSE;
										gchar* _tmp261_;
										gchar* _tmp262_;
										type = VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp259_ = self->priv->current;
										self->priv->current = _tmp259_ + 1;
										_tmp261_ = self->priv->current;
										_tmp262_ = self->priv->end;
										if (_tmp261_ < _tmp262_) {
											gchar* _tmp263_;
											gchar _tmp264_;
											_tmp263_ = self->priv->current;
											_tmp264_ = _tmp263_[0];
											_tmp260_ = _tmp264_ == '=';
										} else {
											_tmp260_ = FALSE;
										}
										if (_tmp260_) {
											gchar* _tmp265_;
											type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp265_ = self->priv->current;
											self->priv->current = _tmp265_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp266_;
							gboolean _tmp267_ = FALSE;
							gchar* _tmp268_;
							gchar* _tmp269_;
							type = VALA_GENIE_TOKEN_TYPE_OP_GT;
							_tmp266_ = self->priv->current;
							self->priv->current = _tmp266_ + 1;
							_tmp268_ = self->priv->current;
							_tmp269_ = self->priv->end;
							if (_tmp268_ < _tmp269_) {
								gchar* _tmp270_;
								gchar _tmp271_;
								_tmp270_ = self->priv->current;
								_tmp271_ = _tmp270_[0];
								_tmp267_ = _tmp271_ == '=';
							} else {
								_tmp267_ = FALSE;
							}
							if (_tmp267_) {
								gchar* _tmp272_;
								type = VALA_GENIE_TOKEN_TYPE_OP_GE;
								_tmp272_ = self->priv->current;
								self->priv->current = _tmp272_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp273_;
							gboolean _tmp274_ = FALSE;
							gchar* _tmp275_;
							gchar* _tmp276_;
							type = VALA_GENIE_TOKEN_TYPE_OP_NEG;
							_tmp273_ = self->priv->current;
							self->priv->current = _tmp273_ + 1;
							_tmp275_ = self->priv->current;
							_tmp276_ = self->priv->end;
							if (_tmp275_ < _tmp276_) {
								gchar* _tmp277_;
								gchar _tmp278_;
								_tmp277_ = self->priv->current;
								_tmp278_ = _tmp277_[0];
								_tmp274_ = _tmp278_ == '=';
							} else {
								_tmp274_ = FALSE;
							}
							if (_tmp274_) {
								gchar* _tmp279_;
								type = VALA_GENIE_TOKEN_TYPE_OP_NE;
								_tmp279_ = self->priv->current;
								self->priv->current = _tmp279_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp280_;
							gchar* _tmp281_;
							gchar* _tmp282_;
							type = VALA_GENIE_TOKEN_TYPE_PLUS;
							_tmp280_ = self->priv->current;
							self->priv->current = _tmp280_ + 1;
							_tmp281_ = self->priv->current;
							_tmp282_ = self->priv->end;
							if (_tmp281_ < _tmp282_) {
								gchar* _tmp283_;
								gchar _tmp284_;
								_tmp283_ = self->priv->current;
								_tmp284_ = _tmp283_[0];
								switch (_tmp284_) {
									case '=':
									{
										gchar* _tmp285_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD;
										_tmp285_ = self->priv->current;
										self->priv->current = _tmp285_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp286_;
										type = VALA_GENIE_TOKEN_TYPE_OP_INC;
										_tmp286_ = self->priv->current;
										self->priv->current = _tmp286_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp287_;
							gchar* _tmp288_;
							gchar* _tmp289_;
							type = VALA_GENIE_TOKEN_TYPE_MINUS;
							_tmp287_ = self->priv->current;
							self->priv->current = _tmp287_ + 1;
							_tmp288_ = self->priv->current;
							_tmp289_ = self->priv->end;
							if (_tmp288_ < _tmp289_) {
								gchar* _tmp290_;
								gchar _tmp291_;
								_tmp290_ = self->priv->current;
								_tmp291_ = _tmp290_[0];
								switch (_tmp291_) {
									case '=':
									{
										gchar* _tmp292_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB;
										_tmp292_ = self->priv->current;
										self->priv->current = _tmp292_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp293_;
										type = VALA_GENIE_TOKEN_TYPE_OP_DEC;
										_tmp293_ = self->priv->current;
										self->priv->current = _tmp293_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp294_;
										type = VALA_GENIE_TOKEN_TYPE_OP_PTR;
										_tmp294_ = self->priv->current;
										self->priv->current = _tmp294_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp295_;
							gboolean _tmp296_ = FALSE;
							gchar* _tmp297_;
							gchar* _tmp298_;
							type = VALA_GENIE_TOKEN_TYPE_STAR;
							_tmp295_ = self->priv->current;
							self->priv->current = _tmp295_ + 1;
							_tmp297_ = self->priv->current;
							_tmp298_ = self->priv->end;
							if (_tmp297_ < _tmp298_) {
								gchar* _tmp299_;
								gchar _tmp300_;
								_tmp299_ = self->priv->current;
								_tmp300_ = _tmp299_[0];
								_tmp296_ = _tmp300_ == '=';
							} else {
								_tmp296_ = FALSE;
							}
							if (_tmp296_) {
								gchar* _tmp301_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL;
								_tmp301_ = self->priv->current;
								self->priv->current = _tmp301_ + 1;
							}
							break;
						}
						case '/':
						{
							switch (self->priv->last_token) {
								case VALA_GENIE_TOKEN_TYPE_ASSIGN:
								case VALA_GENIE_TOKEN_TYPE_COMMA:
								case VALA_GENIE_TOKEN_TYPE_MINUS:
								case VALA_GENIE_TOKEN_TYPE_OP_AND:
								case VALA_GENIE_TOKEN_TYPE_OP_EQ:
								case VALA_GENIE_TOKEN_TYPE_OP_GE:
								case VALA_GENIE_TOKEN_TYPE_OP_GT:
								case VALA_GENIE_TOKEN_TYPE_OP_INC:
								case VALA_GENIE_TOKEN_TYPE_OP_LE:
								case VALA_GENIE_TOKEN_TYPE_OP_LT:
								case VALA_GENIE_TOKEN_TYPE_OP_NE:
								case VALA_GENIE_TOKEN_TYPE_OP_NEG:
								case VALA_GENIE_TOKEN_TYPE_OP_OR:
								case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
								case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
								case VALA_GENIE_TOKEN_TYPE_PLUS:
								case VALA_GENIE_TOKEN_TYPE_RETURN:
								{
									gchar* _tmp302_;
									type = VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_vala_array_add11 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_REGEX_LITERAL);
									_tmp302_ = self->priv->current;
									self->priv->current = _tmp302_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp303_;
									gboolean _tmp304_ = FALSE;
									gchar* _tmp305_;
									gchar* _tmp306_;
									type = VALA_GENIE_TOKEN_TYPE_DIV;
									_tmp303_ = self->priv->current;
									self->priv->current = _tmp303_ + 1;
									_tmp305_ = self->priv->current;
									_tmp306_ = self->priv->end;
									if (_tmp305_ < _tmp306_) {
										gchar* _tmp307_;
										gchar _tmp308_;
										_tmp307_ = self->priv->current;
										_tmp308_ = _tmp307_[0];
										_tmp304_ = _tmp308_ == '=';
									} else {
										_tmp304_ = FALSE;
									}
									if (_tmp304_) {
										gchar* _tmp309_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV;
										_tmp309_ = self->priv->current;
										self->priv->current = _tmp309_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp310_;
							gboolean _tmp311_ = FALSE;
							gchar* _tmp312_;
							gchar* _tmp313_;
							type = VALA_GENIE_TOKEN_TYPE_PERCENT;
							_tmp310_ = self->priv->current;
							self->priv->current = _tmp310_ + 1;
							_tmp312_ = self->priv->current;
							_tmp313_ = self->priv->end;
							if (_tmp312_ < _tmp313_) {
								gchar* _tmp314_;
								gchar _tmp315_;
								_tmp314_ = self->priv->current;
								_tmp315_ = _tmp314_[0];
								_tmp311_ = _tmp315_ == '=';
							} else {
								_tmp311_ = FALSE;
							}
							if (_tmp311_) {
								gchar* _tmp316_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp316_ = self->priv->current;
								self->priv->current = _tmp316_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp317_;
							gchar _tmp318_;
							gchar* _tmp363_;
							gchar* _tmp437_;
							gchar* _tmp438_;
							_tmp317_ = begin;
							_tmp318_ = _tmp317_[0];
							if (_tmp318_ == '\'') {
								type = VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp319_ = FALSE;
								gboolean _tmp320_ = FALSE;
								gchar* _tmp321_;
								gchar* _tmp322_;
								_tmp321_ = self->priv->current;
								_tmp322_ = self->priv->end;
								if (_tmp321_ < (_tmp322_ - 6)) {
									gchar* _tmp323_;
									gchar _tmp324_;
									_tmp323_ = begin;
									_tmp324_ = _tmp323_[1];
									_tmp320_ = _tmp324_ == '"';
								} else {
									_tmp320_ = FALSE;
								}
								if (_tmp320_) {
									gchar* _tmp325_;
									gchar _tmp326_;
									_tmp325_ = begin;
									_tmp326_ = _tmp325_[2];
									_tmp319_ = _tmp326_ == '"';
								} else {
									_tmp319_ = FALSE;
								}
								if (_tmp319_) {
									gchar* _tmp327_;
									gboolean _tmp352_ = FALSE;
									gboolean _tmp353_ = FALSE;
									gchar* _tmp354_;
									gchar _tmp355_;
									type = VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp327_ = self->priv->current;
									self->priv->current = _tmp327_ + 3;
									while (TRUE) {
										gchar* _tmp328_;
										gchar* _tmp329_;
										gboolean _tmp330_ = FALSE;
										gboolean _tmp331_ = FALSE;
										gboolean _tmp332_ = FALSE;
										gchar* _tmp333_;
										gchar _tmp334_;
										_tmp328_ = self->priv->current;
										_tmp329_ = self->priv->end;
										if (!(_tmp328_ < (_tmp329_ - 4))) {
											break;
										}
										_tmp333_ = self->priv->current;
										_tmp334_ = _tmp333_[0];
										if (_tmp334_ == '"') {
											gchar* _tmp335_;
											gchar _tmp336_;
											_tmp335_ = self->priv->current;
											_tmp336_ = _tmp335_[1];
											_tmp332_ = _tmp336_ == '"';
										} else {
											_tmp332_ = FALSE;
										}
										if (_tmp332_) {
											gchar* _tmp337_;
											gchar _tmp338_;
											_tmp337_ = self->priv->current;
											_tmp338_ = _tmp337_[2];
											_tmp331_ = _tmp338_ == '"';
										} else {
											_tmp331_ = FALSE;
										}
										if (_tmp331_) {
											gchar* _tmp339_;
											gchar _tmp340_;
											_tmp339_ = self->priv->current;
											_tmp340_ = _tmp339_[3];
											_tmp330_ = _tmp340_ != '"';
										} else {
											_tmp330_ = FALSE;
										}
										if (_tmp330_) {
											break;
										} else {
											gchar* _tmp341_;
											gchar _tmp342_;
											_tmp341_ = self->priv->current;
											_tmp342_ = _tmp341_[0];
											if (_tmp342_ == '\n') {
												gchar* _tmp343_;
												gint _tmp344_;
												_tmp343_ = self->priv->current;
												self->priv->current = _tmp343_ + 1;
												_tmp344_ = self->priv->line;
												self->priv->line = _tmp344_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u = 0U;
												gchar* _tmp345_;
												gchar* _tmp346_;
												gchar* _tmp347_;
												_tmp345_ = self->priv->current;
												_tmp346_ = self->priv->end;
												_tmp347_ = self->priv->current;
												u = g_utf8_get_char_validated ((const gchar*) _tmp345_, (gssize) ((glong) (_tmp346_ - _tmp347_)));
												if (u != ((gunichar) -1)) {
													gchar* _tmp348_;
													gint _tmp349_;
													_tmp348_ = self->priv->current;
													self->priv->current = _tmp348_ + g_unichar_to_utf8 (u, NULL);
													_tmp349_ = token_length_in_chars;
													token_length_in_chars = _tmp349_ + 1;
												} else {
													ValaSourceReference* _tmp350_;
													ValaSourceReference* _tmp351_;
													_tmp350_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp351_ = _tmp350_;
													vala_report_error (_tmp351_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp351_);
												}
											}
										}
									}
									_tmp354_ = self->priv->current;
									_tmp355_ = _tmp354_[0];
									if (_tmp355_ == '"') {
										gchar* _tmp356_;
										gchar _tmp357_;
										_tmp356_ = self->priv->current;
										_tmp357_ = _tmp356_[1];
										_tmp353_ = _tmp357_ == '"';
									} else {
										_tmp353_ = FALSE;
									}
									if (_tmp353_) {
										gchar* _tmp358_;
										gchar _tmp359_;
										_tmp358_ = self->priv->current;
										_tmp359_ = _tmp358_[2];
										_tmp352_ = _tmp359_ == '"';
									} else {
										_tmp352_ = FALSE;
									}
									if (_tmp352_) {
										gchar* _tmp360_;
										_tmp360_ = self->priv->current;
										self->priv->current = _tmp360_ + 3;
									} else {
										ValaSourceReference* _tmp361_;
										ValaSourceReference* _tmp362_;
										_tmp361_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
										_tmp362_ = _tmp361_;
										vala_report_error (_tmp362_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp362_);
									}
									break;
								} else {
									type = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp363_ = self->priv->current;
							self->priv->current = _tmp363_ + 1;
							while (TRUE) {
								gboolean _tmp364_ = FALSE;
								gchar* _tmp365_;
								gchar* _tmp366_;
								gchar* _tmp371_;
								gchar _tmp372_;
								gboolean _tmp427_ = FALSE;
								gboolean _tmp428_ = FALSE;
								gchar* _tmp429_;
								gchar* _tmp430_;
								_tmp365_ = self->priv->current;
								_tmp366_ = self->priv->end;
								if (_tmp365_ < _tmp366_) {
									gchar* _tmp367_;
									gchar _tmp368_;
									gchar* _tmp369_;
									gchar _tmp370_;
									_tmp367_ = self->priv->current;
									_tmp368_ = _tmp367_[0];
									_tmp369_ = begin;
									_tmp370_ = _tmp369_[0];
									_tmp364_ = _tmp368_ != _tmp370_;
								} else {
									_tmp364_ = FALSE;
								}
								if (!_tmp364_) {
									break;
								}
								_tmp371_ = self->priv->current;
								_tmp372_ = _tmp371_[0];
								if (_tmp372_ == '\\') {
									gchar* _tmp373_;
									gint _tmp374_;
									gchar* _tmp375_;
									gchar* _tmp376_;
									gchar* _tmp377_;
									gchar _tmp378_;
									_tmp373_ = self->priv->current;
									self->priv->current = _tmp373_ + 1;
									_tmp374_ = token_length_in_chars;
									token_length_in_chars = _tmp374_ + 1;
									_tmp375_ = self->priv->current;
									_tmp376_ = self->priv->end;
									if (_tmp375_ >= _tmp376_) {
										break;
									}
									_tmp377_ = self->priv->current;
									_tmp378_ = _tmp377_[0];
									switch (_tmp378_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										case 'v':
										{
											gchar* _tmp379_;
											gint _tmp380_;
											_tmp379_ = self->priv->current;
											self->priv->current = _tmp379_ + 1;
											_tmp380_ = token_length_in_chars;
											token_length_in_chars = _tmp380_ + 1;
											break;
										}
										case 'u':
										{
											gchar* _tmp381_;
											gint _tmp382_;
											gint digit_length = 0;
											_tmp381_ = self->priv->current;
											self->priv->current = _tmp381_ + 1;
											_tmp382_ = token_length_in_chars;
											token_length_in_chars = _tmp382_ + 1;
											{
												gboolean _tmp383_ = FALSE;
												digit_length = 0;
												_tmp383_ = TRUE;
												while (TRUE) {
													gboolean _tmp385_ = FALSE;
													gchar* _tmp386_;
													gchar* _tmp387_;
													gchar* _tmp390_;
													gint _tmp391_;
													if (!_tmp383_) {
														gint _tmp384_;
														_tmp384_ = digit_length;
														digit_length = _tmp384_ + 1;
													}
													_tmp383_ = FALSE;
													_tmp386_ = self->priv->current;
													_tmp387_ = self->priv->end;
													if (_tmp386_ < _tmp387_) {
														gchar* _tmp388_;
														gchar _tmp389_;
														_tmp388_ = self->priv->current;
														_tmp389_ = _tmp388_[0];
														_tmp385_ = g_ascii_isxdigit (_tmp389_);
													} else {
														_tmp385_ = FALSE;
													}
													if (!_tmp385_) {
														break;
													}
													_tmp390_ = self->priv->current;
													self->priv->current = _tmp390_ + 1;
													_tmp391_ = token_length_in_chars;
													token_length_in_chars = _tmp391_ + 1;
												}
											}
											if (digit_length < 1) {
												ValaSourceReference* _tmp392_;
												ValaSourceReference* _tmp393_;
												_tmp392_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp393_ = _tmp392_;
												vala_report_error (_tmp393_, "\\u used with no following hex digits");
												_vala_source_reference_unref0 (_tmp393_);
											} else {
												if (digit_length < 4) {
													ValaSourceReference* _tmp394_;
													ValaSourceReference* _tmp395_;
													_tmp394_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp395_ = _tmp394_;
													vala_report_error (_tmp395_, "incomplete universal character name");
													_vala_source_reference_unref0 (_tmp395_);
												}
											}
											break;
										}
										case 'x':
										{
											gchar* _tmp396_;
											gint _tmp397_;
											gint digit_length = 0;
											_tmp396_ = self->priv->current;
											self->priv->current = _tmp396_ + 1;
											_tmp397_ = token_length_in_chars;
											token_length_in_chars = _tmp397_ + 1;
											{
												gboolean _tmp398_ = FALSE;
												digit_length = 0;
												_tmp398_ = TRUE;
												while (TRUE) {
													gboolean _tmp399_ = FALSE;
													gchar* _tmp400_;
													gchar* _tmp401_;
													gchar* _tmp404_;
													gchar _tmp405_;
													gchar* _tmp407_;
													gint _tmp408_;
													if (!_tmp398_) {
													}
													_tmp398_ = FALSE;
													_tmp400_ = self->priv->current;
													_tmp401_ = self->priv->end;
													if (_tmp400_ < _tmp401_) {
														gchar* _tmp402_;
														gchar _tmp403_;
														_tmp402_ = self->priv->current;
														_tmp403_ = _tmp402_[0];
														_tmp399_ = g_ascii_isxdigit (_tmp403_);
													} else {
														_tmp399_ = FALSE;
													}
													if (!_tmp399_) {
														break;
													}
													_tmp404_ = self->priv->current;
													_tmp405_ = _tmp404_[0];
													if (_tmp405_ != '0') {
														gint _tmp406_;
														_tmp406_ = digit_length;
														digit_length = _tmp406_ + 1;
													}
													_tmp407_ = self->priv->current;
													self->priv->current = _tmp407_ + 1;
													_tmp408_ = token_length_in_chars;
													token_length_in_chars = _tmp408_ + 1;
												}
											}
											if (digit_length < 1) {
												ValaSourceReference* _tmp409_;
												ValaSourceReference* _tmp410_;
												_tmp409_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
												_tmp410_ = _tmp409_;
												vala_report_error (_tmp410_, "\\x used with no following hex digits");
												_vala_source_reference_unref0 (_tmp410_);
											} else {
												if (digit_length > 2) {
													ValaSourceReference* _tmp411_;
													ValaSourceReference* _tmp412_;
													_tmp411_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
													_tmp412_ = _tmp411_;
													vala_report_error (_tmp412_, "hex escape sequence out of range");
													_vala_source_reference_unref0 (_tmp412_);
												}
											}
											break;
										}
										default:
										{
											ValaSourceReference* _tmp413_;
											ValaSourceReference* _tmp414_;
											_tmp413_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp414_ = _tmp413_;
											vala_report_error (_tmp414_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp414_);
											break;
										}
									}
								} else {
									gchar* _tmp415_;
									gchar _tmp416_;
									_tmp415_ = self->priv->current;
									_tmp416_ = _tmp415_[0];
									if (_tmp416_ == '\n') {
										gchar* _tmp417_;
										gint _tmp418_;
										_tmp417_ = self->priv->current;
										self->priv->current = _tmp417_ + 1;
										_tmp418_ = self->priv->line;
										self->priv->line = _tmp418_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u = 0U;
										gchar* _tmp419_;
										gchar* _tmp420_;
										gchar* _tmp421_;
										_tmp419_ = self->priv->current;
										_tmp420_ = self->priv->end;
										_tmp421_ = self->priv->current;
										u = g_utf8_get_char_validated ((const gchar*) _tmp419_, (gssize) ((glong) (_tmp420_ - _tmp421_)));
										if (u != ((gunichar) -1)) {
											gchar* _tmp422_;
											gint _tmp423_;
											_tmp422_ = self->priv->current;
											self->priv->current = _tmp422_ + g_unichar_to_utf8 (u, NULL);
											_tmp423_ = token_length_in_chars;
											token_length_in_chars = _tmp423_ + 1;
										} else {
											gchar* _tmp424_;
											ValaSourceReference* _tmp425_;
											ValaSourceReference* _tmp426_;
											_tmp424_ = self->priv->current;
											self->priv->current = _tmp424_ + 1;
											_tmp425_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
											_tmp426_ = _tmp425_;
											vala_report_error (_tmp426_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp426_);
										}
									}
								}
								_tmp429_ = self->priv->current;
								_tmp430_ = self->priv->end;
								if (_tmp429_ < _tmp430_) {
									gchar* _tmp431_;
									gchar _tmp432_;
									_tmp431_ = begin;
									_tmp432_ = _tmp431_[0];
									_tmp428_ = _tmp432_ == '\'';
								} else {
									_tmp428_ = FALSE;
								}
								if (_tmp428_) {
									gchar* _tmp433_;
									gchar _tmp434_;
									_tmp433_ = self->priv->current;
									_tmp434_ = _tmp433_[0];
									_tmp427_ = _tmp434_ != '\'';
								} else {
									_tmp427_ = FALSE;
								}
								if (_tmp427_) {
									ValaSourceReference* _tmp435_;
									ValaSourceReference* _tmp436_;
									_tmp435_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
									_tmp436_ = _tmp435_;
									vala_report_error (_tmp436_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp436_);
								}
							}
							_tmp437_ = self->priv->current;
							_tmp438_ = self->priv->end;
							if (_tmp437_ < _tmp438_) {
								gchar* _tmp439_;
								_tmp439_ = self->priv->current;
								self->priv->current = _tmp439_ + 1;
							} else {
								ValaSourceReference* _tmp440_;
								ValaSourceReference* _tmp441_;
								gchar* _tmp442_;
								gchar _tmp443_;
								_tmp440_ = vala_genie_scanner_get_source_reference (self, token_length_in_chars, 0);
								_tmp441_ = _tmp440_;
								_tmp442_ = begin;
								_tmp443_ = _tmp442_[0];
								vala_report_error (_tmp441_, "syntax error, expected %c", (gint) _tmp443_);
								_vala_source_reference_unref0 (_tmp441_);
							}
							break;
						}
						default:
						{
							gunichar u = 0U;
							gchar* _tmp444_;
							gchar* _tmp445_;
							gchar* _tmp446_;
							gint _tmp453_;
							ValaSourceLocation _tmp454_ = {0};
							ValaSourceLocation _tmp455_ = {0};
							ValaGenieTokenType _tmp456_;
							_tmp444_ = self->priv->current;
							_tmp445_ = self->priv->end;
							_tmp446_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp444_, (gssize) ((glong) (_tmp445_ - _tmp446_)));
							if (u != ((gunichar) -1)) {
								gchar* _tmp447_;
								ValaSourceReference* _tmp448_;
								ValaSourceReference* _tmp449_;
								_tmp447_ = self->priv->current;
								self->priv->current = _tmp447_ + g_unichar_to_utf8 (u, NULL);
								_tmp448_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp449_ = _tmp448_;
								vala_report_error (_tmp449_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp449_);
							} else {
								gchar* _tmp450_;
								ValaSourceReference* _tmp451_;
								ValaSourceReference* _tmp452_;
								_tmp450_ = self->priv->current;
								self->priv->current = _tmp450_ + 1;
								_tmp451_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp452_ = _tmp451_;
								vala_report_error (_tmp452_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp452_);
							}
							_tmp453_ = self->priv->column;
							self->priv->column = _tmp453_ + 1;
							_tmp456_ = vala_genie_scanner_read_token (self, &_tmp454_, &_tmp455_);
							_vala_token_begin = _tmp454_;
							_vala_token_end = _tmp455_;
							result = _tmp456_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	if (token_length_in_chars < 0) {
		gchar* _tmp457_;
		gchar* _tmp458_;
		_tmp457_ = self->priv->current;
		_tmp458_ = begin;
		self->priv->column = self->priv->column + ((gint) (_tmp457_ - _tmp458_));
	} else {
		self->priv->column = self->priv->column + token_length_in_chars;
	}
	_tmp459_ = self->priv->current;
	vala_source_location_init (&_vala_token_end, _tmp459_, self->priv->line, self->priv->column - 1);
	self->priv->last_token = type;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}

static gint
vala_genie_scanner_count_tabs (ValaGenieScanner* self)
{
	gint tab_count = 0;
	gboolean _tmp16_ = FALSE;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	tab_count = 0;
	if (self->priv->_indent_spaces == 0) {
		while (TRUE) {
			gboolean _tmp0_ = FALSE;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp1_ = self->priv->current;
			_tmp2_ = self->priv->end;
			if (_tmp1_ < _tmp2_) {
				gchar* _tmp3_;
				gchar _tmp4_;
				_tmp3_ = self->priv->current;
				_tmp4_ = _tmp3_[0];
				_tmp0_ = _tmp4_ == '\t';
			} else {
				_tmp0_ = FALSE;
			}
			if (!_tmp0_) {
				break;
			}
			_tmp5_ = self->priv->current;
			self->priv->current = _tmp5_ + 1;
			_tmp6_ = self->priv->column;
			self->priv->column = _tmp6_ + 1;
			_tmp7_ = tab_count;
			tab_count = _tmp7_ + 1;
		}
	} else {
		gint space_count = 0;
		space_count = 0;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp9_ = self->priv->current;
			_tmp10_ = self->priv->end;
			if (_tmp9_ < _tmp10_) {
				gchar* _tmp11_;
				gchar _tmp12_;
				_tmp11_ = self->priv->current;
				_tmp12_ = _tmp11_[0];
				_tmp8_ = _tmp12_ == ' ';
			} else {
				_tmp8_ = FALSE;
			}
			if (!_tmp8_) {
				break;
			}
			_tmp13_ = self->priv->current;
			self->priv->current = _tmp13_ + 1;
			_tmp14_ = self->priv->column;
			self->priv->column = _tmp14_ + 1;
			_tmp15_ = space_count;
			space_count = _tmp15_ + 1;
		}
		tab_count = space_count / self->priv->_indent_spaces;
	}
	vala_genie_scanner_space (self);
	_tmp17_ = self->priv->current;
	_tmp18_ = self->priv->end;
	if (_tmp17_ < _tmp18_) {
		gchar* _tmp19_;
		gchar _tmp20_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_[0];
		_tmp16_ = _tmp20_ == '\n';
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		result = -1;
		return result;
	}
	result = tab_count;
	return result;
}

static gboolean
vala_genie_scanner_matches (gchar* begin,
                            const gchar* keyword)
{
	gchar* keyword_array = NULL;
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	_tmp1_ = _tmp0_;
	len = (glong) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar _tmp4_;
				gchar* _tmp5_;
				gchar _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(((glong) i) < len)) {
					break;
				}
				_tmp4_ = begin[i];
				_tmp5_ = keyword_array;
				_tmp6_ = _tmp5_[i];
				if (_tmp4_ != _tmp6_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_genie_scanner_whitespace (ValaGenieScanner* self)
{
	gboolean found = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	if (self->priv->column == 1) {
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->current;
		_tmp13_ = self->priv->end;
		_tmp11_ = _tmp12_ < _tmp13_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->current;
		_tmp15_ = _tmp14_[0];
		_tmp10_ = _tmp15_ == '#';
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		vala_genie_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}

static inline gboolean
vala_genie_scanner_newline (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gchar _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ == '\n') {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_genie_scanner_skip_newlines (ValaGenieScanner* self)
{
	gboolean new_lines = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	new_lines = FALSE;
	while (TRUE) {
		gchar* _tmp0_;
		gint _tmp1_;
		if (!vala_genie_scanner_newline (self)) {
			break;
		}
		_tmp0_ = self->priv->current;
		self->priv->current = _tmp0_ + 1;
		_tmp1_ = self->priv->line;
		self->priv->line = _tmp1_ + 1;
		self->priv->column = 1;
		self->priv->current_indent_level = 0;
		new_lines = TRUE;
	}
	result = new_lines;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
vala_genie_scanner_comment (ValaGenieScanner* self,
                            gboolean file_comment)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp13_;
	gchar _tmp14_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		_tmp1_ = _tmp7_ != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != '/') {
			gchar* _tmp11_;
			gchar _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_[1];
			_tmp8_ = _tmp12_ != '*';
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_[1];
	if (_tmp14_ == '/') {
		ValaSourceReference* source_reference = NULL;
		gchar* _tmp16_;
		gboolean _tmp23_ = FALSE;
		gchar* _tmp24_;
		gchar _tmp25_;
		ValaSourceReference* _tmp28_;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp15_;
			_tmp15_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp15_;
		}
		_tmp16_ = self->priv->current;
		self->priv->current = _tmp16_ + 2;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp22_;
			_tmp18_ = self->priv->current;
			_tmp19_ = self->priv->end;
			if (_tmp18_ < _tmp19_) {
				gchar* _tmp20_;
				gchar _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = _tmp21_ != '\n';
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp22_ = self->priv->current;
			self->priv->current = _tmp22_ + 1;
		}
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_[0];
		if (_tmp25_ == '\n') {
			_tmp23_ = self->priv->last_token == VALA_GENIE_TOKEN_TYPE_EOL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gchar* _tmp26_;
			gint _tmp27_;
			_tmp26_ = self->priv->current;
			self->priv->current = _tmp26_ + 1;
			_tmp27_ = self->priv->line;
			self->priv->line = _tmp27_ + 1;
			self->priv->column = 1;
			self->priv->current_indent_level = 0;
		}
		_tmp28_ = source_reference;
		if (_tmp28_ != NULL) {
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ValaSourceReference* _tmp34_;
			_tmp29_ = self->priv->begin;
			_tmp30_ = self->priv->current;
			_tmp31_ = self->priv->begin;
			_tmp32_ = string_substring ((const gchar*) _tmp29_, (glong) 0, (glong) (_tmp30_ - _tmp31_));
			_tmp33_ = _tmp32_;
			_tmp34_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp33_, _tmp34_, file_comment);
			_g_free0 (_tmp33_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gchar* _tmp39_;
		gchar _tmp40_;
		gchar* _tmp42_;
		gchar* begin = NULL;
		gchar* _tmp43_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		ValaSourceReference* _tmp61_;
		gchar* _tmp68_;
		source_reference = NULL;
		if (file_comment) {
			gchar* _tmp36_;
			gchar _tmp37_;
			_tmp36_ = self->priv->current;
			_tmp37_ = _tmp36_[2];
			_tmp35_ = _tmp37_ == '*';
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp39_ = self->priv->current;
		_tmp40_ = _tmp39_[2];
		if (_tmp40_ == '*') {
			_tmp38_ = TRUE;
		} else {
			_tmp38_ = file_comment;
		}
		if (_tmp38_) {
			ValaSourceReference* _tmp41_;
			_tmp41_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp41_;
		}
		_tmp42_ = self->priv->current;
		self->priv->current = _tmp42_ + 2;
		_tmp43_ = self->priv->current;
		begin = _tmp43_;
		while (TRUE) {
			gboolean _tmp44_ = FALSE;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp52_;
			gchar _tmp53_;
			gchar* _tmp55_;
			gint _tmp56_;
			_tmp45_ = self->priv->current;
			_tmp46_ = self->priv->end;
			if (_tmp45_ < (_tmp46_ - 1)) {
				gboolean _tmp47_ = FALSE;
				gchar* _tmp48_;
				gchar _tmp49_;
				_tmp48_ = self->priv->current;
				_tmp49_ = _tmp48_[0];
				if (_tmp49_ != '*') {
					_tmp47_ = TRUE;
				} else {
					gchar* _tmp50_;
					gchar _tmp51_;
					_tmp50_ = self->priv->current;
					_tmp51_ = _tmp50_[1];
					_tmp47_ = _tmp51_ != '/';
				}
				_tmp44_ = _tmp47_;
			} else {
				_tmp44_ = FALSE;
			}
			if (!_tmp44_) {
				break;
			}
			_tmp52_ = self->priv->current;
			_tmp53_ = _tmp52_[0];
			if (_tmp53_ == '\n') {
				gint _tmp54_;
				_tmp54_ = self->priv->line;
				self->priv->line = _tmp54_ + 1;
				self->priv->column = 0;
			}
			_tmp55_ = self->priv->current;
			self->priv->current = _tmp55_ + 1;
			_tmp56_ = self->priv->column;
			self->priv->column = _tmp56_ + 1;
		}
		_tmp57_ = self->priv->current;
		_tmp58_ = self->priv->end;
		if (_tmp57_ == (_tmp58_ - 1)) {
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			_tmp59_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_tmp60_ = _tmp59_;
			vala_report_error (_tmp60_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp60_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp61_ = source_reference;
		if (_tmp61_ != NULL) {
			gchar* comment = NULL;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			const gchar* _tmp66_;
			ValaSourceReference* _tmp67_;
			_tmp62_ = begin;
			_tmp63_ = self->priv->current;
			_tmp64_ = begin;
			_tmp65_ = string_substring ((const gchar*) _tmp62_, (glong) 0, (glong) (_tmp63_ - _tmp64_));
			comment = _tmp65_;
			_tmp66_ = comment;
			_tmp67_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp66_, _tmp67_, file_comment);
			_g_free0 (comment);
		}
		_tmp68_ = self->priv->current;
		self->priv->current = _tmp68_ + 2;
		self->priv->column = self->priv->column + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_genie_scanner_skip_tabs (ValaGenieScanner* self)
{
	gboolean found = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = _tmp4_ == '\t';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		found = TRUE;
	}
	result = found;
	return result;
}

static void
vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_genie_scanner_skip_tabs (self);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static void
vala_genie_scanner_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

void
vala_genie_scanner_parse_file_comments (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, TRUE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                 const gchar* comment_item,
                                 ValaSourceReference* source_reference,
                                 gboolean file_comment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	if (string_get (comment_item, (glong) 0) == '*') {
		ValaComment* _tmp0_;
		ValaComment* _tmp3_;
		_tmp0_ = self->priv->_comment;
		if (_tmp0_ != NULL) {
			ValaSourceFile* _tmp1_;
			ValaComment* _tmp2_;
			_tmp1_ = self->priv->_source_file;
			_tmp2_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp1_, _tmp2_);
		}
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp3_;
	}
	if (file_comment) {
		ValaSourceFile* _tmp4_;
		ValaComment* _tmp5_;
		ValaComment* _tmp6_;
		_tmp4_ = self->priv->_source_file;
		_tmp5_ = vala_comment_new (comment_item, source_reference);
		_tmp6_ = _tmp5_;
		vala_source_file_add_comment (_tmp4_, _tmp6_);
		_vala_comment_unref0 (_tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}

/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}

ValaComment*
vala_genie_scanner_pop_comment (ValaGenieScanner* self)
{
	ValaComment* _tmp0_;
	ValaComment* comment = NULL;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	ValaComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}

static gboolean
vala_genie_scanner_pp_whitespace (ValaGenieScanner* self)
{
	gboolean found = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	result = found;
	return result;
}

static void
vala_genie_scanner_pp_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_pp_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}

static void
vala_genie_scanner_pp_directive (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gchar* begin = NULL;
	gchar* _tmp2_;
	gint len = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp21_ = FALSE;
	ValaGenieScannerConditional* _tmp22_;
	gint _tmp22__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	vala_genie_scanner_pp_space (self);
	_tmp2_ = self->priv->current;
	begin = _tmp2_;
	len = 0;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp3_ = g_ascii_isalnum (_tmp7_);
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
		_tmp10_ = len;
		len = _tmp10_ + 1;
	}
	if (len == 2) {
		gchar* _tmp12_;
		_tmp12_ = begin;
		_tmp11_ = vala_genie_scanner_matches (_tmp12_, "if");
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		vala_genie_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp13_ = FALSE;
		if (len == 4) {
			gchar* _tmp14_;
			_tmp14_ = begin;
			_tmp13_ = vala_genie_scanner_matches (_tmp14_, "elif");
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			vala_genie_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp15_ = FALSE;
			if (len == 4) {
				gchar* _tmp16_;
				_tmp16_ = begin;
				_tmp15_ = vala_genie_scanner_matches (_tmp16_, "else");
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				vala_genie_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp17_ = FALSE;
				if (len == 5) {
					gchar* _tmp18_;
					_tmp18_ = begin;
					_tmp17_ = vala_genie_scanner_matches (_tmp18_, "endif");
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					vala_genie_scanner_parse_pp_endif (self);
				} else {
					ValaSourceReference* _tmp19_;
					ValaSourceReference* _tmp20_;
					_tmp19_ = vala_genie_scanner_get_source_reference (self, -len, len);
					_tmp20_ = _tmp19_;
					vala_report_error (_tmp20_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp20_);
				}
			}
		}
	}
	_tmp22_ = self->priv->conditional_stack;
	_tmp22__length1 = self->priv->conditional_stack_length1;
	if (_tmp22__length1 > 0) {
		ValaGenieScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaGenieScannerConditional* _tmp24_;
		gint _tmp24__length1;
		ValaGenieScannerConditional _tmp25_;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp25_ = _tmp23_[_tmp24__length1 - 1];
		_tmp21_ = _tmp25_.skip_section;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gboolean bol = FALSE;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			gchar* _tmp35_;
			gchar _tmp36_;
			gchar* _tmp40_;
			gint _tmp41_;
			_tmp26_ = self->priv->current;
			_tmp27_ = self->priv->end;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			if (bol) {
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp30_ = self->priv->current;
				_tmp31_ = self->priv->end;
				_tmp29_ = _tmp30_ < _tmp31_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				gchar* _tmp32_;
				gchar _tmp33_;
				_tmp32_ = self->priv->current;
				_tmp33_ = _tmp32_[0];
				_tmp28_ = _tmp33_ == '#';
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gchar* _tmp34_;
				_tmp34_ = self->priv->current;
				self->priv->current = _tmp34_ - (self->priv->column - 1);
				self->priv->column = 1;
				return;
			}
			_tmp35_ = self->priv->current;
			_tmp36_ = _tmp35_[0];
			if (_tmp36_ == '\n') {
				gint _tmp37_;
				_tmp37_ = self->priv->line;
				self->priv->line = _tmp37_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp38_;
				gchar _tmp39_;
				_tmp38_ = self->priv->current;
				_tmp39_ = _tmp38_[0];
				if (!g_ascii_isspace (_tmp39_)) {
					bol = FALSE;
				}
			}
			_tmp40_ = self->priv->current;
			self->priv->current = _tmp40_ + 1;
			_tmp41_ = self->priv->column;
			self->priv->column = _tmp41_ + 1;
		}
	}
}

static void
vala_genie_scanner_pp_eol (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp6_);
	}
}

static void
_vala_array_add12 (ValaGenieScannerConditional* * array,
                   gint* length,
                   gint* size,
                   const ValaGenieScannerConditional* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
vala_genie_scanner_parse_pp_if (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	ValaGenieScannerConditional _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	memset (&_tmp0_, 0, sizeof (ValaGenieScannerConditional));
	_vala_array_add12 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp0_);
	if (condition) {
		gboolean _tmp2_ = FALSE;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		if (_tmp3__length1 == 1) {
			_tmp2_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp4_;
			gint _tmp4__length1;
			ValaGenieScannerConditional* _tmp5_;
			gint _tmp5__length1;
			ValaGenieScannerConditional _tmp6_;
			_tmp4_ = self->priv->conditional_stack;
			_tmp4__length1 = self->priv->conditional_stack_length1;
			_tmp5_ = self->priv->conditional_stack;
			_tmp5__length1 = self->priv->conditional_stack_length1;
			_tmp6_ = _tmp4_[_tmp5__length1 - 2];
			_tmp2_ = !_tmp6_.skip_section;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaGenieScannerConditional* _tmp7_;
		gint _tmp7__length1;
		ValaGenieScannerConditional* _tmp8_;
		gint _tmp8__length1;
		_tmp7_ = self->priv->conditional_stack;
		_tmp7__length1 = self->priv->conditional_stack_length1;
		_tmp8_ = self->priv->conditional_stack;
		_tmp8__length1 = self->priv->conditional_stack_length1;
		_tmp7_[_tmp8__length1 - 1].matched = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp9_;
		gint _tmp9__length1;
		ValaGenieScannerConditional* _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp9_[_tmp10__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	if (condition) {
		ValaGenieScannerConditional* _tmp9_;
		gint _tmp9__length1;
		ValaGenieScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaGenieScannerConditional _tmp11_;
		_tmp9_ = self->priv->conditional_stack;
		_tmp9__length1 = self->priv->conditional_stack_length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = _tmp9_[_tmp10__length1 - 1];
		_tmp8_ = !_tmp11_.matched;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp12_ = FALSE;
		ValaGenieScannerConditional* _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		if (_tmp13__length1 == 1) {
			_tmp12_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaGenieScannerConditional* _tmp15_;
			gint _tmp15__length1;
			ValaGenieScannerConditional _tmp16_;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = self->priv->conditional_stack;
			_tmp15__length1 = self->priv->conditional_stack_length1;
			_tmp16_ = _tmp14_[_tmp15__length1 - 2];
			_tmp12_ = !_tmp16_.skip_section;
		}
		_tmp7_ = _tmp12_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaGenieScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaGenieScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaGenieScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaGenieScannerConditional* _tmp20_;
		gint _tmp20__length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp17_[_tmp18__length1 - 1].matched = TRUE;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp19_[_tmp20__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaGenieScannerConditional* _tmp22_;
		gint _tmp22__length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_else (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp7_ = FALSE;
	ValaGenieScannerConditional* _tmp8_;
	gint _tmp8__length1;
	ValaGenieScannerConditional* _tmp9_;
	gint _tmp9__length1;
	ValaGenieScannerConditional _tmp10_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_.else_found;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp6_);
		return;
	}
	_tmp8_ = self->priv->conditional_stack;
	_tmp8__length1 = self->priv->conditional_stack_length1;
	_tmp9_ = self->priv->conditional_stack;
	_tmp9__length1 = self->priv->conditional_stack_length1;
	_tmp10_ = _tmp8_[_tmp9__length1 - 1];
	if (!_tmp10_.matched) {
		gboolean _tmp11_ = FALSE;
		ValaGenieScannerConditional* _tmp12_;
		gint _tmp12__length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		if (_tmp12__length1 == 1) {
			_tmp11_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp13_;
			gint _tmp13__length1;
			ValaGenieScannerConditional* _tmp14_;
			gint _tmp14__length1;
			ValaGenieScannerConditional _tmp15_;
			_tmp13_ = self->priv->conditional_stack;
			_tmp13__length1 = self->priv->conditional_stack_length1;
			_tmp14_ = self->priv->conditional_stack;
			_tmp14__length1 = self->priv->conditional_stack_length1;
			_tmp15_ = _tmp13_[_tmp14__length1 - 2];
			_tmp11_ = !_tmp15_.skip_section;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaGenieScannerConditional* _tmp16_;
		gint _tmp16__length1;
		ValaGenieScannerConditional* _tmp17_;
		gint _tmp17__length1;
		ValaGenieScannerConditional* _tmp18_;
		gint _tmp18__length1;
		ValaGenieScannerConditional* _tmp19_;
		gint _tmp19__length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		_tmp17_ = self->priv->conditional_stack;
		_tmp17__length1 = self->priv->conditional_stack_length1;
		_tmp16_[_tmp17__length1 - 1].matched = TRUE;
		_tmp18_ = self->priv->conditional_stack;
		_tmp18__length1 = self->priv->conditional_stack_length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp18_[_tmp19__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp20_;
		gint _tmp20__length1;
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp20_[_tmp21__length1 - 1].skip_section = TRUE;
	}
}

static void
vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self)
{
	ValaGenieScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}

static gboolean
vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self)
{
	gint len = 0;
	gchar* identifier = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean defined = FALSE;
	const gchar* _tmp12_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = vala_genie_scanner_is_ident_char (self, _tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		_tmp7_ = len;
		len = _tmp7_ + 1;
	}
	if (len == 0) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp9_);
		result = FALSE;
		return result;
	}
	_tmp10_ = self->priv->current;
	_tmp11_ = string_substring ((const gchar*) (_tmp10_ - len), (glong) 0, (glong) len);
	identifier = _tmp11_;
	_tmp12_ = identifier;
	if (g_strcmp0 (_tmp12_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = identifier;
		if (g_strcmp0 (_tmp13_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp14_;
			ValaCodeContext* _tmp15_;
			ValaCodeContext* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = self->priv->_source_file;
			_tmp15_ = vala_source_file_get_context (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = identifier;
			defined = vala_code_context_is_defined (_tmp16_, _tmp17_);
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		if (vala_genie_scanner_is_ident_char (self, _tmp5_)) {
			result = vala_genie_scanner_parse_pp_symbol (self);
			return result;
		} else {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			if (_tmp7_ == '(') {
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean _result_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->column;
				self->priv->column = _tmp9_ + 1;
				vala_genie_scanner_pp_space (self);
				_result_ = vala_genie_scanner_parse_pp_expression (self);
				vala_genie_scanner_pp_space (self);
				_tmp11_ = self->priv->current;
				_tmp12_ = self->priv->end;
				if (_tmp11_ < _tmp12_) {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == ')';
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					gint _tmp16_;
					_tmp15_ = self->priv->current;
					self->priv->current = _tmp15_ + 1;
					_tmp16_ = self->priv->column;
					self->priv->column = _tmp16_ + 1;
				} else {
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					_tmp17_ = vala_genie_scanner_get_source_reference (self, 0, 0);
					_tmp18_ = _tmp17_;
					vala_report_error (_tmp18_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp18_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp19_ = vala_genie_scanner_get_source_reference (self, 0, 0);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp20_);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		vala_genie_scanner_pp_space (self);
		result = !vala_genie_scanner_parse_pp_unary_expression (self);
		return result;
	}
	result = vala_genie_scanner_parse_pp_primary_expression (self);
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_unary_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '=';
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp8_;
			gboolean right = FALSE;
			_tmp8_ = self->priv->current;
			self->priv->current = _tmp8_ + 2;
			self->priv->column = self->priv->column + 2;
			vala_genie_scanner_pp_space (self);
			right = vala_genie_scanner_parse_pp_unary_expression (self);
			left = left == right;
		} else {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = self->priv->end;
			if (_tmp11_ < (_tmp12_ - 1)) {
				gchar* _tmp13_;
				gchar _tmp14_;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				_tmp10_ = _tmp14_ == '!';
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gchar* _tmp15_;
				gchar _tmp16_;
				_tmp15_ = self->priv->current;
				_tmp16_ = _tmp15_[1];
				_tmp9_ = _tmp16_ == '=';
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp17_;
				gboolean right = FALSE;
				_tmp17_ = self->priv->current;
				self->priv->current = _tmp17_ + 2;
				self->priv->column = self->priv->column + 2;
				vala_genie_scanner_pp_space (self);
				right = vala_genie_scanner_parse_pp_unary_expression (self);
				left = left != right;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_equality_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '&';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_equality_expression (self);
		if (left) {
			_tmp9_ = right;
		} else {
			_tmp9_ = FALSE;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self)
{
	gboolean left = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_and_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gboolean right = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '|';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		self->priv->column = self->priv->column + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_and_expression (self);
		if (left) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = right;
		}
		left = _tmp9_;
	}
	result = left;
	return result;
}

static gboolean
vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_genie_scanner_parse_pp_or_expression (self);
	return result;
}

static ValaGenieScannerConditional*
vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self)
{
	ValaGenieScannerConditional* dup;
	dup = g_new0 (ValaGenieScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaGenieScannerConditional));
	return dup;
}

static void
vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self)
{
	g_free (self);
}

static GType
vala_genie_scanner_conditional_get_type_once (void)
{
	GType vala_genie_scanner_conditional_type_id;
	vala_genie_scanner_conditional_type_id = g_boxed_type_register_static ("ValaGenieScannerConditional", (GBoxedCopyFunc) vala_genie_scanner_conditional_dup, (GBoxedFreeFunc) vala_genie_scanner_conditional_free);
	return vala_genie_scanner_conditional_type_id;
}

static GType
vala_genie_scanner_conditional_get_type (void)
{
	static volatile gsize vala_genie_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_conditional_type_id__volatile)) {
		GType vala_genie_scanner_conditional_type_id;
		vala_genie_scanner_conditional_type_id = vala_genie_scanner_conditional_get_type_once ();
		g_once_init_leave (&vala_genie_scanner_conditional_type_id__volatile, vala_genie_scanner_conditional_type_id);
	}
	return vala_genie_scanner_conditional_type_id__volatile;
}

static void
vala_genie_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_genie_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_genie_scanner_unref (value->data[0].v_pointer);
	}
}

static void
vala_genie_value_scanner_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_genie_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_genie_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_genie_value_scanner_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGenieScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_genie_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_genie_value_scanner_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	ValaGenieScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_genie_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
vala_genie_param_spec_scanner (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ValaGenieParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GENIE_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
vala_genie_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}

void
vala_genie_value_set_scanner (GValue* value,
                              gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_genie_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}

void
vala_genie_value_take_scanner (GValue* value,
                               gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}

static void
vala_genie_scanner_class_init (ValaGenieScannerClass * klass,
                               gpointer klass_data)
{
	vala_genie_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValaGenieScannerClass *) klass)->finalize = vala_genie_scanner_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGenieScanner_private_offset);
}

static void
vala_genie_scanner_instance_init (ValaGenieScanner * self,
                                  gpointer klass)
{
	self->priv = vala_genie_scanner_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_genie_scanner_finalize (ValaGenieScanner * obj)
{
	ValaGenieScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GENIE_TYPE_SCANNER, ValaGenieScanner);
	g_signal_handlers_destroy (self);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}

/**
 * Lexical scanner for Genie source files.
 */
static GType
vala_genie_scanner_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_genie_value_scanner_init, vala_genie_value_scanner_free_value, vala_genie_value_scanner_copy_value, vala_genie_value_scanner_peek_pointer, "p", vala_genie_value_scanner_collect_value, "p", vala_genie_value_scanner_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGenieScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieScanner), 0, (GInstanceInitFunc) vala_genie_scanner_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_genie_scanner_type_id;
	vala_genie_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenieScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaGenieScanner_private_offset = g_type_add_instance_private (vala_genie_scanner_type_id, sizeof (ValaGenieScannerPrivate));
	return vala_genie_scanner_type_id;
}

GType
vala_genie_scanner_get_type (void)
{
	static volatile gsize vala_genie_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_type_id__volatile)) {
		GType vala_genie_scanner_type_id;
		vala_genie_scanner_type_id = vala_genie_scanner_get_type_once ();
		g_once_init_leave (&vala_genie_scanner_type_id__volatile, vala_genie_scanner_type_id);
	}
	return vala_genie_scanner_type_id__volatile;
}

gpointer
vala_genie_scanner_ref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
vala_genie_scanner_unref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GENIE_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

