; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefixes=VEC256,AVX
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=VEC256,AVX512VL256
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512vl,-prefer-256-bit | FileCheck %s --check-prefixes=AVX512VL512
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512vl,+avx512bw,+avx512dq,+prefer-256-bit | FileCheck %s --check-prefixes=VEC256,SKX256
; RUN: opt < %s  -cost-model -analyze -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512vl,+avx512bw,+avx512dq,-prefer-256-bit | FileCheck %s --check-prefixes=SKX512

define void @zext256() "min-legal-vector-width"="256" {
; AVX-LABEL: 'zext256'
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL256-LABEL: 'zext256'
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL512-LABEL: 'zext256'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX256-LABEL: 'zext256'
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX512-LABEL: 'zext256'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %A = zext <8 x i16> undef to <8 x i64>
  %B = zext <8 x i32> undef to <8 x i64>
  %C = zext <16 x i8> undef to <16 x i32>
  %D = zext <16 x i16> undef to <16 x i32>
  %E = zext <32 x i8> undef to <32 x i16>
  ret void
}

define void @zext512() "min-legal-vector-width"="512" {
; AVX-LABEL: 'zext512'
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL256-LABEL: 'zext512'
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL512-LABEL: 'zext512'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX256-LABEL: 'zext512'
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX512-LABEL: 'zext512'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = zext <8 x i16> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = zext <8 x i32> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = zext <16 x i8> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = zext <16 x i16> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = zext <32 x i8> undef to <32 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %A = zext <8 x i16> undef to <8 x i64>
  %B = zext <8 x i32> undef to <8 x i64>
  %C = zext <16 x i8> undef to <16 x i32>
  %D = zext <16 x i16> undef to <16 x i32>
  %E = zext <32 x i8> undef to <32 x i16>
  ret void
}

define void @sext256() "min-legal-vector-width"="256" {
; AVX-LABEL: 'sext256'
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL256-LABEL: 'sext256'
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL512-LABEL: 'sext256'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX256-LABEL: 'sext256'
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX512-LABEL: 'sext256'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %A = sext <8 x i8> undef to <8 x i64>
  %B = sext <8 x i16> undef to <8 x i64>
  %C = sext <8 x i32> undef to <8 x i64>
  %D = sext <16 x i8> undef to <16 x i32>
  %E = sext <16 x i16> undef to <16 x i32>
  %F = sext <32 x i8> undef to <32 x i16>
  ret void
}

define void @sext512() "min-legal-vector-width"="512" {
; AVX-LABEL: 'sext512'
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL256-LABEL: 'sext512'
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL512-LABEL: 'sext512'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX256-LABEL: 'sext512'
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX512-LABEL: 'sext512'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = sext <8 x i8> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %B = sext <8 x i16> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %C = sext <8 x i32> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %D = sext <16 x i8> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %E = sext <16 x i16> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F = sext <32 x i8> undef to <32 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %A = sext <8 x i8> undef to <8 x i64>
  %B = sext <8 x i16> undef to <8 x i64>
  %C = sext <8 x i32> undef to <8 x i64>
  %D = sext <16 x i8> undef to <16 x i32>
  %E = sext <16 x i16> undef to <16 x i32>
  %F = sext <32 x i8> undef to <32 x i16>
  ret void
}

define void @trunc256() "min-legal-vector-width"="256" {
; VEC256-LABEL: 'trunc256'
; VEC256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %A = trunc <8 x i64> undef to <8 x i32>
; VEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %B = trunc <8 x i64> undef to <8 x i16>
; VEC256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %C = trunc <8 x i64> undef to <8 x i8>
; VEC256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %D = trunc <16 x i32> undef to <16 x i16>
; VEC256-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %E = trunc <16 x i32> undef to <16 x i8>
; VEC256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %F = trunc <32 x i16> undef to <32 x i8>
; VEC256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512VL512-LABEL: 'trunc256'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = trunc <8 x i64> undef to <8 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %B = trunc <8 x i64> undef to <8 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %C = trunc <8 x i64> undef to <8 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %D = trunc <16 x i32> undef to <16 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %E = trunc <16 x i32> undef to <16 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %F = trunc <32 x i16> undef to <32 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SKX512-LABEL: 'trunc256'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %A = trunc <8 x i64> undef to <8 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %B = trunc <8 x i64> undef to <8 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %C = trunc <8 x i64> undef to <8 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %D = trunc <16 x i32> undef to <16 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %E = trunc <16 x i32> undef to <16 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %F = trunc <32 x i16> undef to <32 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %A = trunc <8 x i64> undef to <8 x i32>
  %B = trunc <8 x i64> undef to <8 x i16>
  %C = trunc <8 x i64> undef to <8 x i8>
  %D = trunc <16 x i32> undef to <16 x i16>
  %E = trunc <16 x i32> undef to <16 x i8>
  %F = trunc <32 x i16> undef to <32 x i8>
  ret void
}

define i32 @zext256_vXi1() "min-legal-vector-width"="256" {
; AVX-LABEL: 'zext256_vXi1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512VL256-LABEL: 'zext256_vXi1'
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512VL512-LABEL: 'zext256_vXi1'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SKX256-LABEL: 'zext256_vXi1'
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SKX512-LABEL: 'zext256_vXi1'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = zext <2 x i1> undef to <2 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = zext <4 x i1> undef to <4 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = zext <8 x i1> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = zext <2 x i1> undef to <2 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = zext <4 x i1> undef to <4 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = zext <8 x i1> undef to <8 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = zext <16 x i1> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = zext <2 x i1> undef to <2 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = zext <4 x i1> undef to <4 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = zext <8 x i1> undef to <8 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = zext <16 x i1> undef to <16 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i16 = zext <32 x i1> undef to <32 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = zext <2 x i1> undef to <2 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = zext <4 x i1> undef to <4 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = zext <8 x i1> undef to <8 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = zext <16 x i1> undef to <16 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = zext <32 x i1> undef to <32 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = zext <64 x i1> undef to <64 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %V2i64 = zext <2 x i1> undef to <2 x i64>
  %V4i64 = zext <4 x i1> undef to <4 x i64>
  %V8i64 = zext <8 x i1> undef to <8 x i64>

  %V2i32 = zext <2 x i1> undef to <2 x i32>
  %V4i32 = zext <4 x i1> undef to <4 x i32>
  %V8i32 = zext <8 x i1> undef to <8 x i32>
  %V16i32 = zext <16 x i1> undef to <16 x i32>

  %V2i16 = zext <2 x i1> undef to <2 x i16>
  %V4i16 = zext <4 x i1> undef to <4 x i16>
  %V8i16 = zext <8 x i1> undef to <8 x i16>
  %V16i16 = zext <16 x i1> undef to <16 x i16>
  %V32i16 = zext <32 x i1> undef to <32 x i16>

  %V2i8 = zext <2 x i1> undef to <2 x i8>
  %V4i8 = zext <4 x i1> undef to <4 x i8>
  %V8i8 = zext <8 x i1> undef to <8 x i8>
  %V16i8 = zext <16 x i1> undef to <16 x i8>
  %V32i8 = zext <32 x i1> undef to <32 x i8>
  %V64i8 = zext <64 x i1> undef to <64 x i8>

  ret i32 undef
}

define i32 @sext256_vXi1() "min-legal-vector-width"="256" {
; AVX-LABEL: 'sext256_vXi1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512VL256-LABEL: 'sext256_vXi1'
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 21 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 42 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512VL512-LABEL: 'sext256_vXi1'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SKX256-LABEL: 'sext256_vXi1'
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SKX512-LABEL: 'sext256_vXi1'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I64 = sext i1 undef to i64
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i64 = sext <2 x i1> undef to <2 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i64 = sext <4 x i1> undef to <4 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i64 = sext <8 x i1> undef to <8 x i64>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I32 = sext i1 undef to i32
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = sext <2 x i1> undef to <2 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i32 = sext <4 x i1> undef to <4 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i32 = sext <8 x i1> undef to <8 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i32 = sext <16 x i1> undef to <16 x i32>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I16 = sext i1 undef to i16
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = sext <2 x i1> undef to <2 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = sext <4 x i1> undef to <4 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i16 = sext <8 x i1> undef to <8 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i16 = sext <16 x i1> undef to <16 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i16 = sext <32 x i1> undef to <32 x i16>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %I8 = sext i1 undef to i8
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = sext <2 x i1> undef to <2 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = sext <4 x i1> undef to <4 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = sext <8 x i1> undef to <8 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16i8 = sext <16 x i1> undef to <16 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V32i8 = sext <32 x i1> undef to <32 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V64i8 = sext <64 x i1> undef to <64 x i8>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %I64 = sext i1 undef to i64
  %V2i64 = sext <2 x i1> undef to <2 x i64>
  %V4i64 = sext <4 x i1> undef to <4 x i64>
  %V8i64 = sext <8 x i1> undef to <8 x i64>

  %I32 = sext i1 undef to i32
  %V2i32 = sext <2 x i1> undef to <2 x i32>
  %V4i32 = sext <4 x i1> undef to <4 x i32>
  %V8i32 = sext <8 x i1> undef to <8 x i32>
  %V16i32 = sext <16 x i1> undef to <16 x i32>

  %I16 = sext i1 undef to i16
  %V2i16 = sext <2 x i1> undef to <2 x i16>
  %V4i16 = sext <4 x i1> undef to <4 x i16>
  %V8i16 = sext <8 x i1> undef to <8 x i16>
  %V16i16 = sext <16 x i1> undef to <16 x i16>
  %V32i16 = sext <32 x i1> undef to <32 x i16>

  %I8 = sext i1 undef to i8
  %V2i8 = sext <2 x i1> undef to <2 x i8>
  %V4i8 = sext <4 x i1> undef to <4 x i8>
  %V8i8 = sext <8 x i1> undef to <8 x i8>
  %V16i8 = sext <16 x i1> undef to <16 x i8>
  %V32i8 = sext <32 x i1> undef to <32 x i8>
  %V64i8 = sext <64 x i1> undef to <64 x i8>

  ret i32 undef
}

define i32 @trunc_vXi1() "min-legal-vector-width"="256" {
; AVX-LABEL: 'trunc_vXi1'
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 46 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512VL256-LABEL: 'trunc_vXi1'
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512VL256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; AVX512VL512-LABEL: 'trunc_vXi1'
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512VL512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SKX256-LABEL: 'trunc_vXi1'
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SKX256-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
; SKX512-LABEL: 'trunc_vXi1'
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SKX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret i32 undef
;
  %V2i64 = trunc <2 x i64> undef to <2 x i1>
  %V4i64 = trunc <4 x i64> undef to <4 x i1>
  %V8i64 = trunc <8 x i64> undef to <8 x i1>
  %V16i64 = trunc <16 x i64> undef to <16 x i1>
  %V32i64 = trunc <32 x i64> undef to <32 x i1>
  %V64i64 = trunc <64 x i64> undef to <64 x i1>

  %V2i32 = trunc <2 x i32> undef to <2 x i1>
  %V4i32 = trunc <4 x i32> undef to <4 x i1>
  %V8i32 = trunc <8 x i32> undef to <8 x i1>
  %V16i32 = trunc <16 x i32> undef to <16 x i1>
  %V32i32 = trunc <32 x i32> undef to <32 x i1>
  %V64i32 = trunc <64 x i32> undef to <64 x i1>

  %V2i16 = trunc <2 x i16> undef to <2 x i1>
  %V4i16 = trunc <4 x i16> undef to <4 x i1>
  %V8i16 = trunc <8 x i16> undef to <8 x i1>
  %V16i16 = trunc <16 x i16> undef to <16 x i1>
  %V32i16 = trunc <32 x i16> undef to <32 x i1>
  %V64i16 = trunc <64 x i16> undef to <64 x i1>

  %V2i8 = trunc <2 x i8> undef to <2 x i1>
  %V4i8 = trunc <4 x i8> undef to <4 x i1>
  %V8i8 = trunc <8 x i8> undef to <8 x i1>
  %V16i8 = trunc <16 x i8> undef to <16 x i1>
  %V32i8 = trunc <32 x i8> undef to <32 x i1>
  %V64i8 = trunc <64 x i8> undef to <64 x i1>

  ret i32 undef
}
