'\" t
.TH IBM_HOSTS 5 "02 February 2007"
.SH "NAME"
ibm_hosts \- host database for x3270 and c3270
.SH "SYNOPSIS"
/usr/lib/X11/x3270/ibm_hosts
.SH "DESCRIPTION"
The \fBibm_hosts\fP
file contains information regarding IBM hosts on the network.
An \fIIBM host\fP is a host which can communicate with a 3270 terminal
emulator such as \fBx3270\fP or \fBc3270\fP.
Each line defines a name in the following 
(optional fields are shown in brackets):
.LP
\fIname\fP	\fItype\fP [\fIopt\fP:]...[\fIluname\fP@]\fIhostname\fP[:\fIport\fP] [\fIactions\fP]
.LP
Items are separated by any number of blanks and/or TAB characters.
A line beginning with # is taken as a comment (note that # anywhere
else on a line does \fInot\fP indicate a comment).
.LP
The \fIname\fP field is a mnemonic used to identify the host.
.LP
The \fItype\fP field is a keyword that indicates the type of entry.
The value \fBprimary\fP means that the \fIname\fP
will be included in host-selection menus that may be displayed by a
3270 emulator.
The value \fBalias\fP means that the \fIname\fP
will not be included in menus, but will still be accepted as valid input
when a host name is required.
.LP
The \fIhostname\fP
field is the Internet hostname or dot-notation Internet address of the host.
.LP
The \fIhostname\fP
can include `s:' or `p:' prefixes, e.g., \fBs:finicky\fP
(see the \fIx3270\fP(1) or
\fIc3270\fP(1) man page sfor details).
It can also include an LU name, separated by an `@' character, e.g.,
\fBoddlu@bluehost\fP.
Finally, it can include a non-default \fIport\fP number, appended to the
\fIhostname\fP with a colon `:' character, e.g.,
\fBbluehost:97\fP.
(For compatability with earlier versions of \fIx3270\fP,
the \fIport\fP can also be separated by a slash `/' character.)
.LP
The optional \fIactions\fP
field specifies actions to be taken once the connection is made and a
data-entry field is defined.
If the text looks like an action, e.g.,
\fBPF(1)\fP,
it is unmodified; otherwise it is taken as the parameter to the
\fBString()\fP
action.
The
\fIactions\fP
are not intended for entering usernames and passwords; rather they provide an
automated way of specifying a front-end menu option.
.SH "EXAMPLE"
Given the following
\fBibm_hosts\fP
file:
.LP
.RS
mvs	primary	mvs-host
.br
tso	alias	mvs-host
.br
mvs2	primary	mvs-host:4012
.br
vm	primary	vtam	Tab() String(3) Enter()

.RE
A 3270 emulator will display four names (\fBmvs\fP, \fBmvs2\fP,
\fBafhost\fP and \fBvm\fP) on its hosts menu.
The names \fBmvs\fP and \fBtso\fP will cause connections to the host
\fBmvs-host\fP.
The name \fBmvs2\fP will also cause a connection to
\fBmvs-host\fP,
but to port 4012 rather than the emulator's default port (usually 23).
The name \fBvm\fP will cause the 3270 emulator to connect to the host
\fBvtam\fP (presumably some sort of host-selection front-end),
enter the string `3' on the second data-entry field on the screen, and
send the Enter \s-1AID\s+1 sequence.
.SH "FILES"
/usr/lib/X11/x3270/ibm_hosts
.SH "SEE ALSO"
x3270(1),
c3270(1)
